/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.mounts;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.cosmetics.mounts.Mount;
import be.isach.ultracosmetics.cosmetics.type.MountType;
import be.isach.ultracosmetics.player.UltraPlayer;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public abstract class MountFlyingSnake
extends Mount {
    private final ItemStack tailItem;
    private final List<ArmorStand> tail = new ArrayList<ArmorStand>();

    public MountFlyingSnake(UltraPlayer owner, MountType type, UltraCosmetics ultraCosmetics, ItemStack tailItem) {
        super(owner, type, ultraCosmetics);
        this.tailItem = tailItem;
    }

    @Override
    public void setupEntity() {
        this.setupMainEntity();
        this.summonTailPart(25);
    }

    public abstract void setupMainEntity();

    @Override
    public void onUpdate() {
        Player player = this.getPlayer();
        if (player == null) {
            return;
        }
        Vector playerVector = player.getLocation().getDirection().multiply(1.75 * ((MountType)this.getType()).getMovementSpeed());
        this.entity.setVelocity(playerVector);
        Location lastLocation = this.entity.getLocation().subtract(0.0, 1.3, 0.0);
        for (ArmorStand armorStand : this.tail) {
            Location loc = armorStand.getLocation();
            Location deltaLoc = loc.clone().subtract(lastLocation);
            double yaw = -Math.atan2(deltaLoc.getX(), deltaLoc.getZ());
            double hyp = deltaLoc.getX() * deltaLoc.getX() + deltaLoc.getZ() * deltaLoc.getZ();
            double pitch = Math.atan2(Math.sqrt(hyp), deltaLoc.getY());
            UltraCosmeticsData.get().getPlugin().getScheduler().teleportAsync((Entity)armorStand, lastLocation);
            armorStand.setHeadPose(new EulerAngle(pitch, 0.0, 0.0));
            armorStand.setRotation((float)Math.toDegrees(yaw), 0.0f);
            lastLocation = loc;
        }
    }

    private void summonTailPart(int j) {
        Location location = this.getPlayer().getLocation();
        Vector v = this.getPlayer().getLocation().getDirection().multiply(-0.25);
        for (int i = 0; i < j; ++i) {
            ArmorStand armorStand = (ArmorStand)this.getPlayer().getWorld().spawn(location.add(v), ArmorStand.class);
            this.tail.add(armorStand);
            armorStand.setVisible(false);
            armorStand.setGravity(false);
            if (i > 0) {
                armorStand.getEquipment().setHelmet(this.tailItem);
            }
            armorStand.setMetadata("NO_INTER", (MetadataValue)new FixedMetadataValue((Plugin)this.getUltraCosmetics(), (Object)1));
            armorStand.setPersistent(false);
        }
    }

    @Override
    public void onClear() {
        super.onClear();
        for (Entity entity : this.tail) {
            entity.remove();
        }
        this.tail.clear();
    }
}

