/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.morphs;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.cosmetics.Updatable;
import be.isach.ultracosmetics.cosmetics.morphs.MorphLeftClickCooldown;
import be.isach.ultracosmetics.cosmetics.type.MorphType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.util.BlockUtils;
import com.cryptomorin.xseries.particles.ParticleDisplay;
import com.cryptomorin.xseries.particles.XParticle;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.util.Vector;

public class MorphPolarBear
extends MorphLeftClickCooldown
implements Updatable {
    private final ParticleDisplay display = ParticleDisplay.of((XParticle)XParticle.CLOUD).withCount(6).offset(0.3, 0.1, 0.3).withExtra(0.4);
    private boolean active;
    private Location location;
    private Vector vector;

    public MorphPolarBear(UltraPlayer owner, MorphType type, UltraCosmetics ultraCosmetics) {
        super(owner, type, ultraCosmetics, 15.0);
    }

    @Override
    public void onLeftClick(PlayerInteractEvent event) {
        event.setCancelled(true);
        this.vector = this.getPlayer().getLocation().getDirection().normalize().multiply(0.3).setY(-1);
        this.location = this.getPlayer().getLocation().add(this.vector);
        this.active = true;
        this.getUltraCosmetics().getScheduler().runAtEntityLater((Entity)this.getPlayer(), () -> {
            this.active = false;
        }, 40L);
    }

    @Override
    public void onUpdate() {
        if (!this.canUseSkill) {
            return;
        }
        if (!this.active) {
            this.location = null;
            this.vector = null;
            return;
        }
        if (this.location.getBlock().getType().isSolid()) {
            this.location.add(0.0, 1.0, 0.0);
        }
        if (BlockUtils.isAir(this.location.clone().subtract(0.0, 1.0, 0.0).getBlock().getType()) && !this.location.clone().getBlock().getType().toString().contains("SLAB")) {
            this.location.add(0.0, -1.0, 0.0);
        }
        for (int i = 0; i < 3; ++i) {
            UltraCosmeticsData.get().getVersionManager().getEntityUtil().sendBlizzard(this.getPlayer(), this.location, ent -> false, this.vector);
        }
        this.display.spawn(this.location.clone().subtract(0.0, 0.5, 0.0));
        this.location.add(this.vector);
    }

    @Override
    protected void onClear() {
        if (!this.canUseSkill) {
            return;
        }
        this.active = false;
        if (this.getOwner() != null && this.getPlayer() != null) {
            UltraCosmeticsData.get().getVersionManager().getEntityUtil().clearBlizzard(this.getPlayer());
        }
    }
}

