/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.morphs;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.cosmetics.PlayerAffectingCosmetic;
import be.isach.ultracosmetics.cosmetics.Updatable;
import be.isach.ultracosmetics.cosmetics.morphs.Morph;
import be.isach.ultracosmetics.cosmetics.type.MorphType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import be.isach.ultracosmetics.util.MathUtils;
import com.cryptomorin.xseries.XSound;
import com.cryptomorin.xseries.messages.ActionBar;
import com.cryptomorin.xseries.particles.ParticleDisplay;
import com.cryptomorin.xseries.particles.XParticle;
import me.libraryaddict.disguise.disguisetypes.watchers.CreeperWatcher;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class MorphCreeper
extends Morph
implements PlayerAffectingCosmetic,
Updatable {
    private int charge = 0;
    private final XSound.SoundPlayer chargeSound = XSound.ENTITY_CREEPER_PRIMED.record().withVolume(1.4f).withPitch(1.5f).soundPlayer().forPlayers(new Player[]{this.getPlayer()});
    private final XSound.SoundPlayer explodeSound = XSound.ENTITY_GENERIC_EXPLODE.record().withVolume(1.4f).withPitch(1.5f).soundPlayer().forPlayers(new Player[]{this.getPlayer()});
    private final ParticleDisplay display = ParticleDisplay.of((XParticle)XParticle.EXPLOSION_EMITTER).withEntity((Entity)this.getPlayer());

    public MorphCreeper(UltraPlayer owner, MorphType type, UltraCosmetics ultraCosmetics) {
        super(owner, type, ultraCosmetics);
    }

    @Override
    public void onUpdate() {
        if (!this.canUseSkill) {
            return;
        }
        CreeperWatcher creeperWatcher = (CreeperWatcher)this.disguise.getWatcher();
        if (this.getPlayer().isSneaking()) {
            creeperWatcher.setIgnited(true);
            if (this.charge + 4 <= 100) {
                this.charge += 4;
            }
            this.chargeSound.play();
        } else {
            if (creeperWatcher.isIgnited()) {
                this.onEquip();
            }
            if (this.charge == 100) {
                this.display.spawn();
                this.explodeSound.play();
                Player player = this.getPlayer();
                for (Entity ent : player.getNearbyEntities(3.0, 3.0, 3.0)) {
                    if (!this.canAffect(ent, player)) continue;
                    Vector vector = this.getVector(ent);
                    MathUtils.applyVelocity(ent, vector.multiply(1.3).add(new Vector(0.0, 1.4, 0.0)));
                }
                ActionBar.clearActionBar((Player)this.getPlayer());
                this.charge = 0;
                return;
            }
            if (this.charge > 0) {
                this.charge -= 4;
            }
        }
        if (this.charge > 0 && this.charge < 100) {
            if (this.charge < 5) {
                ActionBar.clearActionBar((Player)this.getPlayer());
            } else {
                ActionBar.sendActionBar((Player)this.getPlayer(), (String)MessageManager.getLegacyMessage("Morphs.Creeper.charging", Placeholder.unparsed("chargelevel", String.valueOf(this.charge))));
            }
        } else if (this.charge == 100) {
            ActionBar.sendActionBar((Player)this.getPlayer(), (String)MessageManager.getLegacyMessage("Morphs.Creeper.release-to-explode", new TagResolver.Single[0]));
        }
    }

    @NotNull
    private Vector getVector(Entity ent) {
        double dX = this.getPlayer().getLocation().getX() - ent.getLocation().getX();
        double dY = this.getPlayer().getLocation().getY() - ent.getLocation().getY();
        double dZ = this.getPlayer().getLocation().getZ() - ent.getLocation().getZ();
        double yaw = Math.atan2(dZ, dX);
        double pitch = Math.atan2(Math.sqrt(dZ * dZ + dX * dX), dY) + Math.PI;
        double x = Math.sin(pitch) * Math.cos(yaw);
        double y = Math.sin(pitch) * Math.sin(yaw);
        double z = Math.cos(pitch);
        return new Vector(x, z, y);
    }
}

