/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.morphs;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.cosmetics.Updatable;
import be.isach.ultracosmetics.cosmetics.morphs.Morph;
import be.isach.ultracosmetics.cosmetics.type.MorphType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.shaded.mobchip.EntityBrain;
import be.isach.ultracosmetics.shaded.mobchip.bukkit.BukkitBrain;
import be.isach.ultracosmetics.util.ItemFactory;
import be.isach.ultracosmetics.util.PetPathfinder;
import com.cryptomorin.xseries.XMaterial;
import com.cryptomorin.xseries.XSound;
import com.cryptomorin.xseries.particles.ParticleDisplay;
import com.cryptomorin.xseries.particles.XParticle;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Particle;
import org.bukkit.entity.Chicken;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.ItemMergeEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.util.Vector;

public class MorphChicken
extends Morph
implements Updatable {
    private static final Particle BLOCK_PARTICLE = XParticle.BLOCK.get();
    private final List<Item> items = new ArrayList<Item>();
    private final List<Chicken> chickens = new ArrayList<Chicken>();
    private final XSound.SoundPlayer eggSound;
    private final XSound.SoundPlayer spawnSound = XSound.ENTITY_ZOMBIE_ATTACK_WOODEN_DOOR.record().withVolume(0.05f).withPitch(1.0f).soundPlayer();
    private final ParticleDisplay flameDisplay = ParticleDisplay.of((XParticle)XParticle.FLAME).withCount(10);

    public MorphChicken(UltraPlayer owner, MorphType type, UltraCosmetics ultraCosmetics) {
        super(owner, type, ultraCosmetics);
        this.eggSound = XSound.ENTITY_CHICKEN_EGG.record().withVolume(0.5f).withPitch(1.5f).soundPlayer().forPlayers(new Player[]{this.getPlayer()});
    }

    @EventHandler
    public void onPlayerToggleSneak(PlayerToggleSneakEvent event) {
        if (!this.canUseSkill || event.getPlayer() != this.getPlayer() || this.getOwner().getCurrentMorph() != this || !this.getOwner().getAndSetCooldown(this.cosmeticType, 30.0, 15.0)) {
            return;
        }
        this.items.clear();
        for (int j = 0; j < 10; ++j) {
            this.items.add(ItemFactory.createUnpickableItemVariance(XMaterial.EGG, this.getPlayer().getLocation(), RANDOM, 0.5));
            this.eggSound.play();
        }
        this.getUltraCosmetics().getScheduler().runAtEntityLater((Entity)this.getPlayer(), () -> {
            this.chickens.clear();
            for (Item i : this.items) {
                i.getWorld().spawnParticle(BLOCK_PARTICLE, i.getLocation(), 0, 0.0, 0.0, 0.0, 0.0, (Object)XMaterial.WHITE_TERRACOTTA.get().createBlockData());
                this.spawnSound.atLocation(i.getLocation()).play();
                Chicken chicken = (Chicken)i.getWorld().spawnEntity(i.getLocation(), EntityType.CHICKEN);
                chicken.setAgeLock(true);
                chicken.setBaby();
                chicken.setNoDamageTicks(Integer.MAX_VALUE);
                chicken.setVelocity(new Vector(0.0f, 0.5f, 0.0f));
                EntityBrain brain = BukkitBrain.getBrain((Mob)chicken);
                brain.getGoalAI().clear();
                brain.getTargetAI().clear();
                brain.getGoalAI().put(new PetPathfinder((Mob)chicken, this.getPlayer()), 0);
                i.remove();
                this.chickens.add(chicken);
            }
            this.getUltraCosmetics().getScheduler().runAtEntityLater((Entity)this.getPlayer(), this::onClear, 200L);
        }, 50L);
    }

    @EventHandler
    public void onItemMerge(ItemMergeEvent event) {
        if (this.items.contains(event.getEntity()) || this.items.contains(event.getTarget())) {
            event.setCancelled(true);
        }
    }

    @Override
    protected void onClear() {
        for (Chicken chicken : this.chickens) {
            this.flameDisplay.spawn(chicken.getLocation());
            chicken.remove();
        }
        this.chickens.clear();
    }

    @Override
    public void onUpdate() {
        if (!this.canUseSkill) {
            return;
        }
        Player player = this.getPlayer();
        boolean onGround = player.isOnGround();
        if (onGround || player.getVelocity().getY() >= 0.0) {
            return;
        }
        Vector velocity = player.getVelocity();
        velocity.setY(velocity.getY() * 0.85);
        player.setVelocity(velocity);
    }
}

