/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.gadgets;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.cosmetics.PlayerAffectingCosmetic;
import be.isach.ultracosmetics.cosmetics.Updatable;
import be.isach.ultracosmetics.cosmetics.gadgets.Gadget;
import be.isach.ultracosmetics.cosmetics.type.GadgetType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import be.isach.ultracosmetics.util.BlockUtils;
import be.isach.ultracosmetics.util.PortalLoc;
import com.cryptomorin.xseries.XSound;
import com.cryptomorin.xseries.particles.ParticleDisplay;
import com.cryptomorin.xseries.particles.Particles;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.util.Vector;

public class GadgetPortalGun
extends Gadget
implements PlayerAffectingCosmetic,
Updatable {
    private static final double CIRCLE_STEP = 0.3141592653589793;
    private final Set<UUID> playersOnCooldown = new HashSet<UUID>();
    private final PortalLoc red = new PortalLoc(255, 0, 0);
    private final PortalLoc blue = new PortalLoc(31, 0, 127);
    private final boolean affectsOthers;
    private final XSound.SoundPlayer useSound;
    private final XSound.Record teleportSound;

    public GadgetPortalGun(UltraPlayer owner, GadgetType type, UltraCosmetics ultraCosmetics) {
        super(owner, type, ultraCosmetics);
        this.displayCooldownMessage = false;
        this.affectsOthers = SettingsManager.getConfig().getBoolean(this.getOptionPath("Affects-Others"));
        this.useSound = XSound.ENTITY_ENDERMAN_TELEPORT.record().withVolume(0.2f).withPitch(1.5f).soundPlayer().forPlayers(new Player[]{this.getPlayer()});
        this.teleportSound = XSound.ENTITY_ENDERMAN_TELEPORT.record();
    }

    @Override
    protected void onRightClick() {
        this.handleClick(this.blue);
    }

    @Override
    protected void onLeftClick() {
        this.handleClick(this.red);
    }

    private void handleClick(PortalLoc portalLoc) {
        this.useSound.play();
        List sight = this.getPlayer().getLastTwoTargetBlocks(null, 20);
        Block target = (Block)sight.get(1);
        Location playerFaceLoc = this.getPlayer().getEyeLocation().add(this.getPlayer().getEyeLocation().getDirection().multiply(0.6));
        Particles.line((Location)playerFaceLoc, (Location)target.getLocation(), (double)0.25, (ParticleDisplay)portalLoc.getParticle());
        BlockFace face = this.getBlockFace((Block)sight.get(0), target);
        Location loc = target.getRelative(face).getLocation().add(0.5, 0.5, 0.5);
        Vector faceVector = new Vector(face.getModX(), face.getModY(), face.getModZ());
        loc.add(faceVector.multiply(-0.25));
        portalLoc.setLocation(loc);
        portalLoc.setFace(face);
    }

    public float getPitch(BlockFace bf) {
        if (bf == BlockFace.UP) {
            return -90.0f;
        }
        if (bf == BlockFace.DOWN) {
            return 90.0f;
        }
        return 0.0f;
    }

    public float getYaw(BlockFace bf) {
        if (bf == BlockFace.WEST) {
            return 90.0f;
        }
        if (bf == BlockFace.EAST) {
            return -90.0f;
        }
        if (bf == BlockFace.NORTH) {
            return 180.0f;
        }
        return 0.0f;
    }

    public BlockFace getBlockFace(Block a, Block b) {
        for (BlockFace bf : BlockFace.values()) {
            if (!a.getRelative(bf).getLocation().equals((Object)b.getLocation())) continue;
            return bf.getOppositeFace();
        }
        return null;
    }

    private boolean portalTeleportCheck(Player player, PortalLoc portalLoc, PortalLoc dest) {
        BlockFace face = portalLoc.getFace();
        Location playerLoc = face == BlockFace.DOWN ? player.getEyeLocation() : (face == BlockFace.UP ? player.getLocation() : player.getLocation().add(0.0, 1.0, 0.0));
        if (playerLoc.getWorld() != portalLoc.getLocation().getWorld() || playerLoc.distanceSquared(portalLoc.getLocation()) > 1.0) {
            return false;
        }
        this.playersOnCooldown.add(player.getUniqueId());
        Location loc = dest.getLocation().clone();
        BlockFace destFace = dest.getFace();
        loc.setYaw(this.getYaw(destFace));
        loc.setPitch(this.getPitch(destFace));
        this.teleport((Entity)player, loc, destFace.getDirection().multiply(0.3));
        this.getUltraCosmetics().getScheduler().runAtEntityLater((Entity)this.getPlayer(), () -> this.playersOnCooldown.remove(player.getUniqueId()), 20L);
        return true;
    }

    private void checkPortals() {
        if (!this.red.isValid() || !this.blue.isValid()) {
            return;
        }
        if (this.red.getLocation().getWorld() != this.blue.getLocation().getWorld()) {
            this.red.clear();
            this.blue.clear();
            MessageManager.send((CommandSender)this.getPlayer(), "Gadgets.PortalGun.Different-Worlds", new TagResolver.Single[0]);
            return;
        }
        Player owner = this.getPlayer();
        for (Player player : owner.getWorld().getPlayers()) {
            if (this.playersOnCooldown.contains(player.getUniqueId()) || player != owner && (!this.affectsOthers || !this.canAffect((Entity)player, owner)) || this.portalTeleportCheck(player, this.red, this.blue)) continue;
            this.portalTeleportCheck(player, this.blue, this.red);
        }
    }

    private void showParticles(PortalLoc portalLoc) {
        if (!portalLoc.isValid()) {
            return;
        }
        Location loc = portalLoc.getLocation().clone();
        BlockFace face = portalLoc.getFace();
        ParticleDisplay particle = portalLoc.getParticle();
        for (int i = 0; i < 20; ++i) {
            double angle = (double)i * 0.3141592653589793;
            Vector v = new Vector();
            double a1 = Math.cos(angle);
            double a2 = Math.sin(angle);
            if (face == BlockFace.NORTH || face == BlockFace.SOUTH) {
                v.setX(a1);
                v.setY(a2);
            } else if (face == BlockFace.EAST || face == BlockFace.WEST) {
                v.setY(a1);
                v.setZ(a2);
            } else {
                v.setX(a1);
                v.setZ(a2);
            }
            particle.spawn(loc.clone().add(v));
        }
    }

    @Override
    public void onUpdate() {
        this.checkPortals();
        this.showParticles(this.red);
        this.showParticles(this.blue);
    }

    @Override
    protected boolean checkRequirements(PlayerInteractEvent event) {
        List sight = this.getPlayer().getLastTwoTargetBlocks(null, 20);
        if (sight.size() < 2 || BlockUtils.isAir(((Block)sight.get(1)).getType())) {
            MessageManager.send((CommandSender)this.getPlayer(), "Gadgets.PortalGun.No-Block-Range", new TagResolver.Single[0]);
            return false;
        }
        return true;
    }

    private void teleport(Entity entity, Location location, Vector velocity) {
        this.getUltraCosmetics().getScheduler().runNextTick(task -> {
            this.getUltraCosmetics().getScheduler().teleportAsync(entity, location);
            entity.setVelocity(velocity);
            if (entity instanceof Player) {
                this.teleportSound.soundPlayer().forPlayers(new Player[]{(Player)entity}).play();
            }
        });
    }

    @Override
    public void onClear() {
        this.red.clear();
        this.blue.clear();
    }
}

