/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.gadgets;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.cosmetics.gadgets.Gadget;
import be.isach.ultracosmetics.cosmetics.type.GadgetType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.util.BlockUtils;
import be.isach.ultracosmetics.util.SmartLogger;
import com.cryptomorin.xseries.XMaterial;
import com.cryptomorin.xseries.XSound;
import com.cryptomorin.xseries.particles.ParticleDisplay;
import com.cryptomorin.xseries.particles.XParticle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

public class GadgetPaintballGun
extends Gadget {
    private static final List<XMaterial> PAINT_BLOCKS = new ArrayList<XMaterial>();
    private final Set<Projectile> projectiles = new HashSet<Projectile>();
    private final int radius;
    private final ParticleDisplay particle;
    private final XSound.SoundPlayer sound = XSound.ENTITY_CHICKEN_EGG.record().withVolume(1.5f).withPitch(1.2f).soundPlayer().forPlayers(new Player[]{this.getPlayer()});

    public GadgetPaintballGun(UltraPlayer owner, GadgetType type, UltraCosmetics ultraCosmetics) {
        super(owner, type, ultraCosmetics);
        XParticle effect;
        this.radius = SettingsManager.getConfig().getInt(this.getOptionPath("Radius"), 2);
        this.displayCooldownMessage = false;
        if (!SettingsManager.getConfig().getBoolean(this.getOptionPath("Particle.Enabled"))) {
            this.particle = null;
            return;
        }
        try {
            effect = XParticle.valueOf((String)SettingsManager.getConfig().getString(this.getOptionPath("Particle.Effect")));
        }
        catch (IllegalArgumentException ignored) {
            this.particle = null;
            return;
        }
        int particleCount = SettingsManager.getConfig().getInt(this.getOptionPath("Particle.Count"), 50);
        this.particle = ParticleDisplay.of((XParticle)effect).offset(2.5, 0.2, 2.5).withCount(particleCount);
    }

    @Override
    protected void onRightClick() {
        Projectile projectile = this.getPlayer().launchProjectile(EnderPearl.class, this.getPlayer().getLocation().getDirection().multiply(2));
        this.projectiles.add(projectile);
        this.sound.play();
    }

    @EventHandler
    public void onItemFrameBreak(HangingBreakByEntityEvent event) {
        if (this.projectiles.contains(event.getRemover())) {
            event.setCancelled(true);
        } else if (event.getRemover() == this.getPlayer()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onProjectileHit(ProjectileHitEvent event) {
        if (!this.projectiles.remove(event.getEntity())) {
            return;
        }
        Location center = event.getEntity().getLocation().add(event.getEntity().getVelocity());
        HashMap<Block, XMaterial> updates = new HashMap<Block, XMaterial>();
        for (Block block : BlockUtils.getBlocksInRadius(center.getBlock().getLocation(), this.radius, false)) {
            updates.put(block, PAINT_BLOCKS.get(RANDOM.nextInt(PAINT_BLOCKS.size())));
        }
        BlockUtils.setToRestore(updates, 60);
        if (this.particle != null) {
            this.particle.spawn(center.clone().add(0.5, 1.2, 0.5));
        }
        event.getEntity().remove();
        try {
            event.setCancelled(true);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    @EventHandler
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        if (event.getDamager().getType() != EntityType.ENDER_PEARL) {
            return;
        }
        if (this.projectiles.contains(event.getDamager())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityTeleport(PlayerTeleportEvent event) {
        if (event.getPlayer() == this.getPlayer() && event.getCause() == PlayerTeleportEvent.TeleportCause.ENDER_PEARL) {
            event.setCancelled(true);
        }
    }

    @Override
    public void onClear() {
        for (Projectile projectile : this.projectiles) {
            projectile.remove();
        }
        this.projectiles.clear();
    }

    static {
        String ending = SettingsManager.getConfig().getString("Gadgets.PaintballGun.Block-Type", "_TERRACOTTA").toUpperCase(Locale.ROOT);
        for (XMaterial mat : XMaterial.VALUES) {
            if (!mat.isSupported() || !mat.name().endsWith(ending)) continue;
            PAINT_BLOCKS.add(mat);
        }
        if (PAINT_BLOCKS.isEmpty()) {
            UltraCosmeticsData.get().getPlugin().getSmartLogger().write(SmartLogger.LogLevel.ERROR, "Paintball Gun setting 'Block-Type' does not match any known blocks.");
            PAINT_BLOCKS.add(XMaterial.BEDROCK);
        }
    }
}

