/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.gadgets;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.cosmetics.PlayerAffectingCosmetic;
import be.isach.ultracosmetics.cosmetics.Updatable;
import be.isach.ultracosmetics.cosmetics.gadgets.Gadget;
import be.isach.ultracosmetics.cosmetics.type.GadgetType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.util.ItemFactory;
import be.isach.ultracosmetics.util.MathUtils;
import com.cryptomorin.xseries.XMaterial;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.util.Vector;

public class GadgetFleshHook
extends Gadget
implements PlayerAffectingCosmetic,
Updatable {
    private final Set<Item> active = new HashSet<Item>();
    private final Set<Item> forRemoval = new HashSet<Item>();

    public GadgetFleshHook(UltraPlayer owner, GadgetType type, UltraCosmetics ultraCosmetics) {
        super(owner, type, ultraCosmetics);
    }

    @EventHandler
    public void onItemPickup(EntityPickupItemEvent event) {
        if (event.getEntityType() != EntityType.PLAYER) {
            return;
        }
        if (!this.active.contains(event.getItem()) && !this.forRemoval.contains(event.getItem())) {
            return;
        }
        event.setCancelled(true);
        Player hit = (Player)event.getEntity();
        UltraPlayer ultraPlayer = this.getUltraCosmetics().getPlayerManager().getUltraPlayer(hit);
        if (ultraPlayer == null) {
            return;
        }
        Player hitter = this.getPlayer();
        if (hit == hitter || !this.canAffect((Entity)hit, hitter)) {
            return;
        }
        event.getItem().remove();
        this.active.remove(event.getItem());
        this.forRemoval.remove(event.getItem());
        hit.playHurtAnimation(0.0f);
        double dX = hit.getLocation().getX() - hitter.getLocation().getX();
        double dY = hit.getLocation().getY() - hitter.getLocation().getY();
        double dZ = hit.getLocation().getZ() - hitter.getLocation().getZ();
        double yaw = Math.atan2(dZ, dX);
        double pitch = Math.atan2(Math.sqrt(dZ * dZ + dX * dX), dY) + Math.PI;
        double X = Math.sin(pitch) * Math.cos(yaw);
        double Y = Math.sin(pitch) * Math.sin(yaw);
        double Z = Math.cos(pitch);
        Vector vector = new Vector(X, Z, Y);
        MathUtils.applyVelocity((Entity)hit, vector.multiply(2.5).add(new Vector(0.0, 1.45, 0.0)));
    }

    @Override
    protected void onRightClick() {
        Item item = ItemFactory.createUnpickableItemDirectional(XMaterial.TRIPWIRE_HOOK, this.getPlayer(), 1.5);
        item.setPickupDelay(0);
        this.active.add(item);
    }

    @Override
    public void onUpdate() {
        Iterator<Item> it = this.active.iterator();
        HashSet<Item> toRemove = new HashSet<Item>();
        while (it.hasNext()) {
            Item pair = it.next();
            if (!pair.isOnGround()) continue;
            pair.remove();
            toRemove.add(pair);
            this.forRemoval.add(pair);
        }
        if (!toRemove.isEmpty()) {
            this.getUltraCosmetics().getScheduler().runAtEntityLater((Entity)this.getPlayer(), () -> {
                for (Item item : toRemove) {
                    item.remove();
                    this.forRemoval.remove(item);
                }
            }, 10L);
        }
    }

    @Override
    public void onClear() {
        for (Item item : this.active) {
            item.remove();
        }
        this.active.clear();
    }
}

