/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.gadgets;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.cosmetics.Updatable;
import be.isach.ultracosmetics.cosmetics.gadgets.Gadget;
import be.isach.ultracosmetics.cosmetics.type.GadgetType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import be.isach.ultracosmetics.util.MathUtils;
import com.cryptomorin.xseries.particles.ParticleDisplay;
import com.cryptomorin.xseries.particles.Particles;
import com.cryptomorin.xseries.particles.XParticle;
import java.awt.Color;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;

public class GadgetChristmasTree
extends Gadget
implements Updatable {
    private static final Color LOG_COLOR = new Color(101, 67, 33);
    private static final Color STAR_COLOR = new Color(255, 255, 0);
    private static final Color LEAF_COLOR = new Color(0, 100, 0);
    private boolean active = false;
    private Location lastLocation;
    private static final ParticleDisplay LOG = ParticleDisplay.of((XParticle)XParticle.DUST).withColor(LOG_COLOR);
    private static final ParticleDisplay SNOW = ParticleDisplay.of((XParticle)XParticle.FIREWORK).offset(4.0, 3.0, 4.0).withCount(10);
    private static final ParticleDisplay STAR = ParticleDisplay.of((XParticle)XParticle.DUST).withColor(STAR_COLOR);
    private static final ParticleDisplay LEAF = ParticleDisplay.of((XParticle)XParticle.DUST).withColor(LEAF_COLOR);

    public GadgetChristmasTree(UltraPlayer owner, GadgetType type, UltraCosmetics ultraCosmetics) {
        super(owner, type, ultraCosmetics);
    }

    @Override
    public void onRightClick() {
        this.lastLocation = this.lastClickedBlock.getLocation().add(0.5, 1.05, 0.5);
        this.active = true;
        this.getUltraCosmetics().getScheduler().runLaterAsync(() -> {
            this.active = false;
        }, 200L);
    }

    @Override
    public void onUpdate() {
        if (this.active) {
            this.drawLog();
            this.drawLeavesAndBalls();
            this.drawStar();
            this.drawSnow();
        }
    }

    private void drawSnow() {
        SNOW.spawn(this.lastLocation.clone().add(0.0, 3.0, 0.0));
    }

    @Override
    protected boolean checkRequirements(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK && event.getAction() != Action.LEFT_CLICK_BLOCK) {
            MessageManager.send((CommandSender)this.getPlayer(), "Gadgets.ChristmasTree.Click-On-Block", new TagResolver.Single[0]);
            return false;
        }
        return true;
    }

    private void drawLog() {
        Location to = this.lastLocation.clone().add(0.0, 2.5, 0.0);
        Particles.line((Location)this.lastLocation, (Location)to, (double)0.25, (ParticleDisplay)LOG.copy());
    }

    private void drawLeavesAndBalls() {
        float radius = 0.7f;
        for (float y = 0.8f; y <= 2.5f; y += 0.2f) {
            float steps = 13.0f / y;
            float inc = (float)(Math.PI * 2 / (double)steps);
            if (RANDOM.nextInt(2) == 1) {
                float angle = MathUtils.random(steps) * inc;
                float x = MathUtils.cos(angle) * (radius + 0.05f);
                float z = MathUtils.sin(angle) * (radius + 0.05f);
                LEAF.copy().withColor(new Color(RANDOM.nextInt(256), RANDOM.nextInt(256), RANDOM.nextInt(256))).spawn(this.lastLocation.clone().add((double)x, (double)y, (double)z));
            }
            int i = 0;
            while ((float)i < steps) {
                float angle = (float)i * inc;
                float x = MathUtils.cos(angle) * radius;
                float z = MathUtils.sin(angle) * radius;
                LEAF.spawn(this.lastLocation.clone().add((double)x, (double)y, (double)z));
                ++i;
            }
            radius -= 0.082352936f;
        }
    }

    private void drawStar() {
        STAR.spawn(this.lastLocation.clone().add(0.0, 2.6, 0.0));
    }

    @Override
    public void onClear() {
        this.active = false;
        this.lastLocation = null;
    }
}

