/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.gadgets;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.cosmetics.Category;
import be.isach.ultracosmetics.cosmetics.Cosmetic;
import be.isach.ultracosmetics.cosmetics.PlayerAffectingCosmetic;
import be.isach.ultracosmetics.cosmetics.Updatable;
import be.isach.ultracosmetics.cosmetics.type.CosmeticType;
import be.isach.ultracosmetics.cosmetics.type.GadgetType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.Component;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.TextComponent;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.format.NamedTextColor;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.format.TextColor;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.format.TextDecoration;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import be.isach.ultracosmetics.util.ItemFactory;
import be.isach.ultracosmetics.util.PlayerUtils;
import be.isach.ultracosmetics.util.TextUtil;
import be.isach.ultracosmetics.util.UnmovableItemProvider;
import com.cryptomorin.xseries.XSound;
import com.cryptomorin.xseries.messages.ActionBar;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

public abstract class Gadget
extends Cosmetic<GadgetType>
implements UnmovableItemProvider {
    private static final DecimalFormatSymbols OTHER_SYMBOLS = new DecimalFormatSymbols(Locale.US);
    private static final DecimalFormat DECIMAL_FORMAT;
    protected ItemStack itemStack;
    protected boolean displayCooldownMessage = true;
    protected Block lastClickedBlock;
    protected final int slot = SettingsManager.getConfig().getInt("Gadget-Slot");
    private final boolean removeWithDrop = SettingsManager.getConfig().getBoolean("Remove-Gadget-With-Drop");
    private final boolean showCooldownInBar = UltraCosmeticsData.get().displaysCooldownInBar();
    private final boolean requiresAmmo = UltraCosmeticsData.get().isAmmoEnabled() && ((GadgetType)this.getType()).requiresAmmo();
    private final XSound.SoundPlayer readySound = XSound.BLOCK_NOTE_BLOCK_HAT.record().withVolume(1.4f).withPitch(1.5f).soundPlayer().forPlayers(new Player[]{this.getPlayer()});
    private boolean handledThisTick = false;

    public Gadget(UltraPlayer owner, GadgetType type, UltraCosmetics ultraCosmetics) {
        this(owner, type, ultraCosmetics, false);
    }

    public Gadget(UltraPlayer owner, GadgetType type, UltraCosmetics ultraCosmetics, boolean asynchronous) {
        super(owner, type, ultraCosmetics);
    }

    @Override
    public boolean tryEquip() {
        this.getOwner().removeCosmetic(Category.GADGETS);
        ItemStack current = this.getPlayer().getInventory().getItem(this.slot);
        if (current != null && current.getType() != Material.AIR) {
            MessageManager.send((CommandSender)this.getPlayer(), "Must-Remove.Gadgets", Placeholder.unparsed("slot", String.valueOf(this.slot + 1)));
            return false;
        }
        this.equipItem();
        return true;
    }

    @Override
    public void onEquip() {
        if (!(this instanceof Updatable)) {
            this.scheduleTask();
        }
        this.getUltraCosmetics().getUnmovableItemListener().addProvider(this);
    }

    @Override
    public void run() {
        String leftRounded;
        double decimalRoundedValue;
        double left;
        ItemStack hand;
        this.handledThisTick = false;
        if (this.getOwner() == null || this.getPlayer() == null) {
            return;
        }
        UltraPlayer owner = this.getOwner();
        if (owner.getCurrentGadget() == null || owner.getCurrentGadget().getType() != this.getType()) {
            this.clear();
            return;
        }
        if (this instanceof Updatable) {
            ((Updatable)((Object)this)).onUpdate();
        }
        if (this.showCooldownInBar && this.itemMatches(hand = this.getPlayer().getInventory().getItemInMainHand()) && !owner.canUse((CosmeticType<?>)this.getType())) {
            owner.sendCooldownBar((CosmeticType<?>)this.getType(), ((GadgetType)this.getType()).getCountdown(), ((GadgetType)this.getType()).getRunTime());
        }
        if ((left = owner.getCooldown((CosmeticType<?>)this.getType())) > 0.0 && (decimalRoundedValue = Double.parseDouble(leftRounded = DECIMAL_FORMAT.format(left))) == 0.0) {
            String message = MessageManager.getLegacyMessage("Gadgets.Gadget-Ready-ActionBar", Placeholder.component("gadgetname", TextUtil.stripColor(this.getTypeName())));
            ActionBar.sendActionBar((Player)this.getPlayer(), (String)message);
            this.readySound.play();
        }
    }

    @Override
    public void clear() {
        this.removeItem();
        this.getUltraCosmetics().getUnmovableItemListener().removeProvider(this);
        super.clear();
    }

    public void removeItem() {
        PlayerUtils.removeItems(this.getPlayer(), this::itemMatches);
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    private Component getItemDisplayName() {
        if (!this.requiresAmmo || this.getUltraCosmetics().getWorldGuardManager().isInShowroom(this.getPlayer())) {
            return this.getTypeName();
        }
        TextComponent ammo = Component.text(this.getOwner().getAmmo((GadgetType)this.getType()) + " ", (TextColor)NamedTextColor.WHITE, TextDecoration.BOLD);
        return ((TextComponent)Component.empty().append(ammo)).append(this.getTypeName());
    }

    public void updateItemStack() {
        this.itemStack = ItemFactory.rename(((GadgetType)this.getType()).getItemStack(), this.getItemDisplayName(), MessageManager.getLegacyMessage("Gadgets.Lore", new TagResolver.Single[0]));
        ItemFactory.applyCosmeticMarker(this.itemStack);
    }

    public void equipItem() {
        this.updateItemStack();
        this.getPlayer().getInventory().setItem(this.slot, this.itemStack);
    }

    protected boolean checkRequirements(PlayerInteractEvent event) {
        return true;
    }

    @Override
    public boolean itemMatches(ItemStack stack) {
        if (stack == null || stack.getType() != this.getItemStack().getType() || !stack.hasItemMeta() || !stack.getItemMeta().hasDisplayName()) {
            return false;
        }
        return stack.getItemMeta().getDisplayName().toLowerCase(Locale.ROOT).equals(MessageManager.toLegacy(this.getItemDisplayName()).toLowerCase(Locale.ROOT));
    }

    @Override
    public void handleInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        event.setCancelled(true);
        if (this.handledThisTick) {
            return;
        }
        this.handledThisTick = true;
        UltraPlayer ultraPlayer = this.getUltraCosmetics().getPlayerManager().getUltraPlayer(player);
        if (ultraPlayer.getCurrentTreasureChest() != null) {
            return;
        }
        if (PlayerAffectingCosmetic.isHidden(event.getPlayer(), this.getPlayer()) && SettingsManager.getConfig().getBoolean("Prevent-Cosmetics-In-Vanish")) {
            this.getOwner().clear();
            MessageManager.send((CommandSender)this.getPlayer(), "Not-Allowed-In-Vanish", new TagResolver.Single[0]);
            return;
        }
        if (!ultraPlayer.hasGadgetsEnabled()) {
            MessageManager.send((CommandSender)this.getPlayer(), "Gadgets-Enabled-Needed", new TagResolver.Single[0]);
            return;
        }
        boolean inShowroom = this.getUltraCosmetics().getWorldGuardManager().isInShowroom(player);
        if (this.requiresAmmo && ultraPlayer.getAmmo((GadgetType)this.getType()) < 1 && !inShowroom) {
            if (UltraCosmeticsData.get().isAmmoPurchaseEnabled() && this.getUltraCosmetics().getEconomyHandler().isUsingEconomy()) {
                this.getUltraCosmetics().getMenus().openAmmoPurchaseMenu((GadgetType)this.getType(), this.getOwner(), () -> {});
            } else {
                MessageManager.send((CommandSender)this.getPlayer(), "No-Ammo", new TagResolver.Single[0]);
            }
            return;
        }
        if (!this.checkRequirements(event)) {
            return;
        }
        double coolDown = ultraPlayer.getCooldown((CosmeticType<?>)this.getType());
        if (coolDown > 0.0) {
            String timeLeft = new DecimalFormat("#.#").format(coolDown);
            if (((GadgetType)this.getType()).getCountdown() > 1.0) {
                MessageManager.send((CommandSender)this.getPlayer(), "Gadgets.Countdown-Message", Placeholder.component("gadgetname", TextUtil.stripColor(this.getTypeName())), Placeholder.unparsed("time", String.valueOf(timeLeft)));
            }
            return;
        }
        ultraPlayer.setCooldown((CosmeticType<?>)this.getType(), ((GadgetType)this.getType()).getCountdown(), ((GadgetType)this.getType()).getRunTime());
        if (this.requiresAmmo && !inShowroom) {
            ultraPlayer.removeAmmo((GadgetType)this.getType());
            this.equipItem();
        }
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK || event.getAction() == Action.LEFT_CLICK_BLOCK) {
            this.lastClickedBlock = event.getClickedBlock();
        }
        if (event.getAction() == Action.LEFT_CLICK_AIR || event.getAction() == Action.LEFT_CLICK_BLOCK) {
            this.onLeftClick();
        } else {
            this.onRightClick();
        }
    }

    protected abstract void onRightClick();

    protected void onLeftClick() {
        this.onRightClick();
    }

    @Override
    public void handleDrop(PlayerDropItemEvent event) {
        if (this.removeWithDrop) {
            this.clear();
            event.getItemDrop().remove();
        } else {
            event.setCancelled(true);
        }
    }

    @Override
    public int getSlot() {
        return this.slot;
    }

    @Override
    public void moveItem(int slot, Player player) {
        this.clear();
    }

    static {
        OTHER_SYMBOLS.setDecimalSeparator('.');
        OTHER_SYMBOLS.setGroupingSeparator('.');
        OTHER_SYMBOLS.setPatternSeparator('.');
        DECIMAL_FORMAT = new DecimalFormat("0.0", OTHER_SYMBOLS);
    }
}

