/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.cosmetics.Cosmetic;
import be.isach.ultracosmetics.cosmetics.type.CosmeticEntType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.util.EntitySpawningManager;
import com.cryptomorin.xseries.XAttribute;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityPortalEnterEvent;
import org.bukkit.event.entity.EntityPortalEvent;

public abstract class EntityCosmetic<T extends CosmeticEntType<?>, E extends Entity>
extends Cosmetic<T> {
    protected E entity;

    public EntityCosmetic(UltraPlayer owner, T type, UltraCosmetics ultraCosmetics) {
        super(owner, type, ultraCosmetics);
    }

    public E getEntity() {
        return this.entity;
    }

    protected E spawnEntity() {
        return (E)EntitySpawningManager.withBypass(() -> this.getPlayer().getWorld().spawnEntity(this.getPlayer().getLocation(), ((CosmeticEntType)this.getType()).getEntityType()));
    }

    protected void removeEntity() {
        this.removeEntitySafe((Entity)this.entity);
        this.entity = null;
    }

    protected void removeEntitySafe(Entity entity) {
        if (entity != null) {
            if (this.getUltraCosmetics().isEnabled()) {
                this.getUltraCosmetics().getScheduler().runAtEntity(entity, t -> entity.remove());
            } else {
                try {
                    entity.remove();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    protected void setupEntity() {
    }

    protected void setMovementSpeed(double speed) {
        ((LivingEntity)this.entity).getAttribute((Attribute)XAttribute.MOVEMENT_SPEED.get()).setBaseValue(speed);
    }

    protected void onPortal() {
    }

    @EventHandler
    public void onPortal(EntityPortalEvent event) {
        if (event.getEntity() == this.getEntity()) {
            event.setCancelled(true);
            this.onPortal();
        }
    }

    @EventHandler
    public void onPortalEnter(EntityPortalEnterEvent event) {
        if (!(event instanceof Cancellable)) {
            return;
        }
        Cancellable c = (Cancellable)event;
        if (event.getEntity() == this.getEntity()) {
            c.setCancelled(true);
            this.onPortal();
        }
    }
}

