/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.config;

import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.cosmetics.Category;
import be.isach.ultracosmetics.shaded.kyori.adventure.platform.bukkit.BukkitAudiences;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.Component;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.format.Style;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.minimessage.MiniMessage;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.minimessage.tag.standard.StandardTags;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.serializer.ComponentSerializer;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import be.isach.ultracosmetics.util.SmartLogger;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class MessageManager {
    private static final LegacyComponentSerializer LEGACY_SERIALIZER = ((LegacyComponentSerializer.Builder)LegacyComponentSerializer.legacySection().toBuilder()).hexColors().useUnusualXRepeatedCharacterHexFormat().build();
    private static MessageManager instance;
    private final SettingsManager messagesConfig;
    private final MiniMessage miniMessage;
    private final BukkitAudiences audiences = BukkitAudiences.create((Plugin)UltraCosmeticsData.get().getPlugin());
    private boolean success = false;

    public static String getLangFilename() {
        return "messages_" + UltraCosmeticsData.get().getLanguage();
    }

    private MessageManager() {
        String langFile = MessageManager.getLangFilename();
        this.messagesConfig = new SettingsManager(langFile);
        if (!this.messagesConfig.success()) {
            this.miniMessage = null;
            return;
        }
        Reader reader = UltraCosmeticsData.get().getPlugin().getFileReader("messages/" + langFile + ".yml");
        this.loadMessages(YamlConfiguration.loadConfiguration((Reader)reader));
        this.messagesConfig.save();
        this.miniMessage = this.buildMinimessage(true);
        this.success = true;
    }

    private MiniMessage buildMinimessage(boolean includePrefix) {
        TagResolver.Builder tagBuilder = TagResolver.builder().resolver(StandardTags.color()).resolver(StandardTags.decorations()).resolver(StandardTags.font()).resolver(StandardTags.gradient()).resolver(StandardTags.newline()).resolver(StandardTags.rainbow()).resolver(StandardTags.reset());
        if (includePrefix) {
            tagBuilder.resolver(Placeholder.parsed("prefix", this.messagesConfig.getString("Prefix") + "<reset>"));
        }
        return MiniMessage.builder().tags(tagBuilder.build()).build();
    }

    private void checkMessageExists(String messagePath) {
        if (!this.messagesConfig.fileConfiguration.isString(messagePath)) {
            throw new IllegalArgumentException("No such message key: " + messagePath);
        }
    }

    @NotNull
    private Component getMessageInternal(String messagePath, TagResolver.Single ... placeholders) {
        this.checkMessageExists(messagePath);
        return this.miniMessage.deserialize(this.messagesConfig.getString(messagePath), placeholders);
    }

    private List<String> getLoreInternal(String messagePath, Style defaultStyle, TagResolver.Single ... placeholders) {
        this.checkMessageExists(messagePath);
        String[] parts = this.messagesConfig.getString(messagePath).split("\n");
        Style lastStyle = defaultStyle == null ? Style.empty() : defaultStyle;
        ArrayList<String> result = new ArrayList<String>();
        for (String part : parts) {
            Component component = this.miniMessage.deserialize(part, placeholders).applyFallbackStyle(lastStyle);
            result.add(MessageManager.toLegacy(component));
            lastStyle = component.style();
        }
        return result;
    }

    private void addMessageInternal(String path, String message) {
        if (this.messagesConfig.addDefault(path, message)) {
            // empty if block
        }
    }

    private void loadMessages(YamlConfiguration defaults) {
        ConfigurationSection newLoots;
        String noPermissionMessage;
        ConfigurationSection menuBlock = this.messagesConfig.getConfigurationSection("Menu");
        if (menuBlock != null && menuBlock.isString("Gadgets")) {
            this.upgradeCategoryStrings(menuBlock);
        }
        String oldGadgetKey = "Treasure-Chests-Loot.gadget";
        String newGadgetKey = "Treasure-Chests-Loot.Gadget";
        String gadgetMessage = this.messagesConfig.getString(oldGadgetKey);
        if (gadgetMessage != null) {
            this.messagesConfig.set(newGadgetKey, gadgetMessage);
            this.messagesConfig.set(oldGadgetKey, null);
        }
        if (this.messagesConfig.getString("Prefix") != null && this.messagesConfig.getString("Prefix").startsWith("&")) {
            this.minimessageMigration();
        }
        if ((noPermissionMessage = this.messagesConfig.getString("No-Permission")) != null && noPermissionMessage.startsWith("<prefix> ")) {
            this.messagesConfig.set("No-Permission", noPermissionMessage.substring(9));
        }
        if ((newLoots = this.messagesConfig.getConfigurationSection("Treasure-Chests-Loot-Messages")) != null) {
            for (String key : newLoots.getKeys(false)) {
                if (!newLoots.getString(key).contains("%")) continue;
                newLoots.set(key, (Object)newLoots.getString(key).replaceAll("%(\\w+)%", "<$1>"));
            }
        }
        for (String key : defaults.getKeys(true)) {
            this.addMessageInternal(key, defaults.getString(key));
        }
    }

    private void upgradeCategoryStrings(ConfigurationSection menuBlock) {
        this.messagesConfig.set("Menu", null);
        HashMap<Category, Map<String, String>> buttons = new HashMap<Category, Map<String, String>>();
        HashMap<Category, String> menuNames = new HashMap<Category, String>();
        for (Category category : Category.values()) {
            HashMap<String, String> catSection = new HashMap<String, String>();
            catSection.put("Name", menuBlock.getString(category.getConfigPath()));
            buttons.put(category, catSection);
            menuNames.put(category, this.messagesConfig.getString("Menus." + category.getConfigPath()));
        }
        this.addButton(buttons, menuBlock, Category.PETS, "Spawn", "Despawn");
        this.addButton(buttons, menuBlock, Category.GADGETS, "Activate", "Deactivate");
        this.addButton(buttons, menuBlock, Category.EFFECTS, "Summon", "Unsummon");
        this.addButton(buttons, menuBlock, Category.MOUNTS, "Spawn", "Despawn");
        this.addButton(buttons, menuBlock, Category.MORPHS, "Morph", "Unmorph");
        this.addButton(buttons, menuBlock, Category.HATS, "Equip", "Unequip");
        this.addButton(buttons, menuBlock, Category.SUITS_HELMET, "Equip", "Unequip");
        this.addButton(buttons, menuBlock, Category.EMOTES, "Equip", "Unequip");
        for (Map.Entry entry : buttons.entrySet()) {
            this.messagesConfig.set("Menu." + ((Category)((Object)entry.getKey())).getConfigPath() + ".Title", menuNames.get(entry.getKey()));
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                this.messagesConfig.set("Menu." + ((Category)((Object)entry.getKey())).getConfigPath() + ".Button." + (String)entry2.getKey(), entry2.getValue());
            }
        }
        this.messagesConfig.set("Menu.Main.Button.Name", menuBlock.getString("Main-Menu"));
        this.migrateKey("Menus.Main-Menu", "Menu.Main.Title");
        this.migrateKey("Menus.Buy-Ammo", "Menu.Buy-Ammo.Title");
        this.migrateKey("Menus.Rename-Pet", "Menu.Purchase-Rename.Title");
        this.migrateKey("Rename-Pet-Purchase", "Menu.Purchase-Rename.Button.Showcase");
        this.migrateKey("Rename-Pet", "Menu.Rename-Pet.Button.Name");
        this.migrateKey("Rename-Pet-Placeholder", "Menu.Rename-Pet.Placeholder");
        this.migrateKey("Rename-Pet-Title", "Menu.Rename-Pet.Title");
        this.migrateMiscButton(menuBlock, "Previous-Page");
        this.migrateMiscButton(menuBlock, "Next-Page");
        this.messagesConfig.set("Menus", null);
        this.migrateActivateMsg(Category.PETS, "Spawn", "Despawn");
        this.migrateActivateMsg(Category.EFFECTS, "Summon", "Unsummon");
        this.migrateActivateMsg(Category.MOUNTS, "Spawn", "Despawn");
        this.migrateActivateMsg(Category.MORPHS, "Morph", "Unmorph");
        this.migrateClearMsg("Cosmetics", "Cosmetics");
        for (Category category : Category.values()) {
            String configName = this.getMessagesName(category);
            this.migrateClearMsg(category.getConfigPath(), configName.substring(0, configName.length() - 1));
        }
    }

    public String getMessagesName(Category category) {
        if (category.isSuits()) {
            return "Suits";
        }
        return category.name().charAt(0) + category.getConfigPath().substring(1).toLowerCase(Locale.ROOT).replace("_", "-");
    }

    private void addButton(Map<Category, Map<String, String>> buttons, ConfigurationSection menuBlock, Category cat, String oldEquipKey, String oldUnequipKey) {
        buttons.get((Object)cat).put("Tooltip-Equip", menuBlock.getString(oldEquipKey));
        buttons.get((Object)cat).put("Tooltip-Unequip", menuBlock.getString(oldUnequipKey));
    }

    private void migrateMiscButton(ConfigurationSection section, String key) {
        this.messagesConfig.set("Menu.Misc.Button." + key, section.getString(key));
    }

    private void migrateActivateMsg(Category cat, String oldEquipKey, String oldUnequipKey) {
        this.migrateKey(cat.getConfigPath() + "." + oldEquipKey, cat.getConfigPath() + ".Equip");
        this.migrateKey(cat.getConfigPath() + "." + oldUnequipKey, cat.getConfigPath() + ".Unequip");
    }

    private void migrateClearMsg(String newKey, String oldKey) {
        this.migrateKey("Clear-" + oldKey, "Clear." + newKey);
    }

    private void migrateKey(String oldKey, String newKey) {
        this.messagesConfig.set(newKey, this.messagesConfig.getString(oldKey));
        this.messagesConfig.set(oldKey, null);
    }

    private void minimessageMigration() {
        SmartLogger log = UltraCosmeticsData.get().getPlugin().getSmartLogger();
        log.write(SmartLogger.LogLevel.WARNING, "Your messages file is using legacy color codes, it will be upgraded now");
        this.migration(LEGACY_SERIALIZER, this.buildMinimessage(false));
    }

    private void migration(ComponentSerializer<Component, ?, String> deserializer, ComponentSerializer<Component, ?, String> serializer) {
        FileConfiguration config = this.messagesConfig.fileConfiguration;
        Pattern percentVarPattern = Pattern.compile("%([\\w-]+)%");
        for (String key : config.getKeys(true)) {
            if (!config.isString(key)) continue;
            String[] raw = config.getString(key).split("\n");
            CharSequence[] converted = new String[raw.length];
            for (int i = 0; i < raw.length; ++i) {
                converted[i] = serializer.serialize((Component)deserializer.deserialize(raw[i]));
            }
            config.set(key, (Object)percentVarPattern.matcher(String.join((CharSequence)"\n", converted)).replaceAll("<$1>"));
        }
        ConfigurationSection customItem = SettingsManager.getConfig().getConfigurationSection("No-Permission.Custom-Item");
        String name = customItem.getString("Name", "");
        String convertedName = serializer.serialize((Component)deserializer.deserialize(name));
        customItem.set("Name", (Object)convertedName.replace("{cosmetic-name}", "<cosmetic>"));
        ArrayList<String> lore = new ArrayList<String>();
        for (String loreItem : customItem.getStringList("Lore")) {
            lore.add(serializer.serialize((Component)deserializer.deserialize(loreItem)));
        }
        customItem.set("Lore", lore);
        this.migrateConfigStrings(serializer, deserializer);
    }

    private void migrateConfigStrings(ComponentSerializer<Component, ?, String> serializer, ComponentSerializer<Component, ?, String> deserializer) {
        ConfigurationSection loots = SettingsManager.getConfig().getConfigurationSection("TreasureChests.Loots");
        for (String key : loots.getKeys(false)) {
            String path = key + ".Message.message";
            if (!loots.isString(path)) continue;
            String message = serializer.serialize((Component)deserializer.deserialize(loots.getString(path)));
            message = message.replaceAll("%(\\w+)%", "<$1>");
            this.messagesConfig.set("Treasure-Chests-Loot-Messages." + key, message);
            loots.set(path, null);
        }
        ConfigurationSection noPermission = SettingsManager.getConfig().getConfigurationSection("No-Permission");
        for (String key : new String[]{"Yes", "No", "Showroom"}) {
            String path = "Lore-Message-" + key;
            if (!noPermission.isString(path)) continue;
            Object newKey = key;
            if (!key.equals("Showroom")) {
                newKey = "Permission-" + key;
            }
            this.messagesConfig.set("Permission-Lore." + (String)newKey, serializer.serialize((Component)deserializer.deserialize(noPermission.getString(path))));
            noPermission.set(path, null);
        }
    }

    public static boolean load() {
        MessageManager.destroy();
        instance = new MessageManager();
        return MessageManager.instance.success;
    }

    private static MessageManager getInstance() {
        if (instance == null) {
            MessageManager.load();
        }
        return instance;
    }

    public static void addMessage(String path, String message) {
        MessageManager.getInstance().addMessageInternal(path, message);
    }

    @NotNull
    public static Component getMessage(String messagePath, TagResolver.Single ... placeholders) {
        return MessageManager.getInstance().getMessageInternal(messagePath, placeholders);
    }

    public static String toLegacy(Component component) {
        return LEGACY_SERIALIZER.serialize(component);
    }

    public static String getLegacyMessage(String messagePath, TagResolver.Single ... placeholders) {
        return MessageManager.toLegacy(MessageManager.getMessage(messagePath, placeholders));
    }

    public static List<String> getLore(String messagePath, Style defaultStyle, TagResolver.Single ... placeholders) {
        return MessageManager.getInstance().getLoreInternal(messagePath, defaultStyle, placeholders);
    }

    public static void send(CommandSender sender, String messagePath, TagResolver.Single ... placeholders) {
        Component message = MessageManager.getMessage(messagePath, placeholders);
        if (!Component.empty().equals(message)) {
            MessageManager.getInstance().audiences.sender(sender).sendMessage(message);
        }
    }

    public static BukkitAudiences getAudiences() {
        return MessageManager.getInstance().audiences;
    }

    public static MiniMessage getMiniMessage() {
        return MessageManager.getInstance().miniMessage;
    }

    public static void save() {
        MessageManager.getInstance().messagesConfig.save();
    }

    public static void destroy() {
        if (instance != null) {
            MessageManager.instance.audiences.close();
            instance = null;
        }
    }

    public static LegacyComponentSerializer legacySerializer() {
        return LEGACY_SERIALIZER;
    }
}

