/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.command.subcommands;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.command.SubCommand;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.shaded.kyori.adventure.audience.Audience;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.Component;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.event.ClickEvent;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.format.NamedTextColor;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.format.TextColor;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.format.TextDecoration;
import be.isach.ultracosmetics.util.Problem;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SubCommandTroubleshoot
extends SubCommand {
    public SubCommandTroubleshoot(UltraCosmetics ultraCosmetics) {
        super("troubleshoot", "Identifies issues with UltraCosmetics", "", ultraCosmetics);
    }

    @Override
    protected void onExeAnyone(CommandSender sender, String[] args) {
        Set<Problem> problems = this.ultraCosmetics.getProblems();
        if (problems.isEmpty()) {
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "UltraCosmetics is not currently aware of any problems :)");
        } else {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "UltraCosmetics currently has " + problems.size() + " minor problems.");
            if (sender instanceof Player) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "(Click on a problem to see its wiki page)");
            }
            Audience audience = MessageManager.getAudiences().sender(sender);
            problems.forEach(p -> audience.sendMessage(p.getSummary().color(NamedTextColor.YELLOW)));
        }
        SubCommandTroubleshoot.sendSupportMessage(sender);
    }

    public static void sendSupportMessage(CommandSender sender) {
        String version = UltraCosmeticsData.get().getPlugin().getUpdateChecker().getCurrentVersion().versionClassifierCommit();
        sender.sendMessage("You are running UC " + version + " on " + Bukkit.getName() + " " + Bukkit.getVersion());
        Component discordMessage = Component.text("If you need help, click here to join the support Discord", (TextColor)NamedTextColor.GREEN, TextDecoration.UNDERLINED).clickEvent(ClickEvent.openUrl("https://discord.gg/mDSbzGPykk"));
        MessageManager.getAudiences().sender(sender).sendMessage(discordMessage);
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "When you join, share a screenshot of this message.");
    }
}

