/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.command.subcommands;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.command.SubCommand;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.cosmetics.type.PetType;
import be.isach.ultracosmetics.menu.buttons.RenamePetButton;
import be.isach.ultracosmetics.player.UltraPlayer;
import java.util.StringJoiner;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SubCommandRename
extends SubCommand {
    public SubCommandRename(UltraCosmetics ultraCosmetics) {
        super("rename", "Renames/clears the name of active pet", "[new name]", ultraCosmetics);
    }

    @Override
    protected void onExeAnyone(CommandSender sender, String[] args) {
        this.notAllowed(sender);
    }

    @Override
    protected void onExePlayer(Player player, String[] args) {
        String newName;
        if (!SettingsManager.getConfig().getBoolean("Pets-Rename.Enabled")) {
            this.error((CommandSender)player, "Pet renaming is disabled.");
            return;
        }
        UltraPlayer up = this.ultraCosmetics.getPlayerManager().getUltraPlayer(player);
        if (up.getCurrentPet() == null) {
            this.error((CommandSender)player, "Please equip a pet to rename it.");
            return;
        }
        if (args.length < 2) {
            newName = "";
        } else {
            StringJoiner sj = new StringJoiner(" ");
            for (int i = 1; i < args.length; ++i) {
                sj.add(args[i]);
            }
            newName = sj.toString();
        }
        String stripped = MessageManager.getMiniMessage().stripTags(newName);
        int maxLength = SettingsManager.getConfig().getInt("Max-Pet-Name-Length", -1);
        if (maxLength != -1 && stripped.length() > maxLength) {
            this.error((CommandSender)player, "Name cannot be longer than " + maxLength + " characters");
            return;
        }
        if (!newName.isEmpty() && this.ultraCosmetics.getEconomyHandler().isUsingEconomy() && SettingsManager.getConfig().getBoolean("Pets-Rename.Requires-Money.Enabled")) {
            player.openInventory(RenamePetButton.buyRenamePet(up, newName, null));
        } else {
            up.setPetName((PetType)up.getCurrentPet().getType(), newName);
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Success!");
        }
    }
}

