/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.command.subcommands;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.command.SubCommand;
import java.io.File;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;

public class SubCommandPurge
extends SubCommand {
    public SubCommandPurge(UltraCosmetics ultraCosmetics) {
        super("purge", "Purges old data files.", "<confirm>", ultraCosmetics);
    }

    @Override
    protected void onExeAnyone(CommandSender sender, String[] args) {
        if (args.length < 2 || !args[1].equalsIgnoreCase("confirm")) {
            sender.sendMessage(ChatColor.RED.toString() + String.valueOf(ChatColor.BOLD) + "Are you sure you want to purge old player data files? Depending on the amount of data files you have, this may lag your server for a noticable amount of time.");
            sender.sendMessage(ChatColor.RED.toString() + String.valueOf(ChatColor.BOLD) + "To confirm purge of playerdata that doesn't contain treasure keys or pet names, type /uc purge confirm");
            return;
        }
        sender.sendMessage(ChatColor.AQUA.toString() + String.valueOf(ChatColor.BOLD) + "Starting deletion now, this may take a while. Please wait...");
        this.ultraCosmetics.getScheduler().runAsync(task -> {
            File dataFolder = new File(this.ultraCosmetics.getDataFolder(), "data");
            int deletedFiles = 0;
            int savedFiles = 0;
            if (!dataFolder.isDirectory()) {
                sender.sendMessage(ChatColor.RED.toString() + String.valueOf(ChatColor.BOLD) + "An error occured: folder not valid. No data was purged.");
                return;
            }
            for (File file : dataFolder.listFiles()) {
                if (file.lastModified() >= System.currentTimeMillis() + 86400000L) continue;
                YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
                if (config.getInt("Keys") > 0 || config.contains("Pet-Names")) {
                    ++savedFiles;
                    continue;
                }
                ++deletedFiles;
                file.delete();
            }
            sender.sendMessage(ChatColor.GREEN.toString() + String.valueOf(ChatColor.BOLD) + "Success! " + deletedFiles + " files were deleted, and " + savedFiles + " files were saved because of keys or pet names.");
        });
    }
}

