/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.command;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.command.SubCommand;
import be.isach.ultracosmetics.command.UCTabCompleter;
import be.isach.ultracosmetics.command.subcommands.SubCommandClear;
import be.isach.ultracosmetics.command.subcommands.SubCommandGadgets;
import be.isach.ultracosmetics.command.subcommands.SubCommandGive;
import be.isach.ultracosmetics.command.subcommands.SubCommandHelp;
import be.isach.ultracosmetics.command.subcommands.SubCommandMenu;
import be.isach.ultracosmetics.command.subcommands.SubCommandMigrate;
import be.isach.ultracosmetics.command.subcommands.SubCommandPermission;
import be.isach.ultracosmetics.command.subcommands.SubCommandReload;
import be.isach.ultracosmetics.command.subcommands.SubCommandRename;
import be.isach.ultracosmetics.command.subcommands.SubCommandReward;
import be.isach.ultracosmetics.command.subcommands.SubCommandSelfView;
import be.isach.ultracosmetics.command.subcommands.SubCommandToggle;
import be.isach.ultracosmetics.command.subcommands.SubCommandTreasure;
import be.isach.ultracosmetics.command.subcommands.SubCommandTreasureNotification;
import be.isach.ultracosmetics.command.subcommands.SubCommandTroubleshoot;
import be.isach.ultracosmetics.command.subcommands.SubCommandUpdate;
import be.isach.ultracosmetics.command.subcommands.SubCommandWhyDoIHave;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.shaded.kyori.adventure.audience.Audience;
import be.isach.ultracosmetics.shaded.kyori.adventure.platform.bukkit.BukkitAudiences;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.Component;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.TextComponent;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.format.NamedTextColor;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import be.isach.ultracosmetics.util.Problem;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class CommandManager
implements CommandExecutor {
    private final UltraCosmetics ultraCosmetics;
    private final List<SubCommand> commands = new ArrayList<SubCommand>();
    private final SubCommandHelp help;
    private final SubCommand menu;

    public CommandManager(UltraCosmetics ultraCosmetics) {
        this.ultraCosmetics = ultraCosmetics;
        PluginCommand cmd = ultraCosmetics.getCommand("ultracosmetics");
        cmd.setExecutor((CommandExecutor)this);
        cmd.setTabCompleter((TabCompleter)new UCTabCompleter(this));
        this.help = new SubCommandHelp(ultraCosmetics, this);
        this.menu = new SubCommandMenu(ultraCosmetics);
        this.registerCommands();
    }

    public void registerCommand(SubCommand meCommand) {
        this.commands.add(meCommand);
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        Set<Problem> problems = this.ultraCosmetics.getSevereProblems();
        if (!problems.isEmpty()) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Plugin is currently disabled because:");
            try (BukkitAudiences audiences = BukkitAudiences.create((Plugin)this.ultraCosmetics);){
                Audience audience = audiences.sender(sender);
                problems.forEach(p -> audience.sendMessage(p.getSummary().color(NamedTextColor.RED)));
                SubCommandTroubleshoot.sendSupportMessage(sender);
                boolean bl = true;
                return bl;
            }
        }
        if (args.length == 0) {
            if (sender instanceof Player && SettingsManager.getConfig().getBoolean("Open-Menu-On-Base-Command")) {
                this.menu.onExePlayer((Player)sender, new String[0]);
            } else {
                this.help.showHelp(sender, 1);
            }
            return true;
        }
        for (SubCommand meCommand : this.commands) {
            if (!meCommand.is(args[0])) continue;
            if (!sender.hasPermission(meCommand.getPermission())) {
                CommandManager.sendNoPermissionMessage(sender);
                return true;
            }
            if (sender instanceof Player) {
                meCommand.onExePlayer((Player)sender, args);
            } else {
                meCommand.onExeAnyone(sender, args);
            }
            return true;
        }
        this.help.showHelp(sender, 1);
        return true;
    }

    public List<SubCommand> getCommands() {
        return this.commands;
    }

    public void registerCommands() {
        this.registerCommand(this.help);
        this.registerCommand(this.menu);
        this.registerCommand(new SubCommandGadgets(this.ultraCosmetics));
        this.registerCommand(new SubCommandSelfView(this.ultraCosmetics));
        this.registerCommand(new SubCommandGive(this.ultraCosmetics));
        this.registerCommand(new SubCommandToggle(this.ultraCosmetics));
        this.registerCommand(new SubCommandClear(this.ultraCosmetics));
        this.registerCommand(new SubCommandTreasure(this.ultraCosmetics));
        this.registerCommand(new SubCommandTreasureNotification(this.ultraCosmetics));
        this.registerCommand(new SubCommandMigrate(this.ultraCosmetics));
        this.registerCommand(new SubCommandReward(this.ultraCosmetics));
        this.registerCommand(new SubCommandReload(this.ultraCosmetics));
        this.registerCommand(new SubCommandUpdate(this.ultraCosmetics));
        this.registerCommand(new SubCommandTroubleshoot(this.ultraCosmetics));
        this.registerCommand(new SubCommandPermission(this.ultraCosmetics));
        this.registerCommand(new SubCommandRename(this.ultraCosmetics));
        this.registerCommand(new SubCommandWhyDoIHave(this.ultraCosmetics));
    }

    public static void sendNoPermissionMessage(CommandSender sender) {
        Component prefix = MessageManager.getMessage("Prefix", new TagResolver.Single[0]);
        Component noPermission = MessageManager.getMessage("No-Permission", new TagResolver.Single[0]);
        MessageManager.getAudiences().sender(sender).sendMessage(((TextComponent)((TextComponent)Component.empty().append(prefix)).appendSpace()).append(noPermission));
    }
}

