/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics;

import be.isach.ultracosmetics.UCAddon;
import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.command.CommandManager;
import be.isach.ultracosmetics.config.AutoCommentConfiguration;
import be.isach.ultracosmetics.config.CustomConfiguration;
import be.isach.ultracosmetics.config.FunctionalConfigLoader;
import be.isach.ultracosmetics.config.ManualCommentConfiguration;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.cosmetics.Category;
import be.isach.ultracosmetics.cosmetics.type.CosmeticType;
import be.isach.ultracosmetics.economy.EconomyHandler;
import be.isach.ultracosmetics.hook.ChestSortHook;
import be.isach.ultracosmetics.hook.DiscordSRVHook;
import be.isach.ultracosmetics.hook.PlaceholderHook;
import be.isach.ultracosmetics.hook.PlayerAuctionsHook;
import be.isach.ultracosmetics.hook.TownyHook;
import be.isach.ultracosmetics.listeners.ClientBrandListener;
import be.isach.ultracosmetics.listeners.EntityDismountListener;
import be.isach.ultracosmetics.listeners.MainListener;
import be.isach.ultracosmetics.listeners.PlayerListener;
import be.isach.ultracosmetics.listeners.PriorityListener;
import be.isach.ultracosmetics.listeners.UnmovableItemListener;
import be.isach.ultracosmetics.menu.CosmeticsInventoryHolder;
import be.isach.ultracosmetics.menu.Menus;
import be.isach.ultracosmetics.menu.menus.CustomMainMenu;
import be.isach.ultracosmetics.mysql.MySqlConnectionManager;
import be.isach.ultracosmetics.paper.DummyPaperSupport;
import be.isach.ultracosmetics.paper.PaperSupport;
import be.isach.ultracosmetics.permissions.PermissionManager;
import be.isach.ultracosmetics.player.UltraPlayerManager;
import be.isach.ultracosmetics.run.FallDamageManager;
import be.isach.ultracosmetics.run.InvalidWorldChecker;
import be.isach.ultracosmetics.run.VanishChecker;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.minimessage.MiniMessage;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import be.isach.ultracosmetics.shaded.metrics.bukkit.Metrics;
import be.isach.ultracosmetics.shaded.metrics.charts.DrilldownPie;
import be.isach.ultracosmetics.shaded.metrics.charts.SimplePie;
import be.isach.ultracosmetics.shaded.tcoded.folialib.FoliaLib;
import be.isach.ultracosmetics.shaded.tcoded.folialib.impl.PlatformScheduler;
import be.isach.ultracosmetics.treasurechests.TreasureChestManager;
import be.isach.ultracosmetics.util.EntitySpawningManager;
import be.isach.ultracosmetics.util.InventoryViewHelper;
import be.isach.ultracosmetics.util.PermissionPrinter;
import be.isach.ultracosmetics.util.PlayerUtils;
import be.isach.ultracosmetics.util.Problem;
import be.isach.ultracosmetics.util.ProblemSeverity;
import be.isach.ultracosmetics.util.SmartLogger;
import be.isach.ultracosmetics.util.UpdateManager;
import be.isach.ultracosmetics.version.ServerVersion;
import be.isach.ultracosmetics.worldguard.WorldGuardManager;
import com.cryptomorin.xseries.XMaterial;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import me.libraryaddict.disguise.DisguiseConfig;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.messaging.PluginMessageListener;

public class UltraCosmetics
extends JavaPlugin {
    private final FoliaLib foliaLib;
    private CommandManager commandManager;
    private CustomConfiguration config;
    private File file;
    private UltraPlayerManager playerManager;
    private SmartLogger smartLogger;
    private MySqlConnectionManager mySqlConnectionManager;
    private UpdateManager updateChecker;
    private Menus menus;
    private EconomyHandler economyHandler;
    private PermissionManager permissionManager;
    private PlaceholderHook placeholderHook;
    private DiscordSRVHook discordHook;
    private ChestSortHook chestSortHook;
    private PlayerAuctionsHook playerAuctionsHook;
    private UnmovableItemListener unmovableItemListener;
    private TreasureChestManager treasureChestManager;
    private EntityDismountListener entityDismountListener;
    private PaperSupport paperSupport;
    private final WorldGuardManager worldGuardManager = new WorldGuardManager(this);
    private boolean legacyMessagePrinted = false;
    private boolean enableFinished = false;
    private Set<Problem> activeProblems = new HashSet<Problem>();
    private Set<Problem> loadTimeProblems = new HashSet<Problem>();
    private final List<String> supportedLanguages = new ArrayList<String>();
    private final List<UCAddon> addons = new ArrayList<UCAddon>();

    public UltraCosmetics() {
        this.foliaLib = new FoliaLib((Plugin)this);
    }

    public void onLoad() {
        boolean worldGuardIntegration;
        this.smartLogger = new SmartLogger(this.getLogger());
        UltraCosmeticsData.init(this);
        Problem problem = UltraCosmeticsData.get().checkServerVersion();
        if (problem != null) {
            if (problem.getSeverity() == ProblemSeverity.FATAL) {
                this.loadTimeProblems.add(problem);
                return;
            }
            this.activeProblems.add(problem);
        }
        if ((worldGuardIntegration = super.getConfig().getBoolean("WorldGuard-Integration", true)) && this.getServer().getPluginManager().getPlugin("WorldGuard") != null) {
            this.worldGuardManager.register();
        }
        this.loadTimeProblems = new HashSet<Problem>(this.activeProblems);
    }

    public void onEnable() {
        String pathPrefix = "messages/messages_";
        try {
            ZipEntry e;
            URL jar = this.getFile().toURI().toURL();
            ZipInputStream zip = new ZipInputStream(jar.openStream());
            while ((e = zip.getNextEntry()) != null) {
                String path = e.getName();
                if (!path.startsWith(pathPrefix)) continue;
                this.supportedLanguages.add(path.substring(pathPrefix.length(), pathPrefix.length() + 2));
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        this.start(true);
        PlayerUtils.class.getName();
        Bukkit.getMessenger().registerIncomingPluginChannel((Plugin)this, "minecraft:brand", (PluginMessageListener)new ClientBrandListener(this));
    }

    public void start(boolean firstRun) {
        long startTime = System.currentTimeMillis();
        this.activeProblems = new HashSet<Problem>(this.loadTimeProblems);
        this.commandManager = new CommandManager(this);
        this.getServer().getPluginManager().registerEvents((Listener)new PriorityListener(this), (Plugin)this);
        if (!this.setUpConfig()) {
            this.getSmartLogger().write(SmartLogger.LogLevel.ERROR, "Failed to load config.yml, shutting down to protect data.");
            this.getSmartLogger().write(SmartLogger.LogLevel.ERROR, "Please run config.yml through a YAML checker site.");
            this.activeProblems.add(Problem.BAD_CONFIG);
            return;
        }
        this.updateChecker = new UpdateManager(this);
        if (SettingsManager.getConfig().getBoolean("Check-For-Updates")) {
            this.getSmartLogger().write("Checking for update...");
            this.updateChecker.schedule();
        }
        if (UltraCosmeticsData.get().getServerVersion() == null) {
            this.getSmartLogger().write(SmartLogger.LogLevel.ERROR, "Plugin load has failed, please check earlier in the log for details.");
            return;
        }
        UltraCosmeticsData.get().initConfigFields();
        String langFileName = "messages_" + UltraCosmeticsData.get().getLanguage() + ".yml";
        File langFile = new File(this.getDataFolder(), langFileName);
        if (!langFile.exists()) {
            try {
                int len;
                InputStream in = this.getResource("messages/" + langFileName);
                OutputStream out = Files.newOutputStream(langFile.toPath(), new OpenOption[0]);
                byte[] buf = new byte[1024];
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                out.close();
                in.close();
            }
            catch (IOException e) {
                this.getSmartLogger().write(SmartLogger.LogLevel.ERROR, "Failed to copy " + langFileName);
            }
        }
        this.playerManager = new UltraPlayerManager(this);
        this.getSmartLogger().write("-------------------------------------------------------------------");
        this.getSmartLogger().write("Thanks for using UltraCosmetics! Version: " + this.updateChecker.getCurrentVersion().versionClassifierCommit());
        this.getSmartLogger().write("Plugin by Datatags. Original Author: iSach");
        this.getSmartLogger().write("Link: https://bit.ly/UltraCosmetics");
        if (this.activeProblems.contains((Object)Problem.BAD_MC_VERSION)) {
            this.getSmartLogger().write(new Object[0]);
            this.getSmartLogger().write(SmartLogger.LogLevel.WARNING, "This server version is unknown (" + ServerVersion.getMinecraftVersion() + "), but UltraCosmetics will try to continue running.");
        }
        if (!UltraCosmeticsData.get().initModule()) {
            return;
        }
        if (!MessageManager.load()) {
            this.getSmartLogger().write(SmartLogger.LogLevel.ERROR, "Failed to load messages.yml, shutting down to protect data.");
            this.getSmartLogger().write(SmartLogger.LogLevel.ERROR, "Please run messages.yml through a YAML checker site.");
            this.activeProblems.add(Problem.BAD_MESSAGES);
            return;
        }
        this.migrateConfigToMiniMessage();
        this.treasureChestManager = new TreasureChestManager(this);
        this.registerListeners();
        if (!this.loadPaperSupport()) {
            this.paperSupport = new DummyPaperSupport();
        }
        CosmeticType.loadCustomCosmetics();
        CosmeticType.registerAll();
        if (SettingsManager.getConfig().getBoolean("Categories-Enabled." + Category.MORPHS.getConfigPath())) {
            if (!Bukkit.getPluginManager().isPluginEnabled("LibsDisguises")) {
                this.getSmartLogger().write(new Object[0]);
                this.getSmartLogger().write(SmartLogger.LogLevel.WARNING, "Morphs require Lib's Disguises, but it is not installed. Morphs will be disabled.");
            } else {
                try {
                    if (!DisguiseConfig.isTallSelfDisguises()) {
                        this.getSmartLogger().write(new Object[0]);
                        this.getSmartLogger().write(SmartLogger.LogLevel.WARNING, "You have TallSelfDisguises disabled in LibsDisguises's players.yml. Self view of morphs may not work as expected.");
                        this.activeProblems.add(Problem.TALL_DISGUISES_DISABLED);
                    }
                }
                catch (NoClassDefFoundError | NoSuchMethodError e) {
                    // empty catch block
                }
            }
        }
        if (!UltraCosmeticsData.get().isMobChipAvailable()) {
            this.getSmartLogger().write(new Object[0]);
            this.getSmartLogger().write("MobChip does not support this version of Minecraft, pets will be disabled.");
            this.activeProblems.add(Problem.MOBCHIP_ERROR);
        }
        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            this.getSmartLogger().write(new Object[0]);
            this.placeholderHook = new PlaceholderHook(this);
            this.placeholderHook.register();
            this.getSmartLogger().write("Hooked into PlaceholderAPI");
        }
        if (firstRun) {
            this.worldGuardManager.registerPhase2();
        }
        this.setupEconomy();
        if (!UltraCosmeticsData.get().usingFileStorage()) {
            this.getSmartLogger().write(new Object[0]);
            this.getSmartLogger().write("Connecting to MySQL database...");
            this.mySqlConnectionManager = new MySqlConnectionManager(this);
            if (this.mySqlConnectionManager.success()) {
                this.mySqlConnectionManager.start();
            }
            if (this.mySqlConnectionManager.success()) {
                this.getSmartLogger().write("Connected to MySQL database.");
            } else {
                this.getSmartLogger().write("File storage will be used instead.");
                this.activeProblems.add(Problem.SQL_INIT_FAILURE);
            }
        }
        this.permissionManager = new PermissionManager(this);
        this.playerManager.initPlayers();
        new FallDamageManager().schedule();
        if (!this.config.getStringList("Enabled-Worlds").contains("*")) {
            new InvalidWorldChecker(this).schedule();
        }
        if (this.config.getBoolean("Prevent-Cosmetics-In-Vanish")) {
            new VanishChecker(this).schedule();
        }
        if (this.getServer().getPluginManager().isPluginEnabled("DiscordSRV") && !SettingsManager.getConfig().getString("DiscordSRV-Loot-Channel", "0").equals("0")) {
            this.discordHook = new DiscordSRVHook();
            this.getSmartLogger().write(new Object[0]);
            this.getSmartLogger().write("Hooked into DiscordSRV");
        }
        this.chestSortHook = this.hookIfEnabled("ChestSort", () -> new ChestSortHook(this));
        this.hookIfEnabled("Towny", TownyHook::new);
        this.playerAuctionsHook = this.hookIfEnabled("PlayerAuctions", () -> new PlayerAuctionsHook(this), 1.24f);
        this.setupMetrics();
        this.menus = new Menus(this);
        this.setupCustomMainMenu();
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        PermissionPrinter.printPermissions(this);
        this.getSmartLogger().write(new Object[0]);
        this.getSmartLogger().write("UltraCosmetics successfully finished loading in " + (System.currentTimeMillis() - startTime) + "ms!");
        this.getSmartLogger().write("-------------------------------------------------------------------");
        this.enableFinished = true;
    }

    private boolean loadPaperSupport() {
        if (!UltraCosmeticsData.get().getServerVersion().isAtLeast(ServerVersion.v1_20)) {
            return false;
        }
        try {
            this.paperSupport = Class.forName("be.isach.ultracosmetics.paper.PaperSupportImpl").asSubclass(PaperSupport.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.getSmartLogger().write("Paper-specific features enabled");
            return true;
        }
        catch (IllegalArgumentException | ReflectiveOperationException | UnsupportedClassVersionError e) {
            return false;
        }
    }

    public void onDisable() {
        this.shutdown();
    }

    public void shutdown() {
        HandlerList.unregisterAll((Plugin)this);
        this.getScheduler().cancelAllTasks();
        if (!this.enableFinished) {
            return;
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!(InventoryViewHelper.getTopInventory(player).getHolder() instanceof CosmeticsInventoryHolder)) continue;
            player.closeInventory();
        }
        if (this.mySqlConnectionManager != null && this.mySqlConnectionManager.success()) {
            this.mySqlConnectionManager.shutdown();
        }
        this.playerManager.dispose();
        UltraCosmeticsData.get().getVersionManager().getModule().disable();
    }

    public void reload() {
        this.getLogger().info("Shutting down...");
        this.shutdown();
        CosmeticType.removeAllTypes();
        this.getLogger().info("Starting up...");
        this.start(false);
        for (UCAddon addon : this.addons) {
            addon.reload(this);
        }
    }

    public void registerAddon(UCAddon addon) {
        if (this.addons.contains(addon)) {
            throw new IllegalArgumentException("This addon has already been registered!");
        }
        this.addons.add(addon);
    }

    private <T extends Listener> T hookIfEnabled(String pluginName, Supplier<T> hookSupplier) {
        if (!this.getServer().getPluginManager().isPluginEnabled(pluginName) || !SettingsManager.getConfig().getBoolean(pluginName + "-Hook", true)) {
            return null;
        }
        Listener hook = (Listener)hookSupplier.get();
        this.getServer().getPluginManager().registerEvents(hook, (Plugin)this);
        this.getSmartLogger().write(new Object[0]);
        this.getSmartLogger().write("Hooked into " + pluginName);
        return (T)hook;
    }

    private <T extends Listener> T hookIfEnabled(String pluginName, Supplier<T> hookSupplier, float requiredVersion) {
        if (!this.getServer().getPluginManager().isPluginEnabled(pluginName)) {
            return null;
        }
        Plugin plugin = this.getServer().getPluginManager().getPlugin(pluginName);
        Pattern pattern = Pattern.compile("^\\d+\\.\\d+");
        Matcher matcher = pattern.matcher(plugin.getDescription().getVersion());
        if (matcher.find()) {
            float version = Float.parseFloat(matcher.group());
            if (version < requiredVersion) {
                this.getSmartLogger().write(SmartLogger.LogLevel.WARNING, pluginName + " " + requiredVersion + " or later is required for UC to hook it.");
                return null;
            }
        } else {
            this.getSmartLogger().write(SmartLogger.LogLevel.WARNING, "Failed to parse " + pluginName + " version, hoping it's ok...");
        }
        return this.hookIfEnabled(pluginName, hookSupplier);
    }

    private void registerListeners() {
        PluginManager pluginManager = Bukkit.getPluginManager();
        pluginManager.registerEvents((Listener)new PlayerListener(this), (Plugin)this);
        pluginManager.registerEvents((Listener)new MainListener(), (Plugin)this);
        pluginManager.registerEvents((Listener)new EntitySpawningManager(), (Plugin)this);
        this.unmovableItemListener = new UnmovableItemListener(this);
        pluginManager.registerEvents((Listener)this.unmovableItemListener, (Plugin)this);
        this.entityDismountListener = new EntityDismountListener(this);
    }

    private void setupEconomy() {
        this.economyHandler = new EconomyHandler(this);
        UltraCosmeticsData.get().checkTreasureChests();
    }

    private void setupMetrics() {
        Metrics metrics = new Metrics((Plugin)this, 2629);
        ServerVersion sv = UltraCosmeticsData.get().getServerVersion();
        String nms = UltraCosmeticsData.get().getVersionManager().isUsingNMS() ? sv.getNmsVersion() : "NMS-less flattening";
        String version = this.updateChecker.getCurrentVersion().versionWithClassifier();
        metrics.addCustomChart(new DrilldownPie("uc_by_mc", () -> {
            HashMap map = new HashMap();
            HashMap<String, Integer> entry = new HashMap<String, Integer>();
            entry.put(version, 1);
            map.put(nms, entry);
            return map;
        }));
        metrics.addCustomChart(new DrilldownPie("mc_by_uc", () -> {
            HashMap map = new HashMap();
            HashMap<String, Integer> entry = new HashMap<String, Integer>();
            entry.put(nms, 1);
            map.put(version, entry);
            return map;
        }));
        metrics.addCustomChart(new SimplePie("mysql_enabled", () -> String.valueOf(this.getConfig().getBoolean("MySQL.Enabled"))));
    }

    private boolean setUpConfig() {
        this.file = new File(this.getDataFolder(), "config.yml");
        if (!this.file.exists()) {
            this.saveResource("config.yml", false);
        }
        this.config = this.loadConfiguration(c -> c.load(this.file));
        if (this.config == null) {
            return false;
        }
        Reader reader = UltraCosmeticsData.get().getPlugin().getFileReader("config.yml");
        CustomConfiguration defaults = this.loadConfiguration(c -> c.load(reader));
        if (defaults == null) {
            return false;
        }
        this.configMigration();
        boolean lootCommandsPresent = this.config.isConfigurationSection("TreasureChests.Loots.Commands");
        boolean designsPresent = this.config.isConfigurationSection("TreasureChests.Designs") && !this.config.getConfigurationSection("TreasureChests.Designs").getKeys(false).isEmpty();
        for (String key : defaults.getKeys(true)) {
            if (key.startsWith("TreasureChests.Loots.Commands.") && lootCommandsPresent && !key.endsWith("Overall-Chance") || key.startsWith("TreasureChests.Locations.default") || key.startsWith("TreasureChests.Designs") && designsPresent) continue;
            this.config.addDefault(key, defaults.get(key), defaults.comments(key));
        }
        for (String key : defaults.getConfigurationSection("TreasureChests.Loots").getKeys(false)) {
            String path = "TreasureChests.Loots." + key + ".Message.message";
            if (!this.config.isString(path)) continue;
            String msg = this.config.getString(path);
            this.config.set(path, msg.replaceAll("%(?!ammo|name|prefix|money)[\\w-]+%", "%cosmetic%"));
        }
        this.config.set("Disabled-Items", null);
        this.config.set("Menu-Item.Data", null);
        this.config.set("Supported-Languages", this.supportedLanguages, "Languages supported by this version of UltraCosmetics.", "This is not a configurable list, just informative.");
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private void configMigration() {
        String oldEffects;
        String oldMysqlKey;
        ConfigurationSection oldSQL = SettingsManager.getConfig().getConfigurationSection("Ammo-System-For-Gadgets.MySQL");
        if (oldSQL != null) {
            SettingsManager.getConfig().set("MySQL", oldSQL);
            SettingsManager.getConfig().set("Ammo-System-For-Gadgets.MySQL", null);
        }
        if (this.config.isString(oldMysqlKey = "Ammo-System-For-Gadgets.System")) {
            this.config.set("MySQL.Enabled", false);
            this.config.set(oldMysqlKey, null);
        }
        if (this.config.isString("MySQL.table")) {
            this.config.set("MySQL.table", null);
            if (this.config.getBoolean("MySQL.Enabled")) {
                this.config.set("MySQL.Enabled", false);
                this.config.set("MySQL.Legacy", (Object)true, "To remove the warning about how the SQL config options", "have changed, delete this key.");
            }
        }
        if (this.config.getBoolean("MySQL.Legacy")) {
            this.getSmartLogger().write(SmartLogger.LogLevel.WARNING, "SQL config options have changed, please check they are correct.");
            this.getSmartLogger().write(SmartLogger.LogLevel.WARNING, "Remove the 'Legacy' key in the MySQL block to remove this message.");
            this.addProblem(Problem.SQL_MIGRATION_REQUIRED);
        }
        if (this.config.isBoolean("Auto-Equip-Cosmetics.is-enabled")) {
            boolean autoEquip = this.config.getBoolean("Auto-Equip-Cosmetics.is-enabled");
            this.config.set("Auto-Equip-Cosmetics", (Object)autoEquip, "Allows for players to auto-equip on join cosmetics they had before disconnecting.", "Supports both flatfile and SQL, choosing SQL when possible.");
        }
        if (this.config.isBoolean("Menu-Item.Give-On-Join")) {
            boolean enabled = this.config.getBoolean("Menu-Item.Give-On-Join");
            this.config.set("Menu-Item.Enabled", enabled);
            this.config.set("Menu-Item.Give-On-Join", null);
            this.config.set("Menu-Item.Give-On-Respawn", null);
        }
        if (this.config.isConfigurationSection(oldEffects = "Treasure-Chests-Loot.Effects")) {
            this.config.set("Treasure-Chests-Loot.Particle-Effects", this.config.getConfigurationSection(oldEffects));
            this.config.set(oldEffects, null);
        }
        this.upgradeIdsToMaterials();
    }

    private void migrateConfigToMiniMessage() {
        this.migrateKeyToMiniMessage("Menu-Item.Displayname");
        this.migrateKeyToMiniMessage("Menu-Item.Lore");
        this.migrateKeyToMiniMessage("No-Permission.Custom-Item.Name");
        this.migrateKeyToMiniMessage("No-Permission.Custom-Item.Lore");
        ConfigurationSection commands = this.config.getConfigurationSection("TreasureChests.Loots.Commands");
        for (String key : commands.getKeys(false)) {
            this.migrateKeyToMiniMessage(commands.getCurrentPath() + "." + key + ".Name");
        }
    }

    private void migrateKeyToMiniMessage(String path) {
        String raw;
        if (this.config.isString(path)) {
            raw = this.config.getString(path);
        } else if (this.config.isList(path)) {
            raw = String.join((CharSequence)"\n", this.config.getStringList(path));
        } else {
            return;
        }
        if (!raw.contains("&")) {
            return;
        }
        MiniMessage mm = MessageManager.getMiniMessage();
        LegacyComponentSerializer deserializer = MessageManager.legacySerializer();
        String[] parts = raw.split("\n");
        StringBuilder builder = new StringBuilder((String)mm.serialize(deserializer.deserialize(parts[0])));
        for (int i = 1; i < parts.length; ++i) {
            builder.append("\n").append((String)mm.serialize(deserializer.deserialize(parts[i])));
        }
        this.config.set(path, builder.toString());
    }

    private void setupCustomMainMenu() {
        File customFile = CustomMainMenu.getFile(this);
        if (!customFile.exists()) {
            this.saveResource(customFile.getName(), false);
        }
        CustomMainMenu customMenu = null;
        try {
            customMenu = new CustomMainMenu(this);
        }
        catch (IllegalArgumentException e) {
            this.getSmartLogger().write(SmartLogger.LogLevel.WARNING, "Failed to load custom main menu, please run it through a YAML checker");
        }
        if (customMenu.isEnabled()) {
            this.menus.setMainMenu(customMenu);
        }
    }

    public FoliaLib getFoliaLib() {
        return this.foliaLib;
    }

    public PlatformScheduler getScheduler() {
        return this.foliaLib.getScheduler();
    }

    public UltraPlayerManager getPlayerManager() {
        return this.playerManager;
    }

    public CommandManager getCommandManager() {
        return this.commandManager;
    }

    public File getFile() {
        return super.getFile();
    }

    public File getConfigFile() {
        return this.file;
    }

    public Reader getFileReader(String path) {
        return this.getTextResource(path);
    }

    public CustomConfiguration getConfig() {
        return this.config;
    }

    public SmartLogger getSmartLogger() {
        return this.smartLogger;
    }

    public UpdateManager getUpdateChecker() {
        return this.updateChecker;
    }

    public Menus getMenus() {
        return this.menus;
    }

    public MySqlConnectionManager getMySqlConnectionManager() {
        return this.mySqlConnectionManager;
    }

    public EconomyHandler getEconomyHandler() {
        return this.economyHandler;
    }

    public PermissionManager getPermissionManager() {
        return this.permissionManager;
    }

    public WorldGuardManager getWorldGuardManager() {
        return this.worldGuardManager;
    }

    public PlaceholderHook getPlaceholderHook() {
        return this.placeholderHook;
    }

    public DiscordSRVHook getDiscordHook() {
        return this.discordHook;
    }

    public ChestSortHook getChestSortHook() {
        return this.chestSortHook;
    }

    public UnmovableItemListener getUnmovableItemListener() {
        return this.unmovableItemListener;
    }

    public EntityDismountListener getEntityDismountListener() {
        return this.entityDismountListener;
    }

    public TreasureChestManager getTreasureChestManager() {
        return this.treasureChestManager;
    }

    public CustomConfiguration loadConfiguration(FunctionalConfigLoader loaderFunc) {
        CustomConfiguration config;
        try {
            ConfigurationSection.class.getDeclaredMethod("getComments", String.class);
            config = new AutoCommentConfiguration();
        }
        catch (NoSuchMethodException ignored) {
            config = new ManualCommentConfiguration();
        }
        catch (SecurityException e) {
            e.printStackTrace();
            return null;
        }
        try {
            loaderFunc.load(config);
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException | InvalidConfigurationException ex) {
            this.getSmartLogger().write(SmartLogger.LogLevel.ERROR, "Cannot load " + String.valueOf(this.file), ex);
            return null;
        }
        return config;
    }

    private void upgradeIdsToMaterials() {
        this.upgradeKeyToMaterial("Categories.Gadgets.Main-Menu-Item", "409:0", XMaterial.PRISMARINE_SHARD);
        this.upgradeKeyToMaterial("Categories.Particle-Effects.Main-Menu-Item", "399:0", XMaterial.NETHER_STAR);
        this.upgradeKeyToMaterial("Categories.Mounts.Main-Menu-Item", "329:0", XMaterial.SADDLE);
        this.upgradeKeyToMaterial("Categories.Pets.Main-Menu-Item", "352:0", XMaterial.BONE);
        this.upgradeKeyToMaterial("Categories.Morphs.Main-Menu-Item", "334:0", XMaterial.LEATHER);
        this.upgradeKeyToMaterial("Categories.Hats.Main-Menu-Item", "314:0", XMaterial.GOLDEN_HELMET);
        this.upgradeKeyToMaterial("Categories.Suits.Main-Menu-Item", "299:0", XMaterial.LEATHER_CHESTPLATE);
        this.upgradeKeyToMaterial("Categories.Clear-Cosmetic-Item", "152:0", XMaterial.REDSTONE_BLOCK);
        this.upgradeKeyToMaterial("Categories.Previous-Page-Item", "368:0", XMaterial.ENDER_PEARL);
        this.upgradeKeyToMaterial("Categories.Next-Page-Item", "381:0", XMaterial.ENDER_EYE);
        this.upgradeKeyToMaterial("Categories.Back-Main-Menu-Item", "262:0", XMaterial.ARROW);
        this.upgradeKeyToMaterial("Categories.Self-View-Item.When-Enabled", "381:0", XMaterial.ENDER_EYE);
        this.upgradeKeyToMaterial("Categories.Self-View-Item.When-Disabled", "368:0", XMaterial.ENDER_PEARL);
        this.upgradeKeyToMaterial("Categories.Gadgets-Item.When-Enabled", "351:10", XMaterial.LIGHT_GRAY_DYE);
        this.upgradeKeyToMaterial("Categories.Gadgets-Item.When-Disabled", "351:8", XMaterial.GRAY_DYE);
        this.upgradeKeyToMaterial("Categories.Rename-Pet-Item", "421:0", XMaterial.NAME_TAG);
        this.upgradeKeyToMaterial("TreasureChests.Designs.Classic.center-block", "169:0", XMaterial.SEA_LANTERN);
        this.upgradeKeyToMaterial("TreasureChests.Designs.Classic.around-center", "5:0", XMaterial.OAK_PLANKS);
        this.upgradeKeyToMaterial("TreasureChests.Designs.Classic.third-blocks", "5:1", XMaterial.SPRUCE_PLANKS);
        this.upgradeKeyToMaterial("TreasureChests.Designs.Classic.below-chests", "17:0", XMaterial.OAK_LOG);
        this.upgradeKeyToMaterial("TreasureChests.Designs.Classic.barriers", "85:0", XMaterial.OAK_FENCE);
        this.upgradeKeyToMaterial("TreasureChests.Designs.Modern.center-block", "169:0", XMaterial.SEA_LANTERN);
        this.upgradeKeyToMaterial("TreasureChests.Designs.Modern.around-center", "159:11", XMaterial.BLUE_TERRACOTTA);
        this.upgradeKeyToMaterial("TreasureChests.Designs.Modern.third-blocks", "155:0", XMaterial.WHITE_TERRACOTTA);
        this.upgradeKeyToMaterial("TreasureChests.Designs.Modern.below-chests", "159:11", XMaterial.BLUE_TERRACOTTA);
        this.upgradeKeyToMaterial("TreasureChests.Designs.Modern.barriers", "160:3", XMaterial.LIGHT_BLUE_STAINED_GLASS_PANE);
        this.upgradeKeyToMaterial("TreasureChests.Designs.Nether.center-block", "89:0", XMaterial.GLOWSTONE);
        this.upgradeKeyToMaterial("TreasureChests.Designs.Nether.around-center", "88:0", XMaterial.SOUL_SAND);
        this.upgradeKeyToMaterial("TreasureChests.Designs.Nether.third-blocks", "87:0", XMaterial.NETHERRACK);
        this.upgradeKeyToMaterial("TreasureChests.Designs.Nether.below-chests", "112:0", XMaterial.NETHER_BRICKS);
        this.upgradeKeyToMaterial("TreasureChests.Designs.Nether.barriers", "113:0", XMaterial.NETHER_BRICK_FENCE);
        this.upgradeKeyToMaterial("Fill-Blank-Slots-With-Item.Item", "160:15", XMaterial.BLACK_STAINED_GLASS_PANE);
    }

    private void upgradeKeyToMaterial(String key, String oldValue, XMaterial newValue) {
        if (oldValue.equals(this.config.getString(key))) {
            if (!this.legacyMessagePrinted) {
                this.getSmartLogger().write(SmartLogger.LogLevel.WARNING, "You seem to still have numeric IDs in your config, which UC no longer supports.");
                this.getSmartLogger().write(SmartLogger.LogLevel.WARNING, "I'll attempt to upgrade them, but only if the values haven't been touched.");
                this.legacyMessagePrinted = true;
            }
            this.config.set(key, newValue.toString());
            this.getSmartLogger().write(SmartLogger.LogLevel.INFO, "Successfully upgraded key '" + key + "' from '" + oldValue + "' to '" + String.valueOf(newValue) + "'!");
        } else if (this.legacyMessagePrinted) {
            this.getSmartLogger().write(SmartLogger.LogLevel.WARNING, "Couldn't upgrade key '" + key + "' because it has been changed. Please upgrade it manually.");
        }
    }

    public void addProblem(Problem problem) {
        this.activeProblems.add(problem);
    }

    public Set<Problem> getProblems() {
        return this.activeProblems;
    }

    public Set<Problem> getSevereProblems() {
        HashSet<Problem> severe = new HashSet<Problem>(this.activeProblems);
        severe.removeIf(p -> p.getSeverity() != ProblemSeverity.FATAL);
        return severe;
    }

    public PaperSupport getPaperSupport() {
        return this.paperSupport;
    }
}

