/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.entity.entries.variable;

import com.typewritermc.core.extension.annotations.Entry;
import com.typewritermc.core.extension.annotations.GenericConstraint;
import com.typewritermc.core.extension.annotations.VariableData;
import com.typewritermc.engine.paper.TypewriterPaperPluginKt;
import com.typewritermc.engine.paper.entry.entity.SkinProperty;
import com.typewritermc.engine.paper.entry.entity.SkinPropertyKt;
import com.typewritermc.engine.paper.entry.entries.VarContext;
import com.typewritermc.engine.paper.entry.entries.VariableEntry;
import com.typewritermc.engine.paper.extensions.placeholderapi.PlaceholderExpansionKt;
import com.typewritermc.entity.entries.variable.SkinVariableData;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KClasses;
import lirand.api.extensions.server.ServerExtensionsKt;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Entry(name="skin_variable", description="A variable that returns a players skin based on the uuid", color="#4CAF50", icon="ant-design:skin-filled")
@GenericConstraint(type=SkinProperty.class)
@VariableData(type=SkinVariableData.class)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J%\u0010\n\u001a\u0002H\u000b\"\b\b\u0000\u0010\u000b*\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0010"}, d2={"Lcom/typewritermc/entity/entries/variable/SkinVariable;", "Lcom/typewritermc/engine/paper/entry/entries/VariableEntry;", "id", "", "name", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "getName", "get", "T", "", "context", "Lcom/typewritermc/engine/paper/entry/entries/VarContext;", "(Lcom/typewritermc/engine/paper/entry/entries/VarContext;)Ljava/lang/Object;", "EntityExtension"})
@SourceDebugExtension(value={"SMAP\nSkinVariable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SkinVariable.kt\ncom/typewritermc/entity/entries/variable/SkinVariable\n+ 2 VariableEntry.kt\ncom/typewritermc/engine/paper/entry/entries/VariableEntryKt\n*L\n1#1,56:1\n35#2:57\n*S KotlinDebug\n*F\n+ 1 SkinVariable.kt\ncom/typewritermc/entity/entries/variable/SkinVariable\n*L\n40#1:57\n*E\n"})
public final class SkinVariable
implements VariableEntry {
    @NotNull
    private final String id;
    @NotNull
    private final String name;

    public SkinVariable(@NotNull String id, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.id = id;
        this.name = name;
    }

    public /* synthetic */ SkinVariable(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            string2 = "";
        }
        this(string, string2);
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public <T> T get(@NotNull VarContext<T> context) {
        UUID $i$f$getData2;
        Intrinsics.checkNotNullParameter(context, (String)"context");
        VarContext<T> $this$getData$iv = context;
        boolean $i$f$getData2 = false;
        SkinVariableData skinVariableData = (SkinVariableData)$this$getData$iv.getData(SkinVariableData.class);
        if (skinVariableData == null) {
            throw new IllegalStateException("Could not find data for " + context.getKlass() + ", data: " + context.getData() + " for entry " + this.getId());
        }
        SkinVariableData data = skinVariableData;
        String possibleUUID = PlaceholderExpansionKt.parsePlaceholders((String)data.getUuid(), (Player)context.getPlayer());
        try {
            $i$f$getData2 = UUID.fromString(possibleUUID);
        }
        catch (IllegalArgumentException e) {
            TypewriterPaperPluginKt.getLogger().warning("Could not parse uuid '" + possibleUUID + "' for entry " + this.getId() + ", using player uuid instead");
            $i$f$getData2 = context.getPlayer().getUniqueId();
        }
        UUID uuid = $i$f$getData2;
        OfflinePlayer offlinePlayer = ServerExtensionsKt.getServer().getOfflinePlayer(uuid);
        Intrinsics.checkNotNullExpressionValue((Object)offlinePlayer, (String)"getOfflinePlayer(...)");
        SkinProperty skin = SkinPropertyKt.getSkin((OfflinePlayer)offlinePlayer);
        Object object = KClasses.safeCast((KClass)context.getKlass(), (Object)skin);
        if (object == null) {
            throw new IllegalStateException("Could not cast skin to " + context.getKlass() + ", SkinProperty is only compatible with SkinProperty fields");
        }
        return (T)object;
    }

    public SkinVariable() {
        this(null, null, 3, null);
    }
}

