/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.entity.entries.entity.custom;

import com.typewritermc.core.entries.Ref;
import com.typewritermc.core.utils.point.Vector;
import com.typewritermc.engine.paper.entry.entity.EntityState;
import com.typewritermc.engine.paper.entry.entity.FakeEntity;
import com.typewritermc.engine.paper.entry.entity.PositionProperty;
import com.typewritermc.engine.paper.entry.entries.EntityDefinitionEntry;
import com.typewritermc.engine.paper.entry.entries.EntityProperty;
import com.typewritermc.engine.paper.entry.entries.LinesProperty;
import com.typewritermc.engine.paper.entry.entries.Var;
import com.typewritermc.engine.paper.extensions.placeholderapi.PlaceholderExpansionKt;
import com.typewritermc.engine.paper.utils.Color;
import com.typewritermc.engine.paper.utils.ExtensionsKt;
import com.typewritermc.engine.paper.utils.MiniMessagesKt;
import com.typewritermc.entity.entries.data.minecraft.display.BillboardConstraintProperty;
import com.typewritermc.entity.entries.data.minecraft.display.TranslationProperty;
import com.typewritermc.entity.entries.data.minecraft.display.text.BackgroundColorProperty;
import com.typewritermc.entity.entries.entity.custom.InteractionIndicatorEntity;
import com.typewritermc.entity.entries.entity.custom.NamedEntityKt;
import com.typewritermc.entity.entries.entity.minecraft.TextDisplayEntity;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import me.tofaa.entitylib.meta.display.AbstractDisplayMeta;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0001\u0012\u000e\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0016\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0016J\b\u0010\u001e\u001a\u00020\u001aH\u0016J\b\u0010\r\u001a\u00020\u0006H\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0006H\u0002J\u0010\u0010\"\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020\u0001H\u0016J\u0010\u0010'\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020\u0001H\u0016J\u0011\u0010(\u001a\u00020)2\u0006\u0010\u0011\u001a\u00020\u0012H\u0096\u0002J\b\u0010*\u001a\u00020\u001aH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006+"}, d2={"Lcom/typewritermc/entity/entries/entity/custom/NamedEntity;", "Lcom/typewritermc/engine/paper/entry/entity/FakeEntity;", "player", "Lorg/bukkit/entity/Player;", "displayName", "Lcom/typewritermc/engine/paper/entry/entries/Var;", "", "baseEntity", "definition", "Lcom/typewritermc/core/entries/Ref;", "Lcom/typewritermc/engine/paper/entry/entries/EntityDefinitionEntry;", "<init>", "(Lorg/bukkit/entity/Player;Lcom/typewritermc/engine/paper/entry/entries/Var;Lcom/typewritermc/engine/paper/entry/entity/FakeEntity;Lcom/typewritermc/core/entries/Ref;)V", "hologram", "Lcom/typewritermc/entity/entries/entity/minecraft/TextDisplayEntity;", "indicatorEntity", "Lcom/typewritermc/entity/entries/entity/custom/InteractionIndicatorEntity;", "entityId", "", "getEntityId", "()I", "state", "Lcom/typewritermc/engine/paper/entry/entity/EntityState;", "getState", "()Lcom/typewritermc/engine/paper/entry/entity/EntityState;", "applyProperties", "", "properties", "", "Lcom/typewritermc/engine/paper/entry/entries/EntityProperty;", "tick", "calculateIndicatorOffset", "Lcom/typewritermc/core/utils/point/Vector;", "hologramText", "spawn", "location", "Lcom/typewritermc/engine/paper/entry/entity/PositionProperty;", "addPassenger", "entity", "removePassenger", "contains", "", "dispose", "EntityExtension"})
@SourceDebugExtension(value={"SMAP\nNamedEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NamedEntity.kt\ncom/typewritermc/entity/entries/entity/custom/NamedEntity\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,161:1\n1104#2,3:162\n*S KotlinDebug\n*F\n+ 1 NamedEntity.kt\ncom/typewritermc/entity/entries/entity/custom/NamedEntity\n*L\n119#1:162,3\n*E\n"})
public final class NamedEntity
extends FakeEntity {
    @NotNull
    private final Var<String> displayName;
    @NotNull
    private final FakeEntity baseEntity;
    @NotNull
    private final TextDisplayEntity hologram;
    @NotNull
    private final InteractionIndicatorEntity indicatorEntity;

    public NamedEntity(@NotNull Player player, @NotNull Var<String> displayName, @NotNull FakeEntity baseEntity, @NotNull Ref<? extends EntityDefinitionEntry> definition) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter(displayName, (String)"displayName");
        Intrinsics.checkNotNullParameter((Object)baseEntity, (String)"baseEntity");
        Intrinsics.checkNotNullParameter(definition, (String)"definition");
        super(player);
        this.displayName = displayName;
        this.baseEntity = baseEntity;
        this.hologram = new TextDisplayEntity(player);
        this.indicatorEntity = new InteractionIndicatorEntity(player, definition);
        String hologramText = this.hologram();
        EntityProperty[] entityPropertyArray = new EntityProperty[]{new LinesProperty(hologramText), new TranslationProperty(new Vector(0.0, NamedEntityKt.getNamePlateOffset(), 0.0, 5, null)), new BillboardConstraintProperty(AbstractDisplayMeta.BillboardConstraints.CENTER), new BackgroundColorProperty(Color.Companion.fromHex(NamedEntityKt.getNamePlateColor()))};
        this.hologram.consumeProperties(entityPropertyArray);
        entityPropertyArray = new EntityProperty[]{new TranslationProperty(this.calculateIndicatorOffset(hologramText)), new BillboardConstraintProperty(AbstractDisplayMeta.BillboardConstraints.CENTER), new BackgroundColorProperty(Color.Companion.fromHex(NamedEntityKt.getNamePlateColor()))};
        this.indicatorEntity.consumeProperties(entityPropertyArray);
    }

    public int getEntityId() {
        return this.baseEntity.getEntityId();
    }

    @NotNull
    public EntityState getState() {
        return this.baseEntity.getState();
    }

    public void applyProperties(@NotNull List<? extends EntityProperty> properties) {
        Intrinsics.checkNotNullParameter(properties, (String)"properties");
        this.baseEntity.consumeProperties(properties);
    }

    public void tick() {
        this.baseEntity.tick();
        String hologramText = this.hologram();
        EntityProperty[] entityPropertyArray = new EntityProperty[]{new LinesProperty(hologramText)};
        this.hologram.consumeProperties(entityPropertyArray);
        this.hologram.tick();
        entityPropertyArray = new EntityProperty[]{new TranslationProperty(this.calculateIndicatorOffset(hologramText))};
        this.indicatorEntity.consumeProperties(entityPropertyArray);
        this.indicatorEntity.tick();
    }

    private final String hologram() {
        Object object = (LinesProperty)this.property(Reflection.getOrCreateKotlinClass(LinesProperty.class));
        if (object == null || (object = object.getLines()) == null) {
            object = "";
        }
        Object other = object;
        Var<String> displayName = this.displayName;
        TagResolver[] tagResolverArray = new TagResolver[]{Placeholder.parsed((String)"other", (String)other), Placeholder.parsed((String)"display_name", (String)PlaceholderExpansionKt.parsePlaceholders((String)((String)displayName.get(this.getPlayer())), (Player)this.getPlayer()))};
        return ((Object)StringsKt.trim((CharSequence)MiniMessagesKt.asMini((Component)MiniMessagesKt.asMiniWithResolvers((String)PlaceholderExpansionKt.parsePlaceholders((String)NamedEntityKt.getNamePlate(), (Player)this.getPlayer()), (TagResolver[])tagResolverArray)))).toString();
    }

    private final Vector calculateIndicatorOffset(String hologramText) {
        CharSequence $this$count$iv = hologramText;
        boolean $i$f$count = false;
        int count$iv = 0;
        for (int i = 0; i < $this$count$iv.length(); ++i) {
            char element$iv;
            char it = element$iv = $this$count$iv.charAt(i);
            boolean bl = false;
            if (!(it == '\n')) continue;
            ++count$iv;
        }
        int lines = count$iv + 1;
        double height = (double)lines * 0.3 + NamedEntityKt.getNamePlateOffset();
        return new Vector(0.0, height, 0.0, 5, null);
    }

    public void spawn(@NotNull PositionProperty location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.baseEntity.spawn(location);
        this.hologram.spawn(location);
        if (ExtensionsKt.isFloodgate((Player)this.getPlayer())) {
            this.baseEntity.addPassenger((FakeEntity)this.hologram);
        } else {
            this.indicatorEntity.spawn(location);
            this.baseEntity.addPassenger((FakeEntity)this.hologram);
            this.baseEntity.addPassenger((FakeEntity)this.indicatorEntity);
        }
    }

    public void addPassenger(@NotNull FakeEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        this.baseEntity.addPassenger(entity);
    }

    public void removePassenger(@NotNull FakeEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        this.baseEntity.removePassenger(entity);
    }

    public boolean contains(int entityId) {
        if (this.baseEntity.contains(entityId)) {
            return true;
        }
        if (this.hologram.contains(entityId)) {
            return true;
        }
        return this.indicatorEntity.contains(entityId);
    }

    public void dispose() {
        this.baseEntity.dispose();
        this.hologram.dispose();
        this.indicatorEntity.dispose();
    }
}

