/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.entity.entries.data.minecraft.living;

import com.typewritermc.core.extension.annotations.Entry;
import com.typewritermc.engine.paper.entry.entries.AudienceDisplay;
import com.typewritermc.engine.paper.entry.entries.LivingEntityData;
import com.typewritermc.entity.entries.data.minecraft.living.EquipmentDataKt;
import com.typewritermc.entity.entries.data.minecraft.living.EquipmentProperty;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.jetbrains.annotations.NotNull;

@Entry(name="viewer_equipment_data", description="The equipment of the viewer", color="#D32F2F", icon="mdi:account-multiple-outline")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B+\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0005\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lcom/typewritermc/entity/entries/data/minecraft/living/ViewerEquipmentData;", "Lcom/typewritermc/engine/paper/entry/entries/LivingEntityData;", "Lcom/typewritermc/entity/entries/data/minecraft/living/EquipmentProperty;", "id", "", "name", "priorityOverride", "Ljava/util/Optional;", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Optional;)V", "getId", "()Ljava/lang/String;", "getName", "getPriorityOverride", "()Ljava/util/Optional;", "type", "Lkotlin/reflect/KClass;", "build", "player", "Lorg/bukkit/entity/Player;", "EntityExtension"})
public final class ViewerEquipmentData
implements LivingEntityData<EquipmentProperty> {
    @NotNull
    private final String id;
    @NotNull
    private final String name;
    @NotNull
    private final Optional<Integer> priorityOverride;

    public ViewerEquipmentData(@NotNull String id, @NotNull String name, @NotNull Optional<Integer> priorityOverride) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(priorityOverride, (String)"priorityOverride");
        this.id = id;
        this.name = name;
        this.priorityOverride = priorityOverride;
    }

    public /* synthetic */ ViewerEquipmentData(String string, String string2, Optional optional, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            string2 = "";
        }
        if ((n & 4) != 0) {
            optional = Optional.empty();
        }
        this(string, string2, optional);
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public Optional<Integer> getPriorityOverride() {
        return this.priorityOverride;
    }

    @NotNull
    public KClass<EquipmentProperty> type() {
        return Reflection.getOrCreateKotlinClass(EquipmentProperty.class);
    }

    @NotNull
    public EquipmentProperty build(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        EntityEquipment entityEquipment = player.getEquipment();
        Intrinsics.checkNotNullExpressionValue((Object)entityEquipment, (String)"getEquipment(...)");
        return EquipmentDataKt.toProperty(entityEquipment);
    }

    public boolean canApply(@NotNull Player player) {
        return LivingEntityData.DefaultImpls.canApply((LivingEntityData)this, (Player)player);
    }

    @NotNull
    public AudienceDisplay display() {
        return LivingEntityData.DefaultImpls.display((LivingEntityData)this);
    }

    public ViewerEquipmentData() {
        this(null, null, null, 7, null);
    }
}

