/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.entity.entries.cinematic;

import com.github.retrooper.packetevents.protocol.entity.pose.EntityPose;
import com.typewritermc.core.utils.point.Coordinate;
import com.typewritermc.engine.paper.content.ContentContext;
import com.typewritermc.engine.paper.content.modes.RecordingCinematicContentMode;
import com.typewritermc.engine.paper.extensions.packetevents.ArmSwing;
import com.typewritermc.engine.paper.utils.PointKt;
import com.typewritermc.entity.entries.cinematic.EntityFrame;
import com.typewritermc.entity.entries.data.minecraft.PoseDataKt;
import io.papermc.paper.event.player.PlayerArmSwingEvent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.entity.Pose;
import org.bukkit.event.EventHandler;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u0014\u001a\u00020\u0002H\u0016J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0002H\u0016R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/typewritermc/entity/entries/cinematic/EntityCinematicRecording;", "Lcom/typewritermc/engine/paper/content/modes/RecordingCinematicContentMode;", "Lcom/typewritermc/entity/entries/cinematic/EntityFrame;", "context", "Lcom/typewritermc/engine/paper/content/ContentContext;", "player", "Lorg/bukkit/entity/Player;", "initialFrame", "", "klass", "Lkotlin/reflect/KClass;", "<init>", "(Lcom/typewritermc/engine/paper/content/ContentContext;Lorg/bukkit/entity/Player;ILkotlin/reflect/KClass;)V", "swing", "Lcom/typewritermc/engine/paper/extensions/packetevents/ArmSwing;", "onArmSwing", "", "event", "Lio/papermc/paper/event/player/PlayerArmSwingEvent;", "addSwing", "captureFrame", "applyState", "value", "EntityExtension"})
@SourceDebugExtension(value={"SMAP\nEntityCinematicEntry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EntityCinematicEntry.kt\ncom/typewritermc/entity/entries/cinematic/EntityCinematicRecording\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,348:1\n1#2:349\n*E\n"})
public final class EntityCinematicRecording
extends RecordingCinematicContentMode<EntityFrame> {
    @Nullable
    private ArmSwing swing;

    public EntityCinematicRecording(@NotNull ContentContext context, @NotNull Player player, int initialFrame, @NotNull KClass<EntityFrame> klass) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        super(context, player, initialFrame, klass);
    }

    @EventHandler
    public final void onArmSwing(@NotNull PlayerArmSwingEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!Intrinsics.areEqual((Object)event.getPlayer().getUniqueId(), (Object)this.getPlayer().getUniqueId())) {
            return;
        }
        this.addSwing(switch (WhenMappings.$EnumSwitchMapping$0[event.getHand().ordinal()]) {
            case 1 -> ArmSwing.LEFT;
            case 2 -> ArmSwing.RIGHT;
            default -> ArmSwing.BOTH;
        });
    }

    private final void addSwing(ArmSwing swing) {
        if (this.swing != null && this.swing != swing) {
            this.swing = ArmSwing.BOTH;
            return;
        }
        this.swing = swing;
    }

    @NotNull
    public EntityFrame captureFrame() {
        Pose pose;
        PlayerInventory playerInventory = this.getPlayer().getInventory();
        Intrinsics.checkNotNullExpressionValue((Object)playerInventory, (String)"getInventory(...)");
        PlayerInventory inv = playerInventory;
        if (this.getPlayer().isInsideVehicle()) {
            pose = Pose.SITTING;
        } else {
            Pose pose2 = this.getPlayer().getPose();
            pose = pose2;
            Intrinsics.checkNotNullExpressionValue((Object)pose2, (String)"getPose(...)");
        }
        Pose pose3 = pose;
        Location location = this.getPlayer().getLocation();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getLocation(...)");
        EntityFrame data = new EntityFrame(PointKt.toCoordinate((Location)location), PoseDataKt.toEntityPose(pose3), this.swing, inv.getItemInMainHand(), inv.getItemInOffHand(), inv.getHelmet(), inv.getChestplate(), inv.getLeggings(), inv.getBoots());
        this.swing = null;
        return data;
    }

    public void applyState(@NotNull EntityFrame value) {
        block13: {
            Coordinate it;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Coordinate coordinate = value.getLocation();
            if (coordinate != null) {
                it = coordinate;
                boolean bl = false;
                Player player = this.getPlayer();
                World world = this.getPlayer().getWorld();
                Intrinsics.checkNotNullExpressionValue((Object)world, (String)"getWorld(...)");
                player.teleport(PointKt.toBukkitLocation((Coordinate)it, (World)world));
            }
            EntityPose entityPose = value.getPose();
            if (entityPose != null) {
                it = entityPose;
                boolean bl = false;
                this.getPlayer().setPose(PoseDataKt.toBukkitPose((EntityPose)it));
            }
            ArmSwing armSwing = value.getSwing();
            if (armSwing != null) {
                ArmSwing swing = armSwing;
                boolean bl = false;
                switch (WhenMappings.$EnumSwitchMapping$1[swing.ordinal()]) {
                    case 1: {
                        this.getPlayer().swingMainHand();
                        break;
                    }
                    case 2: {
                        this.getPlayer().swingOffHand();
                        break;
                    }
                    case 3: {
                        this.getPlayer().swingMainHand();
                        this.getPlayer().swingOffHand();
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            ItemStack itemStack = value.getMainHand();
            if (itemStack != null) {
                it = itemStack;
                boolean bl = false;
                this.getPlayer().getInventory().setItemInMainHand((ItemStack)it);
            }
            ItemStack itemStack2 = value.getOffHand();
            if (itemStack2 != null) {
                it = itemStack2;
                boolean bl = false;
                this.getPlayer().getInventory().setItemInOffHand((ItemStack)it);
            }
            ItemStack itemStack3 = value.getHelmet();
            if (itemStack3 != null) {
                it = itemStack3;
                boolean bl = false;
                this.getPlayer().getInventory().setHelmet((ItemStack)it);
            }
            ItemStack itemStack4 = value.getChestplate();
            if (itemStack4 != null) {
                it = itemStack4;
                boolean bl = false;
                this.getPlayer().getInventory().setChestplate((ItemStack)it);
            }
            ItemStack itemStack5 = value.getLeggings();
            if (itemStack5 != null) {
                it = itemStack5;
                boolean bl = false;
                this.getPlayer().getInventory().setLeggings((ItemStack)it);
            }
            ItemStack itemStack6 = value.getBoots();
            if (itemStack6 == null) break block13;
            it = itemStack6;
            boolean bl = false;
            this.getPlayer().getInventory().setBoots((ItemStack)it);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[EquipmentSlot.values().length];
            try {
                nArray[EquipmentSlot.OFF_HAND.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EquipmentSlot.HAND.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ArmSwing.values().length];
            try {
                nArray[ArmSwing.LEFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ArmSwing.RIGHT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ArmSwing.BOTH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

