/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.entity.entries.activity;

import com.typewritermc.core.entries.Ref;
import com.typewritermc.core.extension.annotations.Entry;
import com.typewritermc.core.extension.annotations.Help;
import com.typewritermc.engine.paper.entry.TriggerableEntry;
import com.typewritermc.engine.paper.entry.entity.ActivityContext;
import com.typewritermc.engine.paper.entry.entity.EntityActivity;
import com.typewritermc.engine.paper.entry.entity.IdleActivity;
import com.typewritermc.engine.paper.entry.entity.IndividualActivityContext;
import com.typewritermc.engine.paper.entry.entity.PositionProperty;
import com.typewritermc.engine.paper.entry.entity.SharedActivityContext;
import com.typewritermc.engine.paper.entry.entries.EntityActivityEntry;
import com.typewritermc.engine.paper.entry.entries.GenericEntityActivityEntry;
import com.typewritermc.entity.entries.activity.TriggerActivity;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Entry(name="trigger_activity", description="Triggers a sequence when the activity active or inactive", color="#3366CC", icon="fa-solid:play")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001BM\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\u0010\b\u0002\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006\u0012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u0006\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR$\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00068\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\"\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00068\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0014\u0010\u0011\u001a\u0004\b\u0015\u0010\u0013R\"\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u00068\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0016\u0010\u0011\u001a\u0004\b\u0017\u0010\u0013\u00a8\u0006\u001e"}, d2={"Lcom/typewritermc/entity/entries/activity/TriggerActivityEntry;", "Lcom/typewritermc/engine/paper/entry/entries/GenericEntityActivityEntry;", "id", "", "name", "activity", "Lcom/typewritermc/core/entries/Ref;", "Lcom/typewritermc/engine/paper/entry/entries/EntityActivityEntry;", "onStart", "Lcom/typewritermc/engine/paper/entry/TriggerableEntry;", "onStop", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lcom/typewritermc/core/entries/Ref;Lcom/typewritermc/core/entries/Ref;Lcom/typewritermc/core/entries/Ref;)V", "getId", "()Ljava/lang/String;", "getName", "getActivity$annotations", "()V", "getActivity", "()Lcom/typewritermc/core/entries/Ref;", "getOnStart$annotations", "getOnStart", "getOnStop$annotations", "getOnStop", "create", "Lcom/typewritermc/engine/paper/entry/entity/EntityActivity;", "Lcom/typewritermc/engine/paper/entry/entity/ActivityContext;", "context", "currentLocation", "Lcom/typewritermc/engine/paper/entry/entity/PositionProperty;", "EntityExtension"})
@SourceDebugExtension(value={"SMAP\nTriggerActivityEntry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TriggerActivityEntry.kt\ncom/typewritermc/entity/entries/activity/TriggerActivityEntry\n+ 2 EntryReference.kt\ncom/typewritermc/core/entries/EntryReferenceKt\n*L\n1#1,68:1\n6#2:69\n6#2:70\n6#2:71\n*S KotlinDebug\n*F\n+ 1 TriggerActivityEntry.kt\ncom/typewritermc/entity/entries/activity/TriggerActivityEntry\n*L\n26#1:69\n28#1:70\n30#1:71\n*E\n"})
public final class TriggerActivityEntry
implements GenericEntityActivityEntry {
    @NotNull
    private final String id;
    @NotNull
    private final String name;
    @NotNull
    private final Ref<? extends EntityActivityEntry> activity;
    @NotNull
    private final Ref<TriggerableEntry> onStart;
    @NotNull
    private final Ref<TriggerableEntry> onStop;

    public TriggerActivityEntry(@NotNull String id, @NotNull String name, @NotNull Ref<? extends EntityActivityEntry> activity, @NotNull Ref<TriggerableEntry> onStart, @NotNull Ref<TriggerableEntry> onStop) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(activity, (String)"activity");
        Intrinsics.checkNotNullParameter(onStart, (String)"onStart");
        Intrinsics.checkNotNullParameter(onStop, (String)"onStop");
        this.id = id;
        this.name = name;
        this.activity = activity;
        this.onStart = onStart;
        this.onStop = onStop;
    }

    public /* synthetic */ TriggerActivityEntry(String string, String string2, Ref ref, Ref ref2, Ref ref3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        boolean $i$f$emptyRef;
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            string2 = "";
        }
        if ((n & 4) != 0) {
            $i$f$emptyRef = false;
            ref = new Ref("", Reflection.getOrCreateKotlinClass(EntityActivityEntry.class));
        }
        if ((n & 8) != 0) {
            $i$f$emptyRef = false;
            ref2 = new Ref("", Reflection.getOrCreateKotlinClass(TriggerableEntry.class));
        }
        if ((n & 0x10) != 0) {
            $i$f$emptyRef = false;
            ref3 = new Ref("", Reflection.getOrCreateKotlinClass(TriggerableEntry.class));
        }
        this(string, string2, (Ref<? extends EntityActivityEntry>)ref, (Ref<TriggerableEntry>)ref2, (Ref<TriggerableEntry>)ref3);
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public final Ref<? extends EntityActivityEntry> getActivity() {
        return this.activity;
    }

    @Help(text="The activity to use when this is active.")
    public static /* synthetic */ void getActivity$annotations() {
    }

    @NotNull
    public final Ref<TriggerableEntry> getOnStart() {
        return this.onStart;
    }

    @Help(text="The sequence to trigger when the activity starts.")
    public static /* synthetic */ void getOnStart$annotations() {
    }

    @NotNull
    public final Ref<TriggerableEntry> getOnStop() {
        return this.onStop;
    }

    @Help(text="The sequence to trigger when the activity stops.")
    public static /* synthetic */ void getOnStop$annotations() {
    }

    @NotNull
    public EntityActivity<ActivityContext> create(@NotNull ActivityContext context, @NotNull PositionProperty currentLocation) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)currentLocation, (String)"currentLocation");
        if (!this.activity.isSet()) {
            return IdleActivity.Companion.create(context, currentLocation);
        }
        return (EntityActivity)new TriggerActivity(this.activity, currentLocation, this.onStart, this.onStop);
    }

    @NotNull
    public EntityActivity<SharedActivityContext> create(@NotNull SharedActivityContext context, @NotNull PositionProperty currentLocation) {
        return GenericEntityActivityEntry.DefaultImpls.create((GenericEntityActivityEntry)this, (SharedActivityContext)context, (PositionProperty)currentLocation);
    }

    @NotNull
    public EntityActivity<IndividualActivityContext> create(@NotNull IndividualActivityContext context, @NotNull PositionProperty currentLocation) {
        return GenericEntityActivityEntry.DefaultImpls.create((GenericEntityActivityEntry)this, (IndividualActivityContext)context, (PositionProperty)currentLocation);
    }

    public TriggerActivityEntry() {
        this(null, null, null, null, null, 31, null);
    }
}

