/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.entity.entries.activity;

import com.typewritermc.core.entries.Ref;
import com.typewritermc.engine.paper.entry.entity.ActivityContext;
import com.typewritermc.engine.paper.entry.entity.PositionProperty;
import com.typewritermc.engine.paper.entry.entity.SingleChildActivity;
import com.typewritermc.engine.paper.entry.entries.EntityActivityEntry;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003\u0012\u0013\u0014B?\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\u0012\u000e\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0018\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00072\u0006\u0010\u0011\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/typewritermc/entity/entries/activity/TimedActivity;", "Lcom/typewritermc/engine/paper/entry/entity/SingleChildActivity;", "Lcom/typewritermc/engine/paper/entry/entity/ActivityContext;", "duration", "Ljava/time/Duration;", "cooldown", "activeActivity", "Lcom/typewritermc/core/entries/Ref;", "Lcom/typewritermc/engine/paper/entry/entries/EntityActivityEntry;", "cooldownActivity", "startLocation", "Lcom/typewritermc/engine/paper/entry/entity/PositionProperty;", "<init>", "(Ljava/time/Duration;Ljava/time/Duration;Lcom/typewritermc/core/entries/Ref;Lcom/typewritermc/core/entries/Ref;Lcom/typewritermc/engine/paper/entry/entity/PositionProperty;)V", "state", "Lcom/typewritermc/entity/entries/activity/TimedActivity$TimedActivityState;", "currentChild", "context", "TimedActivityState", "Active", "Cooldown", "EntityExtension"})
public final class TimedActivity
extends SingleChildActivity<ActivityContext> {
    @NotNull
    private final Duration duration;
    @NotNull
    private final Duration cooldown;
    @NotNull
    private final Ref<? extends EntityActivityEntry> activeActivity;
    @NotNull
    private final Ref<? extends EntityActivityEntry> cooldownActivity;
    @NotNull
    private TimedActivityState state;

    public TimedActivity(@NotNull Duration duration, @NotNull Duration cooldown, @NotNull Ref<? extends EntityActivityEntry> activeActivity, @NotNull Ref<? extends EntityActivityEntry> cooldownActivity, @NotNull PositionProperty startLocation) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        Intrinsics.checkNotNullParameter((Object)cooldown, (String)"cooldown");
        Intrinsics.checkNotNullParameter(activeActivity, (String)"activeActivity");
        Intrinsics.checkNotNullParameter(cooldownActivity, (String)"cooldownActivity");
        Intrinsics.checkNotNullParameter((Object)startLocation, (String)"startLocation");
        super(startLocation);
        this.duration = duration;
        this.cooldown = cooldown;
        this.activeActivity = activeActivity;
        this.cooldownActivity = cooldownActivity;
        this.state = new Active(System.currentTimeMillis());
    }

    @NotNull
    public Ref<? extends EntityActivityEntry> currentChild(@NotNull ActivityContext context) {
        TimedActivityState timedActivityState;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.state.getHasExpired()) {
            this.state = this.state.getNextState();
        }
        return (timedActivityState = this.state) instanceof Active ? this.activeActivity : (timedActivityState instanceof Cooldown ? this.cooldownActivity : this.cooldownActivity);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/typewritermc/entity/entries/activity/TimedActivity$Active;", "Lcom/typewritermc/entity/entries/activity/TimedActivity$TimedActivityState;", "startTime", "", "<init>", "(Lcom/typewritermc/entity/entries/activity/TimedActivity;J)V", "hasExpired", "", "getHasExpired", "()Z", "nextState", "getNextState", "()Lcom/typewritermc/entity/entries/activity/TimedActivity$TimedActivityState;", "EntityExtension"})
    public final class Active
    implements TimedActivityState {
        private final long startTime;

        public Active(long startTime) {
            this.startTime = startTime;
        }

        @Override
        public boolean getHasExpired() {
            return System.currentTimeMillis() - this.startTime > TimedActivity.this.duration.toMillis();
        }

        @Override
        @NotNull
        public TimedActivityState getNextState() {
            return new Cooldown(System.currentTimeMillis());
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/typewritermc/entity/entries/activity/TimedActivity$Cooldown;", "Lcom/typewritermc/entity/entries/activity/TimedActivity$TimedActivityState;", "startTime", "", "<init>", "(Lcom/typewritermc/entity/entries/activity/TimedActivity;J)V", "hasExpired", "", "getHasExpired", "()Z", "nextState", "getNextState", "()Lcom/typewritermc/entity/entries/activity/TimedActivity$TimedActivityState;", "EntityExtension"})
    public final class Cooldown
    implements TimedActivityState {
        private final long startTime;

        public Cooldown(long startTime) {
            this.startTime = startTime;
        }

        @Override
        public boolean getHasExpired() {
            return System.currentTimeMillis() - this.startTime > TimedActivity.this.cooldown.toMillis();
        }

        @Override
        @NotNull
        public TimedActivityState getNextState() {
            return new Active(System.currentTimeMillis());
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0000X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/typewritermc/entity/entries/activity/TimedActivity$TimedActivityState;", "", "hasExpired", "", "getHasExpired", "()Z", "nextState", "getNextState", "()Lcom/typewritermc/entity/entries/activity/TimedActivity$TimedActivityState;", "EntityExtension"})
    public static interface TimedActivityState {
        public boolean getHasExpired();

        @NotNull
        public TimedActivityState getNextState();
    }
}

