/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.entity.entries.activity;

import com.typewritermc.core.entries.Ref;
import com.typewritermc.core.utils.point.Position;
import com.typewritermc.engine.paper.entry.entity.ActivityContext;
import com.typewritermc.engine.paper.entry.entity.PositionProperty;
import com.typewritermc.engine.paper.entry.entity.PositionPropertyKt;
import com.typewritermc.engine.paper.entry.entity.SingleChildActivity;
import com.typewritermc.engine.paper.entry.entries.EntityActivityEntry;
import com.typewritermc.engine.paper.utils.ExtensionsKt;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0015B?\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b\u0012\u000e\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0018\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b2\u0006\u0010\u0014\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/typewritermc/entity/entries/activity/PlayerCloseByActivity;", "Lcom/typewritermc/engine/paper/entry/entity/SingleChildActivity;", "Lcom/typewritermc/engine/paper/entry/entity/ActivityContext;", "range", "", "maxIdleDuration", "Ljava/time/Duration;", "closeByActivity", "Lcom/typewritermc/core/entries/Ref;", "Lcom/typewritermc/engine/paper/entry/entries/EntityActivityEntry;", "idleActivity", "startLocation", "Lcom/typewritermc/engine/paper/entry/entity/PositionProperty;", "<init>", "(DLjava/time/Duration;Lcom/typewritermc/core/entries/Ref;Lcom/typewritermc/core/entries/Ref;Lcom/typewritermc/engine/paper/entry/entity/PositionProperty;)V", "trackers", "", "Ljava/util/UUID;", "Lcom/typewritermc/entity/entries/activity/PlayerCloseByActivity$PlayerLocationTracker;", "currentChild", "context", "PlayerLocationTracker", "EntityExtension"})
@SourceDebugExtension(value={"SMAP\nPlayerCloseByActivity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerCloseByActivity.kt\ncom/typewritermc/entity/entries/activity/PlayerCloseByActivity\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,106:1\n774#2:107\n865#2,2:108\n774#2:110\n865#2,2:111\n1863#2,2:113\n2632#2,3:118\n188#3,3:115\n*S KotlinDebug\n*F\n+ 1 PlayerCloseByActivity.kt\ncom/typewritermc/entity/entries/activity/PlayerCloseByActivity\n*L\n69#1:107\n69#1:108,2\n70#1:110\n70#1:111,2\n74#1:113,2\n72#1:118,3\n83#1:115,3\n*E\n"})
public final class PlayerCloseByActivity
extends SingleChildActivity<ActivityContext> {
    private final double range;
    @NotNull
    private final Duration maxIdleDuration;
    @NotNull
    private final Ref<? extends EntityActivityEntry> closeByActivity;
    @NotNull
    private final Ref<? extends EntityActivityEntry> idleActivity;
    @NotNull
    private Map<UUID, PlayerLocationTracker> trackers;

    public PlayerCloseByActivity(double range, @NotNull Duration maxIdleDuration, @NotNull Ref<? extends EntityActivityEntry> closeByActivity, @NotNull Ref<? extends EntityActivityEntry> idleActivity, @NotNull PositionProperty startLocation) {
        Intrinsics.checkNotNullParameter((Object)maxIdleDuration, (String)"maxIdleDuration");
        Intrinsics.checkNotNullParameter(closeByActivity, (String)"closeByActivity");
        Intrinsics.checkNotNullParameter(idleActivity, (String)"idleActivity");
        Intrinsics.checkNotNullParameter((Object)startLocation, (String)"startLocation");
        super(startLocation);
        this.range = range;
        this.maxIdleDuration = maxIdleDuration;
        this.closeByActivity = closeByActivity;
        this.idleActivity = idleActivity;
        this.trackers = new LinkedHashMap();
    }

    @NotNull
    public Ref<? extends EntityActivityEntry> currentChild(@NotNull ActivityContext context) {
        boolean bl;
        block6: {
            Player it;
            Object element$iv$iv;
            Iterable $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Iterable $this$filter$iv = context.getViewers();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Object object = $this$filterTo$iv$iv.iterator();
            while (object.hasNext()) {
                element$iv$iv = object.next();
                it = (Player)element$iv$iv;
                boolean bl2 = false;
                if (!ExtensionsKt.isLookable((Player)it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            object = $this$filterTo$iv$iv.iterator();
            while (object.hasNext()) {
                element$iv$iv = object.next();
                it = (Player)element$iv$iv;
                boolean bl3 = false;
                Location location = it.getLocation();
                Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getLocation(...)");
                Double d = PositionPropertyKt.toProperty((Location)location).distanceSqrt((Position)this.getCurrentPosition());
                if (!((d != null ? d : Double.MAX_VALUE) < this.range * this.range)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List closeByPlayers = (List)destination$iv$iv;
            CollectionsKt.removeAll((Iterable)this.trackers.keySet(), arg_0 -> PlayerCloseByActivity.currentChild$lambda$3(closeByPlayers, arg_0));
            Iterable $this$forEach$iv = closeByPlayers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Player player = (Player)element$iv;
                boolean bl4 = false;
                Location location = player.getLocation();
                Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getLocation(...)");
                this.trackers.computeIfAbsent(player.getUniqueId(), arg_0 -> PlayerCloseByActivity.currentChild$lambda$6$lambda$5(arg_0 -> PlayerCloseByActivity.currentChild$lambda$6$lambda$4(player, arg_0), arg_0)).update(PositionPropertyKt.toProperty((Location)location));
            }
            Map<UUID, PlayerLocationTracker> $this$any$iv = this.trackers;
            boolean $i$f$any = false;
            if ($this$any$iv.isEmpty()) {
                bl = false;
            } else {
                for (Map.Entry<UUID, PlayerLocationTracker> element$iv : $this$any$iv.entrySet()) {
                    object = element$iv;
                    boolean bl5 = false;
                    PlayerLocationTracker tracker = (PlayerLocationTracker)object.getValue();
                    if (!tracker.isActive(this.maxIdleDuration)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        boolean isActive = bl;
        return isActive ? this.closeByActivity : this.idleActivity;
    }

    private static final boolean currentChild$lambda$3(List $closeByPlayers, UUID uuid) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            Iterable $this$none$iv = $closeByPlayers;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    Player it = (Player)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getUniqueId(), (Object)uuid)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private static final PlayerLocationTracker currentChild$lambda$6$lambda$4(Player $player, UUID it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Location location = $player.getLocation();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getLocation(...)");
        return new PlayerLocationTracker(PositionPropertyKt.toProperty((Location)location), 0L, 2, null);
    }

    private static final PlayerLocationTracker currentChild$lambda$6$lambda$5(Function1 $tmp0, Object p0) {
        return (PlayerLocationTracker)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u0003J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lcom/typewritermc/entity/entries/activity/PlayerCloseByActivity$PlayerLocationTracker;", "", "location", "Lcom/typewritermc/engine/paper/entry/entity/PositionProperty;", "lastSeen", "", "<init>", "(Lcom/typewritermc/engine/paper/entry/entity/PositionProperty;J)V", "getLocation", "()Lcom/typewritermc/engine/paper/entry/entity/PositionProperty;", "setLocation", "(Lcom/typewritermc/engine/paper/entry/entity/PositionProperty;)V", "getLastSeen", "()J", "setLastSeen", "(J)V", "update", "", "isActive", "", "maxIdleDuration", "Ljava/time/Duration;", "EntityExtension"})
    private static final class PlayerLocationTracker {
        @NotNull
        private PositionProperty location;
        private long lastSeen;

        public PlayerLocationTracker(@NotNull PositionProperty location, long lastSeen) {
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            this.location = location;
            this.lastSeen = lastSeen;
        }

        public /* synthetic */ PlayerLocationTracker(PositionProperty positionProperty, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                l = System.currentTimeMillis();
            }
            this(positionProperty, l);
        }

        @NotNull
        public final PositionProperty getLocation() {
            return this.location;
        }

        public final void setLocation(@NotNull PositionProperty positionProperty) {
            Intrinsics.checkNotNullParameter((Object)positionProperty, (String)"<set-?>");
            this.location = positionProperty;
        }

        public final long getLastSeen() {
            return this.lastSeen;
        }

        public final void setLastSeen(long l) {
            this.lastSeen = l;
        }

        public final void update(@NotNull PositionProperty location) {
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            Double d = this.location.distanceSqrt((Position)location);
            double d2 = d != null ? d : Double.MAX_VALUE;
            if (d2 < 0.1) {
                return;
            }
            this.location = location;
            this.lastSeen = System.currentTimeMillis();
        }

        public final boolean isActive(@NotNull Duration maxIdleDuration) {
            Intrinsics.checkNotNullParameter((Object)maxIdleDuration, (String)"maxIdleDuration");
            if (maxIdleDuration.isZero()) {
                return true;
            }
            return System.currentTimeMillis() - this.lastSeen < maxIdleDuration.toMillis();
        }
    }
}

