/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axgraves.libs.axapi.libs.math3.ml.distance;

import com.artillexstudios.axgraves.libs.axapi.libs.math3.exception.DimensionMismatchException;
import com.artillexstudios.axgraves.libs.axapi.libs.math3.ml.distance.DistanceMeasure;
import com.artillexstudios.axgraves.libs.axapi.libs.math3.util.FastMath;
import com.artillexstudios.axgraves.libs.axapi.libs.math3.util.MathArrays;

public class EarthMoversDistance
implements DistanceMeasure {
    private static final long serialVersionUID = -5406732779747414922L;

    public double compute(double[] a, double[] b) throws DimensionMismatchException {
        MathArrays.checkEqualLength(a, b);
        double lastDistance = 0.0;
        double totalDistance = 0.0;
        for (int i = 0; i < a.length; ++i) {
            double currentDistance = a[i] + lastDistance - b[i];
            totalDistance += FastMath.abs(currentDistance);
            lastDistance = currentDistance;
        }
        return totalDistance;
    }
}

