/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axgraves.libs.axapi.libs.math3.fitting.leastsquares;

import com.artillexstudios.axgraves.libs.axapi.libs.math3.fitting.leastsquares.LeastSquaresProblem;
import com.artillexstudios.axgraves.libs.axapi.libs.math3.linear.ArrayRealVector;
import com.artillexstudios.axgraves.libs.axapi.libs.math3.linear.DecompositionSolver;
import com.artillexstudios.axgraves.libs.axapi.libs.math3.linear.QRDecomposition;
import com.artillexstudios.axgraves.libs.axapi.libs.math3.linear.RealMatrix;
import com.artillexstudios.axgraves.libs.axapi.libs.math3.linear.RealVector;
import com.artillexstudios.axgraves.libs.axapi.libs.math3.util.FastMath;

public abstract class AbstractEvaluation
implements LeastSquaresProblem.Evaluation {
    private final int observationSize;

    AbstractEvaluation(int observationSize) {
        this.observationSize = observationSize;
    }

    public RealMatrix getCovariances(double threshold) {
        RealMatrix j = this.getJacobian();
        RealMatrix jTj = j.transpose().multiply(j);
        DecompositionSolver solver = new QRDecomposition(jTj, threshold).getSolver();
        return solver.getInverse();
    }

    public RealVector getSigma(double covarianceSingularityThreshold) {
        RealMatrix cov = this.getCovariances(covarianceSingularityThreshold);
        int nC = cov.getColumnDimension();
        ArrayRealVector sig = new ArrayRealVector(nC);
        for (int i = 0; i < nC; ++i) {
            ((RealVector)sig).setEntry(i, FastMath.sqrt(cov.getEntry(i, i)));
        }
        return sig;
    }

    public double getRMS() {
        double cost = this.getCost();
        return FastMath.sqrt(cost * cost / (double)this.observationSize);
    }

    public double getCost() {
        ArrayRealVector r = new ArrayRealVector(this.getResiduals());
        return FastMath.sqrt(r.dotProduct(r));
    }
}

