/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axgraves.libs.axapi.libs.math3.analysis.interpolation;

import com.artillexstudios.axgraves.libs.axapi.libs.math3.analysis.interpolation.UnivariateInterpolator;
import com.artillexstudios.axgraves.libs.axapi.libs.math3.analysis.polynomials.PolynomialFunctionLagrangeForm;
import com.artillexstudios.axgraves.libs.axapi.libs.math3.analysis.polynomials.PolynomialFunctionNewtonForm;
import com.artillexstudios.axgraves.libs.axapi.libs.math3.exception.DimensionMismatchException;
import com.artillexstudios.axgraves.libs.axapi.libs.math3.exception.NonMonotonicSequenceException;
import com.artillexstudios.axgraves.libs.axapi.libs.math3.exception.NumberIsTooSmallException;
import java.io.Serializable;

public class DividedDifferenceInterpolator
implements UnivariateInterpolator,
Serializable {
    private static final long serialVersionUID = 107049519551235069L;

    public PolynomialFunctionNewtonForm interpolate(double[] x, double[] y) throws DimensionMismatchException, NumberIsTooSmallException, NonMonotonicSequenceException {
        PolynomialFunctionLagrangeForm.verifyInterpolationArray(x, y, true);
        double[] c = new double[x.length - 1];
        System.arraycopy(x, 0, c, 0, c.length);
        double[] a = DividedDifferenceInterpolator.computeDividedDifference(x, y);
        return new PolynomialFunctionNewtonForm(a, c);
    }

    protected static double[] computeDividedDifference(double[] x, double[] y) throws DimensionMismatchException, NumberIsTooSmallException, NonMonotonicSequenceException {
        PolynomialFunctionLagrangeForm.verifyInterpolationArray(x, y, true);
        double[] divdiff = (double[])y.clone();
        int n = x.length;
        double[] a = new double[n];
        a[0] = divdiff[0];
        for (int i = 1; i < n; ++i) {
            for (int j = 0; j < n - i; ++j) {
                double denominator = x[j + i] - x[j];
                divdiff[j] = (divdiff[j + 1] - divdiff[j]) / denominator;
            }
            a[i] = divdiff[0];
        }
        return a;
    }
}

