/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.biome.pipeline.v2.pipeline;

import com.dfsek.terra.addons.biome.pipeline.v2.api.BiomeChunk;
import com.dfsek.terra.addons.biome.pipeline.v2.api.Expander;
import com.dfsek.terra.addons.biome.pipeline.v2.api.Pipeline;
import com.dfsek.terra.addons.biome.pipeline.v2.api.SeededVector;
import com.dfsek.terra.addons.biome.pipeline.v2.api.Source;
import com.dfsek.terra.addons.biome.pipeline.v2.api.Stage;
import com.dfsek.terra.addons.biome.pipeline.v2.pipeline.BiomeChunkImpl;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineImpl
implements Pipeline {
    private static final Logger logger = LoggerFactory.getLogger(PipelineImpl.class);
    private final Source source;
    private final List<Stage> stages;
    private final int chunkSize;
    private final int expanderCount;
    private final int arraySize;
    private final int chunkOriginArrayIndex;
    private final int resolution;

    public PipelineImpl(Source source, List<Stage> stages, int resolution, int idealChunkArraySize) {
        int chunkOriginArrayIndex;
        int arraySize;
        int chunkSize;
        this.source = source;
        this.stages = stages;
        this.resolution = resolution;
        this.expanderCount = (int)stages.stream().filter(s -> s instanceof Expander).count();
        int initialSize = 1;
        while ((chunkSize = BiomeChunkImpl.calculateChunkSize(arraySize = BiomeChunkImpl.initialSizeToArraySize(this.expanderCount, initialSize), chunkOriginArrayIndex = BiomeChunkImpl.calculateChunkOriginArrayIndex(this.expanderCount, stages), this.expanderCount)) <= 1 || arraySize < idealChunkArraySize) {
            ++initialSize;
        }
        this.arraySize = arraySize;
        this.chunkOriginArrayIndex = chunkOriginArrayIndex;
        this.chunkSize = chunkSize;
        logger.debug("Initialized a new biome pipeline:");
        logger.debug("Array size: {} (Target: {})", (Object)arraySize, (Object)idealChunkArraySize);
        logger.debug("Internal array origin: {}", (Object)chunkOriginArrayIndex);
        logger.debug("Chunk size: {}", (Object)chunkSize);
    }

    @Override
    public BiomeChunk generateChunk(SeededVector worldCoordinates) {
        return new BiomeChunkImpl(worldCoordinates, this);
    }

    @Override
    public int getChunkSize() {
        return this.chunkSize;
    }

    @Override
    public Source getSource() {
        return this.source;
    }

    @Override
    public List<Stage> getStages() {
        return this.stages;
    }

    protected int getExpanderCount() {
        return this.expanderCount;
    }

    protected int getArraySize() {
        return this.arraySize;
    }

    protected int getChunkOriginArrayIndex() {
        return this.chunkOriginArrayIndex;
    }

    protected int getResolution() {
        return this.resolution;
    }
}

