/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.biome.pipeline.v2.pipeline;

import com.dfsek.terra.addons.biome.pipeline.lib.jafama.FastMath;
import com.dfsek.terra.addons.biome.pipeline.v2.api.BiomeChunk;
import com.dfsek.terra.addons.biome.pipeline.v2.api.Expander;
import com.dfsek.terra.addons.biome.pipeline.v2.api.SeededVector;
import com.dfsek.terra.addons.biome.pipeline.v2.api.Stage;
import com.dfsek.terra.addons.biome.pipeline.v2.api.biome.PipelineBiome;
import com.dfsek.terra.addons.biome.pipeline.v2.pipeline.PipelineImpl;
import java.util.List;

public class BiomeChunkImpl
implements BiomeChunk {
    private PipelineBiome[][] biomes;
    private final SeededVector worldOrigin;
    private final int chunkOriginArrayIndex;
    private final int worldCoordinateScale;

    public BiomeChunkImpl(SeededVector worldOrigin, PipelineImpl pipeline) {
        this.worldOrigin = worldOrigin;
        this.chunkOriginArrayIndex = pipeline.getChunkOriginArrayIndex();
        this.worldCoordinateScale = pipeline.getResolution();
        int size = pipeline.getArraySize();
        int expanderCount = pipeline.getExpanderCount();
        int expansionsApplied = 0;
        this.biomes = new PipelineBiome[size][size];
        PipelineBiome[][] lookupArray = new PipelineBiome[size][size];
        int gridOrigin = 0;
        int gridInterval = BiomeChunkImpl.calculateGridInterval(expanderCount, expansionsApplied);
        int gridSize = size / gridInterval;
        gridSize += expanderCount > 0 ? 1 : 0;
        for (int gridX = 0; gridX < gridSize; ++gridX) {
            for (int gridZ = 0; gridZ < gridSize; ++gridZ) {
                int xIndex = gridOrigin + gridX * gridInterval;
                int zIndex = gridOrigin + gridZ * gridInterval;
                this.biomes[xIndex][zIndex] = pipeline.getSource().get(worldOrigin.seed(), this.xIndexToWorldCoordinate(xIndex), this.zIndexToWorldCoordinate(zIndex));
            }
        }
        for (Stage stage : pipeline.getStages()) {
            int stageReadDistance;
            if (stage instanceof Expander) {
                gridInterval = BiomeChunkImpl.calculateGridInterval(expanderCount, ++expansionsApplied);
                gridSize = BiomeChunkImpl.expandSize(gridSize);
            }
            if ((stageReadDistance = stage.maxRelativeReadDistance()) > 0) {
                gridSize = BiomeChunkImpl.contractBordersFromSize(gridSize, stageReadDistance);
                gridOrigin += stageReadDistance * gridInterval;
            }
            PipelineBiome[][] tempArray = this.biomes;
            this.biomes = lookupArray;
            lookupArray = tempArray;
            for (int gridZ = 0; gridZ < gridSize; ++gridZ) {
                for (int gridX = 0; gridX < gridSize; ++gridX) {
                    int xIndex = gridOrigin + gridX * gridInterval;
                    int zIndex = gridOrigin + gridZ * gridInterval;
                    this.biomes[xIndex][zIndex] = stage.apply(new ViewPoint(this, gridInterval, gridX, gridZ, xIndex, zIndex, lookupArray));
                }
            }
        }
    }

    @Override
    public PipelineBiome get(int xInChunk, int zInChunk) {
        int xIndex = xInChunk + this.chunkOriginArrayIndex;
        int zIndex = zInChunk + this.chunkOriginArrayIndex;
        return this.biomes[xIndex][zIndex];
    }

    private int xIndexToWorldCoordinate(int xIndex) {
        return (this.worldOrigin.x() + xIndex - this.chunkOriginArrayIndex) * this.worldCoordinateScale;
    }

    private int zIndexToWorldCoordinate(int zIndex) {
        return (this.worldOrigin.z() + zIndex - this.chunkOriginArrayIndex) * this.worldCoordinateScale;
    }

    protected static int initialSizeToArraySize(int expanderCount, int initialSize) {
        int size = initialSize;
        for (int i = 0; i < expanderCount; ++i) {
            size = BiomeChunkImpl.expandSize(size);
        }
        return size;
    }

    protected static int calculateChunkOriginArrayIndex(int totalExpanderCount, List<Stage> stages) {
        int finalGridOrigin = BiomeChunkImpl.calculateFinalGridOrigin(totalExpanderCount, stages);
        int initialGridInterval = BiomeChunkImpl.calculateGridInterval(totalExpanderCount, 0);
        return FastMath.ceilToInt((double)finalGridOrigin / (double)initialGridInterval) * initialGridInterval;
    }

    private static int calculateFinalGridOrigin(int totalExpanderCount, List<Stage> stages) {
        int gridOrigin = 0;
        int expansionsApplied = 0;
        int gridInterval = BiomeChunkImpl.calculateGridInterval(totalExpanderCount, expansionsApplied);
        for (Stage stage : stages) {
            if (stage instanceof Expander) {
                gridInterval = BiomeChunkImpl.calculateGridInterval(totalExpanderCount, ++expansionsApplied);
            }
            gridOrigin += stage.maxRelativeReadDistance() * gridInterval;
        }
        return gridOrigin;
    }

    protected static int calculateChunkSize(int arraySize, int chunkOriginArrayIndex, int totalExpanderCount) {
        return BiomeChunkImpl.contractBordersFromSize(arraySize, chunkOriginArrayIndex) - (totalExpanderCount > 0 ? 1 : 0);
    }

    private static int expandSize(int size) {
        return size * 2 - 1;
    }

    private static int contractBordersFromSize(int size, int border) {
        return size - border * 2;
    }

    private static int calculateGridInterval(int totalExpansions, int expansionsApplied) {
        return 1 << totalExpansions - expansionsApplied;
    }

    private SeededVector getOrigin() {
        return this.worldOrigin;
    }

    public static class ViewPoint {
        private final BiomeChunkImpl chunk;
        private final PipelineBiome biome;
        private final int gridInterval;
        private final int gridX;
        private final int gridZ;
        private final int xIndex;
        private final int zIndex;
        private final PipelineBiome[][] lookupArray;

        private ViewPoint(BiomeChunkImpl chunk, int gridInterval, int gridX, int gridZ, int xIndex, int zIndex, PipelineBiome[][] lookupArray) {
            this.chunk = chunk;
            this.gridInterval = gridInterval;
            this.gridX = gridX;
            this.gridZ = gridZ;
            this.xIndex = xIndex;
            this.zIndex = zIndex;
            this.lookupArray = lookupArray;
            this.biome = lookupArray[xIndex][zIndex];
        }

        public PipelineBiome getRelativeBiome(int x, int z) {
            int lookupXIndex = this.xIndex + x * this.gridInterval;
            int lookupZIndex = this.zIndex + z * this.gridInterval;
            return this.lookupArray[lookupXIndex][lookupZIndex];
        }

        public PipelineBiome getBiome() {
            return this.biome;
        }

        public int gridX() {
            return this.gridX;
        }

        public int gridZ() {
            return this.gridZ;
        }

        public int worldX() {
            return this.chunk.xIndexToWorldCoordinate(this.xIndex);
        }

        public int worldZ() {
            return this.chunk.zIndexToWorldCoordinate(this.zIndex);
        }

        public long worldSeed() {
            return this.chunk.getOrigin().seed();
        }
    }
}

