/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.biome.pipeline.v2.config;

import com.dfsek.tectonic.api.config.template.annotations.Default;
import com.dfsek.tectonic.api.config.template.annotations.Description;
import com.dfsek.tectonic.api.config.template.annotations.Value;
import com.dfsek.tectonic.api.config.template.object.ObjectTemplate;
import com.dfsek.terra.addons.biome.pipeline.v2.PipelineBiomeProvider;
import com.dfsek.terra.addons.biome.pipeline.v2.api.Source;
import com.dfsek.terra.addons.biome.pipeline.v2.api.Stage;
import com.dfsek.terra.addons.biome.pipeline.v2.pipeline.PipelineImpl;
import com.dfsek.terra.api.config.meta.Meta;
import com.dfsek.terra.api.noise.NoiseSampler;
import com.dfsek.terra.api.world.biome.generation.BiomeProvider;
import java.util.List;

public class BiomePipelineTemplate
implements ObjectTemplate<BiomeProvider> {
    @Value(value="resolution")
    @Default
    @Description(value="The resolution at which to sample biomes.\n\nLarger values are quadratically faster, but produce lower quality results.\nFor example, a value of 3 would sample every 3 blocks.")
    protected @Meta int resolution = 1;
    @Value(value="pipeline.source")
    @Description(value="The Biome Source to use for initial population of biomes.")
    private @Meta Source source;
    @Value(value="pipeline.stages")
    @Description(value="A list of pipeline stages to apply to the result of #source")
    private @Meta List<@Meta Stage> stages;
    @Value(value="blend.sampler")
    @Default
    @Description(value="A sampler to use for blending the edges of biomes via domain warping.")
    protected @Meta NoiseSampler blendSampler = NoiseSampler.zero();
    @Value(value="blend.amplitude")
    @Default
    @Description(value="The amplitude at which to perform blending.")
    protected @Meta double blendAmplitude = 0.0;

    public BiomeProvider get() {
        return new PipelineBiomeProvider(new PipelineImpl(this.source, this.stages, this.resolution, 500), this.resolution, this.blendSampler, this.blendAmplitude);
    }
}

