/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.biome.pipeline.v2;

import com.dfsek.terra.addons.biome.pipeline.lib.jafama.FastMath;
import com.dfsek.terra.addons.biome.pipeline.v2.BiomePipelineColumn;
import com.dfsek.terra.addons.biome.pipeline.v2.api.BiomeChunk;
import com.dfsek.terra.addons.biome.pipeline.v2.api.Pipeline;
import com.dfsek.terra.addons.biome.pipeline.v2.api.SeededVector;
import com.dfsek.terra.addons.biome.pipeline.v2.api.Stage;
import com.dfsek.terra.addons.biome.pipeline.v2.api.biome.PipelineBiome;
import com.dfsek.terra.api.noise.NoiseSampler;
import com.dfsek.terra.api.registry.key.StringIdentifiable;
import com.dfsek.terra.api.util.Column;
import com.dfsek.terra.api.world.biome.Biome;
import com.dfsek.terra.api.world.biome.generation.BiomeProvider;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.StreamSupport;

public class PipelineBiomeProvider
implements BiomeProvider {
    private final LoadingCache<SeededVector, BiomeChunk> biomeChunkCache;
    private final int chunkSize;
    private final int resolution;
    private final NoiseSampler mutator;
    private final double noiseAmp;
    private final Set<Biome> biomes;

    public PipelineBiomeProvider(Pipeline pipeline, int resolution, NoiseSampler mutator, double noiseAmp) {
        this.resolution = resolution;
        this.mutator = mutator;
        this.noiseAmp = noiseAmp;
        this.chunkSize = pipeline.getChunkSize();
        this.biomeChunkCache = Caffeine.newBuilder().maximumSize(1024L).build(pipeline::generateChunk);
        HashSet<PipelineBiome> biomeSet = new HashSet<PipelineBiome>();
        pipeline.getSource().getBiomes().forEach(biomeSet::add);
        Iterable<PipelineBiome> result = biomeSet;
        for (Stage stage : pipeline.getStages()) {
            result = stage.getBiomes(result);
        }
        this.biomes = new HashSet<Biome>();
        HashSet<PipelineBiome> finalResult = result;
        result.forEach(pipelineBiome -> {
            if (pipelineBiome.isPlaceholder()) {
                StringBuilder biomeList = new StringBuilder("\n");
                StreamSupport.stream(finalResult.spliterator(), false).sorted(Comparator.comparing(StringIdentifiable::getID)).forEach(delegate -> biomeList.append("    - ").append(delegate.getID()).append(':').append(delegate.getClass().getCanonicalName()).append('\n'));
                throw new IllegalArgumentException("Biome Pipeline leaks placeholder biome \"" + pipelineBiome.getID() + "\". Ensure there is a stage to guarantee replacement of the placeholder biome. Biomes: " + biomeList);
            }
            this.biomes.add(pipelineBiome.getBiome());
        });
    }

    public Biome getBiome(int x, int y, int z, long seed) {
        return this.getBiome(x, z, seed);
    }

    public Biome getBiome(int x, int z, long seed) {
        x = (int)((double)x + this.mutator.noise(seed + 1L, x, z) * this.noiseAmp);
        z = (int)((double)z + this.mutator.noise(seed + 2L, x, z) * this.noiseAmp);
        int chunkX = FastMath.floorDiv(x /= this.resolution, this.chunkSize);
        int chunkZ = FastMath.floorDiv(z /= this.resolution, this.chunkSize);
        int chunkWorldX = chunkX * this.chunkSize;
        int chunkWorldZ = chunkZ * this.chunkSize;
        int xInChunk = x - chunkWorldX;
        int zInChunk = z - chunkWorldZ;
        return ((BiomeChunk)this.biomeChunkCache.get((Object)new SeededVector(seed, chunkWorldX, chunkWorldZ))).get(xInChunk, zInChunk).getBiome();
    }

    public Iterable<Biome> getBiomes() {
        return this.biomes;
    }

    public Optional<Biome> getBaseBiome(int x, int z, long seed) {
        return Optional.of(this.getBiome(x, z, seed));
    }

    public Column<Biome> getColumn(int x, int z, long seed, int min, int max) {
        return new BiomePipelineColumn(this, min, max, x, z, seed);
    }

    public int resolution() {
        return this.resolution;
    }
}

