/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.biome.pipeline.v2;

import com.dfsek.terra.api.util.Column;
import com.dfsek.terra.api.util.function.IntIntObjConsumer;
import com.dfsek.terra.api.util.function.IntObjConsumer;
import com.dfsek.terra.api.world.biome.Biome;
import com.dfsek.terra.api.world.biome.generation.BiomeProvider;
import java.util.function.Consumer;

public class BiomePipelineColumn
implements Column<Biome> {
    private final int min;
    private final int max;
    private final int x;
    private final int z;
    private final Biome biome;

    protected BiomePipelineColumn(BiomeProvider biomeProvider, int min, int max, int x, int z, long seed) {
        this.min = min;
        this.max = max;
        this.x = x;
        this.z = z;
        this.biome = biomeProvider.getBiome(x, 0, z, seed);
    }

    public int getMinY() {
        return this.min;
    }

    public int getMaxY() {
        return this.max;
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public Biome get(int y) {
        return this.biome;
    }

    public void forRanges(int resolution, IntIntObjConsumer<Biome> consumer) {
        consumer.accept(this.min, this.max, (Object)this.biome);
    }

    public void forEach(Consumer<Biome> consumer) {
        for (int y = this.min; y < this.max; ++y) {
            consumer.accept(this.biome);
        }
    }

    public void forEach(IntObjConsumer<Biome> consumer) {
        for (int y = this.min; y < this.max; ++y) {
            consumer.accept(y, (Object)this.biome);
        }
    }
}

