/*
 * Decompiled with CFR 0.152.
 */
package com.github.retrooper.packetevents.util.easing;

import com.github.retrooper.packetevents.util.MathUtil;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class EasingFunctions {
    private EasingFunctions() {
    }

    public static float constant(float ignoredX) {
        return 0.0f;
    }

    public static float linear(float x) {
        return x;
    }

    public static float inBack(float x) {
        float c1 = 1.70158f;
        float c3 = c1 + 1.0f;
        return x * x * (c3 * x - c1);
    }

    public static float inBounce(float x) {
        return 1.0f - EasingFunctions.outBounce(1.0f - x);
    }

    public static float inCubic(float x) {
        return x * x * x;
    }

    public static float inElastic(float x) {
        if (x == 0.0f) {
            return 0.0f;
        }
        if (x == 1.0f) {
            return 1.0f;
        }
        float c4 = 2.0943952f;
        return (float)(-Math.pow(2.0, 10.0 * (double)x - 10.0) * Math.sin(((double)x * 10.0 - 10.75) * (double)c4));
    }

    public static float inExpo(float x) {
        return x == 0.0f ? 0.0f : (float)Math.pow(2.0, 10.0 * (double)x - 10.0);
    }

    public static float inQuart(float x) {
        return x * x * (x * x);
    }

    public static float inQuint(float x) {
        return x * x * (x * x) * x;
    }

    public static float inSine(float x) {
        return 1.0f - (float)Math.cos(x * 1.5707964f);
    }

    public static float inOutBounce(float x) {
        return x < 0.5f ? (1.0f - EasingFunctions.outBounce(1.0f - 2.0f * x)) / 2.0f : (1.0f + EasingFunctions.outBounce(2.0f * x - 1.0f)) / 2.0f;
    }

    public static float inOutCirc(float x) {
        return x < 0.5f ? (float)((1.0 - Math.sqrt(1.0 - Math.pow(2.0 * (double)x, 2.0))) / 2.0) : (float)((Math.sqrt(1.0 - Math.pow(-2.0 * (double)x + 2.0, 2.0)) + 1.0) / 2.0);
    }

    public static float inOutCubic(float x) {
        return x < 0.5f ? 4.0f * (x * x * x) : (float)(1.0 - Math.pow(-2.0 * (double)x + 2.0, 3.0) / 2.0);
    }

    public static float inOutQuad(float x) {
        return x < 0.5f ? 2.0f * (x * x) : (float)(1.0 - Math.pow(-2.0 * (double)x + 2.0, 2.0) / 2.0);
    }

    public static float inOutQuart(float x) {
        return x < 0.5f ? 8.0f * (x * x * (x * x)) : (float)(1.0 - Math.pow(-2.0 * (double)x + 2.0, 4.0) / 2.0);
    }

    public static float inOutQuint(float x) {
        return (double)x < 0.5 ? 16.0f * x * x * x * x * x : (float)(1.0 - Math.pow(-2.0 * (double)x + 2.0, 5.0) / 2.0);
    }

    public static float outBounce(float x) {
        float n1 = 7.5625f;
        float d1 = 2.75f;
        if (x < 1.0f / d1) {
            return n1 * (x * x);
        }
        if (x < 2.0f / d1) {
            return n1 * MathUtil.square(x - 1.5f / d1) + 0.75f;
        }
        if ((double)x < (double)(2.5f / d1)) {
            return n1 * MathUtil.square(x - 2.25f / d1) + 0.9375f;
        }
        return n1 * MathUtil.square(x - 2.625f / d1) + 0.984375f;
    }

    public static float outElastic(float x) {
        float c4 = 2.0943952f;
        if (x == 0.0f) {
            return 0.0f;
        }
        if (x == 1.0f) {
            return 1.0f;
        }
        return (float)(Math.pow(2.0, -10.0 * (double)x) * Math.sin(((double)x * 10.0 - 0.75) * (double)c4) + 1.0);
    }

    public static float outExpo(float x) {
        return x == 1.0f ? 1.0f : 1.0f - (float)Math.pow(2.0, -10.0 * (double)x);
    }

    public static float outQuad(float x) {
        return 1.0f - MathUtil.square(1.0f - x);
    }

    public static float outQuint(float x) {
        return 1.0f - (float)Math.pow(1.0 - (double)x, 5.0);
    }

    public static float outSine(float x) {
        return (float)Math.sin(x * 1.5707964f);
    }

    public static float inOutSine(float x) {
        return -((float)Math.cos((float)Math.PI * x) - 1.0f) / 2.0f;
    }

    public static float outBack(float x) {
        float c1 = 1.70158f;
        float c3 = 2.70158f;
        return 1.0f + c3 * MathUtil.cube(x - 1.0f) + c1 * MathUtil.square(x - 1.0f);
    }

    public static float outQuart(float x) {
        return 1.0f - MathUtil.square(MathUtil.square(1.0f - x));
    }

    public static float outCubic(float x) {
        return 1.0f - MathUtil.cube(1.0f - x);
    }

    public static float inOutExpo(float x) {
        if (x == 0.0f) {
            return 0.0f;
        }
        if (x == 1.0f) {
            return 1.0f;
        }
        return x < 0.5f ? (float)(Math.pow(2.0, 20.0 * (double)x - 10.0) / 2.0) : (float)((2.0 - Math.pow(2.0, -20.0 * (double)x + 10.0)) / 2.0);
    }

    public static float inQuad(float x) {
        return x * x;
    }

    public static float outCirc(float x) {
        return (float)Math.sqrt(1.0f - MathUtil.square(x - 1.0f));
    }

    public static float inOutElastic(float x) {
        float c5 = 1.3962635f;
        if (x == 0.0f) {
            return 0.0f;
        }
        if (x == 1.0f) {
            return 1.0f;
        }
        double sin = Math.sin((20.0 * (double)x - 11.125) * (double)c5);
        return x < 0.5f ? (float)(-(Math.pow(2.0, 20.0 * (double)x - 10.0) * sin) / 2.0) : (float)(Math.pow(2.0, -20.0 * (double)x + 10.0) * sin / 2.0 + 1.0);
    }

    public static float inCirc(float x) {
        return (float)(-Math.sqrt(1.0f - x * x)) + 1.0f;
    }

    public static float inOutBack(float x) {
        float c1 = 1.70158f;
        float c2 = c1 * 1.525f;
        if (x < 0.5f) {
            return 4.0f * x * x * (2.0f * (c2 + 1.0f) * x - c2) / 2.0f;
        }
        float dt = 2.0f * x - 2.0f;
        return (dt * dt * ((c2 + 1.0f) * dt + c2) + 2.0f) / 2.0f;
    }
}

