/*
 * Decompiled with CFR 0.152.
 */
package com.github.retrooper.packetevents.util.adventure;

import com.github.retrooper.packetevents.manager.server.ServerVersion;
import com.github.retrooper.packetevents.netty.buffer.ByteBufHelper;
import com.github.retrooper.packetevents.netty.buffer.ByteBufInputStream;
import com.github.retrooper.packetevents.netty.buffer.ByteBufOutputStream;
import com.github.retrooper.packetevents.netty.buffer.UnpooledByteBufAllocationHelper;
import com.github.retrooper.packetevents.protocol.nbt.NBT;
import com.github.retrooper.packetevents.protocol.nbt.codec.NBTCodec;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.List;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.BinaryTagType;
import net.kyori.adventure.nbt.BinaryTagTypes;
import net.kyori.adventure.nbt.EndBinaryTag;
import net.kyori.adventure.nbt.TagStringIO;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class AdventureNbtUtil {
    private static final BinaryTagType<?>[] NBT_TAG_TYPES = AdventureNbtUtil.buildNbtTagTypes();

    private AdventureNbtUtil() {
    }

    private static BinaryTagType<?>[] buildNbtTagTypes() {
        List types;
        BinaryTagTypes.BYTE.id();
        try {
            Field typesField = BinaryTagType.class.getDeclaredField("TYPES");
            typesField.setAccessible(true);
            types = (List)typesField.get(null);
        }
        catch (ReflectiveOperationException exception) {
            throw new RuntimeException("Error while accessing registered binary tag types", exception);
        }
        BinaryTagType[] nbtTagTypes = new BinaryTagType[types.size()];
        for (int i = 0; i < nbtTagTypes.length; ++i) {
            BinaryTagType type = (BinaryTagType)types.get(i);
            if (type.id() != i) {
                throw new IllegalStateException("Registered nbt tag types are wrong: " + type.id() + " != " + i);
            }
            nbtTagTypes[i] = type;
        }
        return nbtTagTypes;
    }

    public static BinaryTag readAdventureTag(Object buf) {
        byte tagTypeId = ByteBufHelper.readByte(buf);
        if (tagTypeId == BinaryTagTypes.END.id()) {
            return EndBinaryTag.endBinaryTag();
        }
        BinaryTagType<?> tagType = NBT_TAG_TYPES[tagTypeId];
        try {
            return tagType.read(new ByteBufInputStream(buf));
        }
        catch (IOException exception) {
            throw new RuntimeException("Error while reading adventure nbt tag from buf: " + buf, exception);
        }
    }

    public static void writeAdventureTag(Object buf, BinaryTag tag) {
        BinaryTagType<? extends BinaryTag> tagType = tag.type();
        ByteBufHelper.writeByte(buf, tagType.id());
        if (tagType.id() != BinaryTagTypes.END.id()) {
            try {
                tagType.write(tag, new ByteBufOutputStream(buf));
            }
            catch (IOException exception) {
                throw new RuntimeException("Error while writing adventure nbt tag to buf: " + tag, exception);
            }
        }
    }

    public static NBT fromAdventure(BinaryTag tag) {
        Object buf = UnpooledByteBufAllocationHelper.buffer();
        try {
            AdventureNbtUtil.writeAdventureTag(buf, tag);
            NBT nBT = NBTCodec.readNBTFromBuffer(buf, ServerVersion.getLatest());
            return nBT;
        }
        finally {
            ByteBufHelper.release(buf);
        }
    }

    public static BinaryTag toAdventure(NBT tag) {
        Object buf = UnpooledByteBufAllocationHelper.buffer();
        try {
            NBTCodec.writeNBTToBuffer(buf, ServerVersion.getLatest(), tag);
            BinaryTag binaryTag = AdventureNbtUtil.readAdventureTag(buf);
            return binaryTag;
        }
        finally {
            ByteBufHelper.release(buf);
        }
    }

    public static NBT fromString(String string) {
        BinaryTag advTag;
        try {
            advTag = TagStringIO.tagStringIO().asTag(string);
        }
        catch (IOException exception) {
            throw new RuntimeException("Error while decoding nbt from string: " + string, exception);
        }
        return AdventureNbtUtil.fromAdventure(advTag);
    }

    public static String toString(NBT tag) {
        BinaryTag advTag = AdventureNbtUtil.toAdventure(tag);
        try {
            return TagStringIO.tagStringIO().asString(advTag);
        }
        catch (IOException exception) {
            throw new RuntimeException("Error while encoding nbt to string: " + advTag, exception);
        }
    }
}

