/*
 * Decompiled with CFR 0.152.
 */
package com.github.retrooper.packetevents.util.adventure;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.protocol.component.builtin.item.ItemProfile;
import com.github.retrooper.packetevents.protocol.dialog.Dialog;
import com.github.retrooper.packetevents.protocol.nbt.NBT;
import com.github.retrooper.packetevents.protocol.nbt.NBTByte;
import com.github.retrooper.packetevents.protocol.nbt.NBTByteArray;
import com.github.retrooper.packetevents.protocol.nbt.NBTCompound;
import com.github.retrooper.packetevents.protocol.nbt.NBTDouble;
import com.github.retrooper.packetevents.protocol.nbt.NBTEnd;
import com.github.retrooper.packetevents.protocol.nbt.NBTFloat;
import com.github.retrooper.packetevents.protocol.nbt.NBTInt;
import com.github.retrooper.packetevents.protocol.nbt.NBTIntArray;
import com.github.retrooper.packetevents.protocol.nbt.NBTList;
import com.github.retrooper.packetevents.protocol.nbt.NBTLong;
import com.github.retrooper.packetevents.protocol.nbt.NBTLongArray;
import com.github.retrooper.packetevents.protocol.nbt.NBTNumber;
import com.github.retrooper.packetevents.protocol.nbt.NBTShort;
import com.github.retrooper.packetevents.protocol.nbt.NBTString;
import com.github.retrooper.packetevents.protocol.nbt.NBTType;
import com.github.retrooper.packetevents.protocol.player.ClientVersion;
import com.github.retrooper.packetevents.util.UniqueIdUtil;
import com.github.retrooper.packetevents.util.adventure.AdventureIndexUtil;
import com.github.retrooper.packetevents.util.adventure.AdventureNbtUtil;
import com.github.retrooper.packetevents.util.adventure.NbtTagHolder;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import io.github.retrooper.packetevents.adventure.serializer.ComponentSerializer;
import io.github.retrooper.packetevents.adventure.serializer.gson.BackwardCompatUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.Keyed;
import net.kyori.adventure.nbt.api.BinaryTagHolder;
import net.kyori.adventure.text.BlockNBTComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.EntityNBTComponent;
import net.kyori.adventure.text.KeybindComponent;
import net.kyori.adventure.text.NBTComponent;
import net.kyori.adventure.text.ObjectComponent;
import net.kyori.adventure.text.ScoreComponent;
import net.kyori.adventure.text.SelectorComponent;
import net.kyori.adventure.text.StorageNBTComponent;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.TranslationArgument;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.DataComponentValue;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.ShadowColor;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.object.ObjectContents;
import net.kyori.adventure.text.object.PlayerHeadObjectContents;
import net.kyori.adventure.text.object.SpriteObjectContents;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdventureNBTSerializer
implements ComponentSerializer<Component, Component, NBT> {
    private final ClientVersion version;
    private final boolean downsampleColor;

    public AdventureNBTSerializer(ClientVersion version, boolean downsampleColor) {
        this.version = version;
        this.downsampleColor = downsampleColor;
    }

    @Deprecated
    public AdventureNBTSerializer(boolean downsampleColor) {
        this(PacketEvents.getAPI().getServerManager().getVersion().toClientVersion(), downsampleColor);
    }

    @Override
    @Deprecated
    @Contract(value="!null -> !null")
    @Nullable
    public Component deserializeOrNull(@Nullable NBT input) {
        return this.deserializeOrNull(input, PacketWrapper.createDummyWrapper(this.version));
    }

    @Contract(value="!null, _ -> !null")
    @Nullable
    public Component deserializeOrNull(@Nullable NBT input, PacketWrapper<?> wrapper) {
        return input != null ? this.deserialize(input, wrapper) : null;
    }

    @Override
    @Deprecated
    @Contract(value="_, !null -> !null")
    @Nullable
    public Component deserializeOr(@Nullable NBT input, @Nullable Component fallback) {
        return this.deserializeOr(input, fallback, PacketWrapper.createDummyWrapper(this.version));
    }

    @Contract(value="_, !null, _ -> !null")
    @Nullable
    public Component deserializeOr(@Nullable NBT input, @Nullable Component fallback, PacketWrapper<?> wrapper) {
        return input != null ? this.deserialize(input, wrapper) : fallback;
    }

    @Override
    @Deprecated
    @Contract(value="!null -> !null")
    @Nullable
    public NBT serializeOrNull(@Nullable Component component) {
        return this.serializeOrNull(component, PacketWrapper.createDummyWrapper(this.version));
    }

    @Contract(value="!null, _ -> !null")
    @Nullable
    public NBT serializeOrNull(@Nullable Component component, PacketWrapper<?> wrapper) {
        return component != null ? this.serialize(component, wrapper) : null;
    }

    @Override
    @Deprecated
    @Contract(value="_, !null -> !null")
    @Nullable
    public NBT serializeOr(@Nullable Component component, @Nullable NBT fallback) {
        return this.serializeOr(component, fallback, PacketWrapper.createDummyWrapper(this.version));
    }

    @Contract(value="_, !null, _ -> !null")
    @Nullable
    public NBT serializeOr(@Nullable Component component, @Nullable NBT fallback, PacketWrapper<?> wrapper) {
        return component != null ? this.serialize(component, wrapper) : fallback;
    }

    @Override
    @Deprecated
    @NotNull
    public Component deserialize(@NotNull NBT input) {
        return this.deserialize(input, PacketWrapper.createDummyWrapper(this.version));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public Component deserialize(@NotNull NBT input, PacketWrapper<?> wrapper) {
        void var23_35;
        NBTType<?> type;
        Function<NBT, String> textFunction;
        if (input.getType() == NBTType.STRING) {
            return Component.text(((NBTString)input).getValue());
        }
        if (input.getType() == NBTType.BYTE && ((NBTByte)input).getAsByte() < 2) {
            return Component.text(((NBTByte)input).getAsByte() == 1);
        }
        if (input instanceof NBTNumber) {
            return Component.text(((NBTNumber)input).getAsInt());
        }
        NBTCompound compound = AdventureNBTSerializer.requireType(input, NBTType.COMPOUND);
        NBTReader reader = new NBTReader(compound);
        String text = reader.read("text", textFunction = nbt -> {
            if (nbt.getType() == NBTType.STRING) {
                return ((NBTString)nbt).getValue();
            }
            if (nbt.getType() == NBTType.BYTE && ((NBTByte)nbt).getAsByte() < 2) {
                return String.valueOf(((NBTByte)nbt).getAsByte() == 1);
            }
            if (nbt instanceof NBTNumber) {
                return String.valueOf(((NBTNumber)nbt).getAsInt());
            }
            throw new IllegalStateException("Don't know how to deserialize " + nbt.getType() + " to text");
        });
        if (text == null) {
            text = reader.read("", textFunction);
        }
        String translate = (String)reader.readUTF("translate", Function.identity());
        String translateFallback = (String)reader.readUTF("fallback", Function.identity());
        List translateWith = BackwardCompatUtil.IS_4_15_0_OR_NEWER ? ((type = reader.type("with")) == NBTType.INT_ARRAY ? reader.readIntArray("with", params -> {
            ArrayList<TranslationArgument> args = new ArrayList<TranslationArgument>(((int[])params).length);
            for (int param : params) {
                args.add(TranslationArgument.numeric(param));
            }
            return args;
        }) : (type == NBTType.BYTE_ARRAY ? reader.readByteArray("with", params -> {
            ArrayList<TranslationArgument> args = new ArrayList<TranslationArgument>(((byte[])params).length);
            for (byte param : params) {
                args.add(TranslationArgument.bool(param != 0));
            }
            return args;
        }) : (type == NBTType.LONG_ARRAY ? reader.readLongArray("with", params -> {
            ArrayList<TranslationArgument> args = new ArrayList<TranslationArgument>(((long[])params).length);
            for (long param : params) {
                args.add(TranslationArgument.numeric(param));
            }
            return args;
        }) : reader.readList("with", tag -> this.deserializeTranslationArgumentList((List<?>)tag, wrapper))))) : reader.readList("with", tag -> this.deserializeComponentList((List<?>)tag, wrapper));
        NBTReader score = reader.child("score");
        String selector = (String)reader.readUTF("selector", Function.identity());
        String keybind = (String)reader.readUTF("keybind", Function.identity());
        String nbt2 = (String)reader.readUTF("nbt", Function.identity());
        boolean nbtInterpret = Optional.ofNullable((Boolean)reader.readBoolean("interpret", Function.identity())).orElse(false);
        BlockNBTComponent.Pos nbtBlock = reader.readUTF("block", BlockNBTComponent.Pos::fromString);
        String nbtEntity = (String)reader.readUTF("entity", Function.identity());
        Key nbtStorage = reader.readUTF("storage", Key::key);
        List extra = reader.readList("extra", tag -> this.deserializeComponentList((List<?>)tag, wrapper));
        Component separator = reader.read("separator", tag -> this.deserialize((NBT)tag, wrapper));
        NBT player = (NBT)reader.read("player", Function.identity());
        String sprite = (String)reader.readUTF("sprite", Function.identity());
        Style style = this.deserializeStyle(compound, wrapper);
        if (text != null) {
            TextComponent.Builder builder = Component.text().content(text);
        } else if (translate != null) {
            TranslatableComponent.Builder i18nBuilder;
            TranslatableComponent.Builder builder = i18nBuilder = Component.translatable().key(translate);
            if (translateWith != null) {
                if (BackwardCompatUtil.IS_4_15_0_OR_NEWER) {
                    i18nBuilder.arguments(translateWith);
                } else {
                    i18nBuilder.args(translateWith);
                }
            }
            if (BackwardCompatUtil.IS_4_13_0_OR_NEWER) {
                i18nBuilder.fallback(translateFallback);
            }
        } else if (score != null) {
            ScoreComponent.Builder builder = Component.score().name((String)score.readUTF("name", Function.identity())).objective((String)score.readUTF("objective", Function.identity()));
        } else if (selector != null) {
            SelectorComponent.Builder builder = Component.selector().pattern(selector).separator(separator);
        } else if (keybind != null) {
            KeybindComponent.Builder builder = Component.keybind().keybind(keybind);
        } else if (nbt2 != null) {
            if (nbtBlock != null) {
                BlockNBTComponent.Builder builder = ((BlockNBTComponent.Builder)((BlockNBTComponent.Builder)((BlockNBTComponent.Builder)Component.blockNBT().nbtPath(nbt2)).interpret(nbtInterpret)).separator(separator)).pos(nbtBlock);
            } else if (nbtEntity != null) {
                EntityNBTComponent.Builder builder = ((EntityNBTComponent.Builder)((EntityNBTComponent.Builder)((EntityNBTComponent.Builder)Component.entityNBT().nbtPath(nbt2)).interpret(nbtInterpret)).separator(separator)).selector(nbtEntity);
            } else {
                if (nbtStorage == null) throw new IllegalStateException("Illegal nbt component, block/entity/storage is missing");
                StorageNBTComponent.Builder builder = ((StorageNBTComponent.Builder)((StorageNBTComponent.Builder)((StorageNBTComponent.Builder)Component.storageNBT().nbtPath(nbt2)).interpret(nbtInterpret)).separator(separator)).storage(nbtStorage);
            }
        } else if (player != null) {
            if (BackwardCompatUtil.IS_4_25_0_OR_NEWER) {
                ItemProfile profile = ItemProfile.decode(player, wrapper);
                PlayerHeadObjectContents playerHead = ObjectContents.playerHead().id(profile.getId()).name(profile.getName()).profileProperties(profile.getAdventureProperties()).hat(Optional.ofNullable((Boolean)reader.readBoolean("hat", Function.identity())).orElse(true)).build();
                ObjectComponent.Builder builder = Component.object().contents(playerHead);
            } else {
                TextComponent.Builder builder = Component.text();
            }
        } else {
            if (sprite == null) throw new IllegalStateException("Illegal nbt component, component type could not be determined");
            if (BackwardCompatUtil.IS_4_25_0_OR_NEWER) {
                Key spriteKey = Key.key(sprite);
                Key atlasKey = reader.readUTF("atlas", atlas -> Key.key(atlas));
                ObjectComponent.Builder builder = Component.object().contents(atlasKey != null ? ObjectContents.sprite(atlasKey, spriteKey) : ObjectContents.sprite(spriteKey));
            } else {
                TextComponent.Builder builder = Component.text();
            }
        }
        var23_35.style(style);
        if (extra == null) return var23_35.build();
        var23_35.append(extra);
        return var23_35.build();
    }

    @Override
    @Deprecated
    @NotNull
    public NBT serialize(@NotNull Component component) {
        return this.serialize(component, PacketWrapper.createDummyWrapper(this.version));
    }

    @NotNull
    public NBT serialize(@NotNull Component component, PacketWrapper<?> wrapper) {
        if (component instanceof TextComponent && !component.hasStyling() && component.children().isEmpty()) {
            return new NBTString(((TextComponent)component).content());
        }
        return this.serializeComponent(component, wrapper);
    }

    @NotNull
    private NBTCompound serializeComponent(Component component, PacketWrapper<?> wrapper) {
        List<Component> children;
        NBTWriter writer = new NBTWriter(new NBTCompound());
        if (component instanceof TextComponent) {
            writer.writeUTF("text", ((TextComponent)component).content());
        } else if (component instanceof TranslatableComponent) {
            List<Component> args;
            String fallback;
            writer.writeUTF("translate", ((TranslatableComponent)component).key());
            if (BackwardCompatUtil.IS_4_13_0_OR_NEWER && (fallback = ((TranslatableComponent)component).fallback()) != null) {
                writer.writeUTF("fallback", fallback);
            }
            if (!(args = ((TranslatableComponent)component).args()).isEmpty()) {
                if (BackwardCompatUtil.IS_4_15_0_OR_NEWER) {
                    writer.writeList("with", NBTType.COMPOUND, this.serializeTranslationArgumentList(((TranslatableComponent)component).arguments(), wrapper));
                } else {
                    writer.writeList("with", NBTType.COMPOUND, this.serializeComponentList(args, wrapper));
                }
            }
        } else if (component instanceof ScoreComponent) {
            NBTWriter score = writer.child("score");
            String scoreName = ((ScoreComponent)component).name();
            score.writeUTF("name", scoreName);
            String scoreObjective = ((ScoreComponent)component).objective();
            score.writeUTF("objective", scoreObjective);
        } else if (component instanceof SelectorComponent) {
            writer.writeUTF("selector", ((SelectorComponent)component).pattern());
            Component separator = ((SelectorComponent)component).separator();
            if (separator != null) {
                writer.write("separator", this.serialize(separator, wrapper));
            }
        } else if (component instanceof KeybindComponent) {
            writer.writeUTF("keybind", ((KeybindComponent)component).keybind());
        } else if (component instanceof NBTComponent) {
            Component separator;
            String nbtPath = ((NBTComponent)component).nbtPath();
            writer.writeUTF("nbt", nbtPath);
            boolean interpret = ((NBTComponent)component).interpret();
            if (interpret) {
                writer.writeBoolean("interpret", true);
            }
            if ((separator = ((NBTComponent)component).separator()) != null) {
                writer.write("separator", this.serialize(separator, wrapper));
            }
            if (component instanceof BlockNBTComponent) {
                BlockNBTComponent.Pos pos = ((BlockNBTComponent)component).pos();
                writer.writeUTF("block", pos.asString());
            } else if (component instanceof EntityNBTComponent) {
                String selector = ((EntityNBTComponent)component).selector();
                writer.writeUTF("entity", selector);
            } else if (component instanceof StorageNBTComponent) {
                Key storage = ((StorageNBTComponent)component).storage();
                writer.writeUTF("storage", storage.asString());
            }
        } else if (component instanceof ObjectComponent) {
            if (BackwardCompatUtil.IS_4_25_0_OR_NEWER && this.version.isNewerThanOrEquals(ClientVersion.V_1_21_9)) {
                ObjectContents objectContents = ((ObjectComponent)component).contents();
                if (objectContents instanceof PlayerHeadObjectContents) {
                    PlayerHeadObjectContents playerHead = (PlayerHeadObjectContents)objectContents;
                    ItemProfile profile = ItemProfile.fromAdventure(playerHead);
                    writer.write("player", ItemProfile.encode(wrapper, profile));
                    if (!playerHead.hat()) {
                        writer.writeBoolean("hat", playerHead.hat());
                    }
                } else if (objectContents instanceof SpriteObjectContents) {
                    SpriteObjectContents spriteObjectContents = (SpriteObjectContents)objectContents;
                    if (!spriteObjectContents.atlas().equals(SpriteObjectContents.DEFAULT_ATLAS)) {
                        writer.writeUTF("atlas", spriteObjectContents.atlas().toString());
                    }
                    writer.writeUTF("sprite", spriteObjectContents.sprite().toString());
                }
            } else {
                writer.writeUTF("text", "");
            }
        }
        if (component.hasStyling()) {
            this.serializeStyle(component.style(), wrapper).getTags().forEach(writer::write);
        }
        if (!(children = component.children()).isEmpty()) {
            writer.writeList("extra", NBTType.COMPOUND, this.serializeComponentList(children, wrapper));
        }
        return writer.compound;
    }

    @Deprecated
    @NotNull
    public Style deserializeStyle(NBTCompound input) {
        return this.deserializeStyle(input, PacketWrapper.createDummyWrapper(this.version));
    }

    @NotNull
    public Style deserializeStyle(NBTCompound input, PacketWrapper<?> wrapper) {
        NBTReader hoverEvent;
        if (input.isEmpty()) {
            return Style.empty();
        }
        Style.Builder style = Style.style();
        NBTReader reader = new NBTReader(input);
        reader.useUTF("font", value -> style.font(Key.key(value)));
        reader.useUTF("color", value -> {
            TextColor color = this.deserializeColor((String)value);
            if (color != null) {
                style.color(color);
            }
        });
        if (BackwardCompatUtil.IS_4_18_0_OR_NEWER) {
            reader.useNumber("shadow_color", num -> style.shadowColor(ShadowColor.shadowColor(num.intValue())));
        }
        for (String decorationKey : TextDecoration.NAMES.keys()) {
            reader.useBoolean(decorationKey, value -> style.decoration(AdventureIndexUtil.indexValueOrThrow(TextDecoration.NAMES, decorationKey), TextDecoration.State.byBoolean(value)));
        }
        reader.useUTF("insertion", style::insertion);
        boolean modernEvents = this.version.isNewerThanOrEquals(ClientVersion.V_1_21_5);
        NBTReader clickEvent = reader.child(modernEvents ? "click_event" : "clickEvent");
        if (clickEvent != null) {
            ClickEvent value2;
            ClickEvent.Action action = clickEvent.readUTF("action", ClickEvent.Action.NAMES::value);
            if (!modernEvents) {
                value2 = ClickEvent.clickEvent(action, (String)clickEvent.readUTF("value", Function.identity()));
            } else {
                switch (action) {
                    case OPEN_URL: {
                        value2 = ClickEvent.openUrl((String)clickEvent.readUTF("url", Function.identity()));
                        break;
                    }
                    case OPEN_FILE: {
                        value2 = ClickEvent.openFile((String)clickEvent.readUTF("path", Function.identity()));
                        break;
                    }
                    case RUN_COMMAND: {
                        value2 = ClickEvent.runCommand((String)clickEvent.readUTF("command", Function.identity()));
                        break;
                    }
                    case SUGGEST_COMMAND: {
                        value2 = ClickEvent.suggestCommand((String)clickEvent.readUTF("command", Function.identity()));
                        break;
                    }
                    case CHANGE_PAGE: {
                        value2 = ClickEvent.changePage(clickEvent.readNumber("page", Number::intValue));
                        break;
                    }
                    case COPY_TO_CLIPBOARD: {
                        value2 = ClickEvent.copyToClipboard((String)clickEvent.readUTF("value", Function.identity()));
                        break;
                    }
                    case SHOW_DIALOG: {
                        NBT dialogTag = (NBT)clickEvent.read("dialog", Function.identity());
                        value2 = ClickEvent.showDialog(Dialog.decode(dialogTag, wrapper));
                        break;
                    }
                    case CUSTOM: {
                        Key key = clickEvent.readUTF("id", Key::key);
                        NBT payload = (NBT)clickEvent.read("payload", Function.identity());
                        value2 = ClickEvent.custom(key, new NbtTagHolder(payload != null ? payload : NBTEnd.INSTANCE));
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unsupported clickevent: " + (Object)((Object)action));
                    }
                }
            }
            style.clickEvent(value2);
        }
        if ((hoverEvent = reader.child(modernEvents ? "hover_event" : "hoverEvent")) != null) {
            HoverEvent.Action action = hoverEvent.readUTF("action", HoverEvent.Action.NAMES::value);
            switch (action.toString()) {
                case "show_text": {
                    style.hoverEvent(HoverEvent.showText(hoverEvent.read(modernEvents ? "value" : "contents", tag -> this.deserialize((NBT)tag, wrapper))));
                    break;
                }
                case "show_item": {
                    NBTReader item;
                    if (!modernEvents && hoverEvent.type("contents") == NBTType.STRING) {
                        style.hoverEvent(HoverEvent.showItem(hoverEvent.readUTF("contents", Key::key), 1));
                        break;
                    }
                    NBTReader nBTReader = item = modernEvents ? hoverEvent : hoverEvent.child("contents");
                    if (item == null) break;
                    Key itemId = item.readUTF("id", Key::key);
                    Integer count = item.readNumber("count", Number::intValue);
                    int nonNullCount = count == null ? 1 : count;
                    BinaryTagHolder tag2 = item.readUTF("tag", BinaryTagHolder::binaryTagHolder);
                    if (tag2 != null || !BackwardCompatUtil.IS_4_17_0_OR_NEWER) {
                        style.hoverEvent(HoverEvent.showItem(itemId, nonNullCount, tag2));
                        break;
                    }
                    Map components = item.readCompound("components", nbt -> {
                        HashMap<Key, DataComponentValue> map = new HashMap<Key, DataComponentValue>(nbt.size());
                        for (Map.Entry<String, NBT> entry : nbt.getTags().entrySet()) {
                            Key key;
                            if (entry.getKey().startsWith("!")) {
                                key = Key.key(entry.getKey().substring(1));
                                map.put(key, DataComponentValue.removed());
                                continue;
                            }
                            key = Key.key(entry.getKey());
                            map.put(key, new NbtTagHolder(entry.getValue()));
                        }
                        return map;
                    });
                    style.hoverEvent(HoverEvent.showItem((Keyed)itemId, nonNullCount, components == null ? Collections.emptyMap() : components));
                    break;
                }
                case "show_entity": {
                    NBTReader entity;
                    NBTReader nBTReader = entity = modernEvents ? hoverEvent : hoverEvent.child("contents");
                    if (entity == null) break;
                    style.hoverEvent(HoverEvent.showEntity(entity.readUTF(modernEvents ? "id" : "type", Key::key), entity.readIntArray(modernEvents ? "uuid" : "id", UniqueIdUtil::fromIntArray), entity.read("name", name -> this.deserialize((NBT)name, wrapper))));
                }
            }
        }
        return style.build();
    }

    @Deprecated
    @NotNull
    public NBTCompound serializeStyle(Style style) {
        return this.serializeStyle(style, PacketWrapper.createDummyWrapper(this.version));
    }

    @NotNull
    public NBTCompound serializeStyle(Style style, PacketWrapper<?> wrapper) {
        HoverEvent<?> hoverEvent;
        ClickEvent clickEvent;
        Object shadowColor;
        TextColor color;
        if (style.isEmpty()) {
            return new NBTCompound();
        }
        NBTWriter writer = new NBTWriter(new NBTCompound());
        Key font = style.font();
        if (font != null) {
            writer.writeUTF("font", font.asString());
        }
        if ((color = style.color()) != null) {
            writer.writeUTF("color", this.serializeColor(color));
        }
        if (BackwardCompatUtil.IS_4_18_0_OR_NEWER && (shadowColor = style.shadowColor()) != null) {
            writer.writeInt("shadow_color", shadowColor.value());
        }
        for (TextDecoration decoration : TextDecoration.NAMES.values()) {
            TextDecoration.State state = style.decoration(decoration);
            if (state == TextDecoration.State.NOT_SET) continue;
            writer.writeBoolean(decoration.toString(), state == TextDecoration.State.TRUE);
        }
        String insertion = style.insertion();
        if (insertion != null) {
            writer.writeUTF("insertion", insertion);
        }
        if ((clickEvent = style.clickEvent()) != null) {
            boolean modern = this.version.isNewerThanOrEquals(ClientVersion.V_1_21_5);
            NBTWriter child = writer.child(modern ? "click_event" : "clickEvent");
            child.writeUTF("action", clickEvent.action().toString());
            if (!modern) {
                child.writeUTF("value", clickEvent.value());
            } else {
                switch (clickEvent.action()) {
                    case OPEN_URL: {
                        child.writeUTF("url", clickEvent.value());
                        break;
                    }
                    case OPEN_FILE: {
                        child.writeUTF("path", clickEvent.value());
                        break;
                    }
                    case RUN_COMMAND: 
                    case SUGGEST_COMMAND: {
                        child.writeUTF("command", clickEvent.value());
                        break;
                    }
                    case CHANGE_PAGE: {
                        if (BackwardCompatUtil.IS_4_22_0_OR_NEWER) {
                            child.writeInt("page", ((ClickEvent.Payload.Int)clickEvent.payload()).integer());
                            break;
                        }
                        child.writeInt("page", Integer.parseInt(clickEvent.value()));
                        break;
                    }
                    case COPY_TO_CLIPBOARD: {
                        child.writeUTF("value", clickEvent.value());
                        break;
                    }
                    case SHOW_DIALOG: {
                        Dialog dialog = (Dialog)((ClickEvent.Payload.Dialog)clickEvent.payload()).dialog();
                        child.write("dialog", Dialog.encode(wrapper, dialog));
                        break;
                    }
                    case CUSTOM: {
                        ClickEvent.Payload.Custom customPayload = (ClickEvent.Payload.Custom)clickEvent.payload();
                        child.writeUTF("id", customPayload.key().asString());
                        BinaryTagHolder nbtHolder = customPayload.nbt();
                        if (nbtHolder instanceof NbtTagHolder) {
                            NBT payloadTag = ((NbtTagHolder)nbtHolder).getTag();
                            if (payloadTag instanceof NBTEnd) break;
                            child.write("payload", payloadTag);
                            break;
                        }
                        String nbtString = nbtHolder.string();
                        if (nbtString.isEmpty()) break;
                        child.write("payload", AdventureNbtUtil.fromString(nbtString));
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unsupported clickevent: " + clickEvent);
                    }
                }
            }
        }
        if ((hoverEvent = style.hoverEvent()) != null) {
            boolean modern = this.version.isNewerThanOrEquals(ClientVersion.V_1_21_5);
            NBTWriter child = writer.child(modern ? "hover_event" : "hoverEvent");
            child.writeUTF("action", hoverEvent.action().toString());
            switch (hoverEvent.action().toString()) {
                case "show_text": {
                    child.write(modern ? "value" : "contents", this.serialize((Component)hoverEvent.value(), wrapper));
                    break;
                }
                case "show_item": {
                    boolean emptyComps;
                    HoverEvent.ShowItem item = (HoverEvent.ShowItem)hoverEvent.value();
                    Key itemId = item.item();
                    int count = item.count();
                    BinaryTagHolder nbt = item.nbt();
                    boolean bl = emptyComps = !BackwardCompatUtil.IS_4_17_0_OR_NEWER || item.dataComponents().isEmpty();
                    if (!modern && count == 1 && nbt == null && emptyComps) {
                        child.writeUTF("contents", itemId.asString());
                        break;
                    }
                    NBTWriter itemNBT = modern ? child : child.child("contents");
                    itemNBT.writeUTF("id", itemId.asString());
                    if (!modern || count != 1) {
                        itemNBT.writeInt("count", count);
                    }
                    if (nbt != null) {
                        itemNBT.writeUTF("tag", nbt.string());
                    }
                    if (emptyComps) break;
                    NBTWriter compsNbt = itemNBT.child("components");
                    for (Map.Entry<Key, DataComponentValue> entry : item.dataComponents().entrySet()) {
                        if (entry.getValue() == DataComponentValue.removed()) {
                            compsNbt.writeCompound("!" + entry.getKey(), new NBTCompound());
                            continue;
                        }
                        if (!(entry.getValue() instanceof NbtTagHolder)) continue;
                        NBT compNbt = ((NbtTagHolder)entry.getValue()).getTag();
                        compsNbt.write(entry.getKey().toString(), compNbt);
                    }
                    break;
                }
                case "show_entity": {
                    NBTWriter entity;
                    HoverEvent.ShowEntity showEntity = (HoverEvent.ShowEntity)hoverEvent.value();
                    NBTWriter nBTWriter = entity = modern ? child : child.child("contents");
                    if (entity == null) break;
                    entity.writeUTF(modern ? "id" : "type", showEntity.type().asString());
                    entity.writeIntArray(modern ? "uuid" : "id", UniqueIdUtil.toIntArray(showEntity.id()));
                    if (showEntity.name() == null) break;
                    entity.write("name", this.serialize(showEntity.name(), wrapper));
                }
            }
        }
        return writer.compound;
    }

    @Nullable
    private TextColor deserializeColor(@NotNull String value) {
        TextColor color = value.startsWith("#") ? TextColor.fromHexString(value) : (TextColor)NamedTextColor.NAMES.value(value);
        if (color == null) {
            return null;
        }
        return this.downsampleColor ? NamedTextColor.nearestTo(color) : color;
    }

    @NotNull
    private String serializeColor(@NotNull TextColor value) {
        if (value instanceof NamedTextColor) {
            return NamedTextColor.NAMES.key((NamedTextColor)value);
        }
        if (this.downsampleColor) {
            return NamedTextColor.NAMES.key(NamedTextColor.nearestTo(value));
        }
        return String.format(Locale.ROOT, "%c%06X", Character.valueOf('#'), value.value());
    }

    @NotNull
    private List<Component> deserializeComponentList(List<?> value, PacketWrapper<?> wrapper) {
        if (value.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Component> components = new ArrayList<Component>(value.size());
        for (Object nbt : value) {
            components.add(this.deserialize((NBT)nbt, wrapper));
        }
        return components;
    }

    private List<NBTCompound> serializeComponentList(List<Component> value, PacketWrapper<?> wrapper) {
        ArrayList<NBTCompound> components = new ArrayList<NBTCompound>(value.size());
        for (Component component : value) {
            components.add(this.serializeComponent(component, wrapper));
        }
        return components;
    }

    @NotNull
    private List<TranslationArgument> deserializeTranslationArgumentList(List<?> value, PacketWrapper<?> wrapper) {
        if (value.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<TranslationArgument> arguments = new ArrayList<TranslationArgument>(value.size());
        for (Object nbt : value) {
            if (nbt instanceof NBTByte) {
                arguments.add(TranslationArgument.bool(((NBTByte)nbt).getAsByte() != 0));
                continue;
            }
            if (nbt instanceof NBTNumber) {
                arguments.add(TranslationArgument.numeric(((NBTNumber)nbt).getAsInt()));
                continue;
            }
            if (nbt instanceof NBTString) {
                arguments.add(TranslationArgument.component(Component.text(((NBTString)nbt).getValue())));
                continue;
            }
            arguments.add(TranslationArgument.component(this.deserialize(AdventureNBTSerializer.requireType((NBT)nbt, NBTType.COMPOUND), wrapper)));
        }
        return arguments;
    }

    private List<NBTCompound> serializeTranslationArgumentList(List<TranslationArgument> value, PacketWrapper<?> wrapper) {
        ArrayList<NBTCompound> arguments = new ArrayList<NBTCompound>(value.size());
        for (TranslationArgument argument : value) {
            arguments.add(this.serializeComponent(argument.asComponent(), wrapper));
        }
        return arguments;
    }

    private static <T extends NBT> T requireType(NBT nbt, NBTType<T> required) {
        if (nbt.getType() != required) {
            throw new IllegalArgumentException("Expected " + required + " but got " + nbt.getType());
        }
        return (T)nbt;
    }

    static class NBTReader {
        private final NBTCompound compound;

        public NBTReader(NBTCompound compound) {
            this.compound = compound;
        }

        public void useBoolean(String key, Consumer<Boolean> consumer) {
            this.useNumber(key, num -> consumer.accept(num.byteValue() != 0));
        }

        public <R> R readBoolean(String key, Function<Boolean, R> function) {
            return (R)this.readNumber(key, num -> function.apply(num.byteValue() != 0));
        }

        public void useNumber(String key, Consumer<Number> consumer) {
            this.useTag(key, tag -> {
                if (!(tag instanceof NBTNumber)) {
                    throw new IllegalArgumentException("Expected number but got " + tag.getType());
                }
                consumer.accept(((NBTNumber)tag).getAsNumber());
            });
        }

        public <R> R readNumber(String key, Function<Number, R> function) {
            return (R)this.withTag(key, tag -> {
                if (tag instanceof NBTNumber) {
                    return function.apply(((NBTNumber)tag).getAsNumber());
                }
                throw new IllegalArgumentException("Expected number but got " + tag.getType());
            });
        }

        public void useUTF(String key, Consumer<String> consumer) {
            this.useTag(key, tag -> consumer.accept(((NBTString)AdventureNBTSerializer.requireType(tag, NBTType.STRING)).getValue()));
        }

        public <R> R readUTF(String key, Function<String, R> function) {
            return (R)this.withTag(key, tag -> function.apply(((NBTString)AdventureNBTSerializer.requireType(tag, NBTType.STRING)).getValue()));
        }

        public void useByteArray(String key, Consumer<byte[]> consumer) {
            this.useTag(key, tag -> consumer.accept(((NBTByteArray)AdventureNBTSerializer.requireType(tag, NBTType.BYTE_ARRAY)).getValue()));
        }

        public <R> R readByteArray(String key, Function<byte[], R> function) {
            return (R)this.withTag(key, tag -> function.apply(((NBTByteArray)AdventureNBTSerializer.requireType(tag, NBTType.BYTE_ARRAY)).getValue()));
        }

        public void useIntArray(String key, Consumer<int[]> consumer) {
            this.useTag(key, tag -> consumer.accept(((NBTIntArray)AdventureNBTSerializer.requireType(tag, NBTType.INT_ARRAY)).getValue()));
        }

        public <R> R readIntArray(String key, Function<int[], R> function) {
            return (R)this.withTag(key, tag -> function.apply(((NBTIntArray)AdventureNBTSerializer.requireType(tag, NBTType.INT_ARRAY)).getValue()));
        }

        public void useLongArray(String key, Consumer<long[]> consumer) {
            this.useTag(key, tag -> consumer.accept(((NBTLongArray)AdventureNBTSerializer.requireType(tag, NBTType.LONG_ARRAY)).getValue()));
        }

        public <R> R readLongArray(String key, Function<long[], R> function) {
            return (R)this.withTag(key, tag -> function.apply(((NBTLongArray)AdventureNBTSerializer.requireType(tag, NBTType.LONG_ARRAY)).getValue()));
        }

        public void useCompound(String key, Consumer<NBTCompound> consumer) {
            this.useTag(key, tag -> consumer.accept((NBTCompound)AdventureNBTSerializer.requireType(tag, NBTType.COMPOUND)));
        }

        public <R> R readCompound(String key, Function<NBTCompound, R> function) {
            return (R)this.withTag(key, tag -> function.apply((NBTCompound)AdventureNBTSerializer.requireType(tag, NBTType.COMPOUND)));
        }

        public void useList(String key, Consumer<List<?>> consumer) {
            this.useTag(key, tag -> consumer.accept(((NBTList)AdventureNBTSerializer.requireType(tag, NBTType.LIST)).getTags()));
        }

        public <R> R readList(String key, Function<List<?>, R> function) {
            return (R)this.withTag(key, tag -> function.apply(((NBTList)AdventureNBTSerializer.requireType(tag, NBTType.LIST)).getTags()));
        }

        public void use(String key, Consumer<NBT> consumer) {
            this.useTag(key, consumer);
        }

        public <R> R read(String key, Function<NBT, R> function) {
            return this.withTag(key, function);
        }

        public NBTReader child(String key) {
            return this.withTag(key, tag -> new NBTReader((NBTCompound)AdventureNBTSerializer.requireType(tag, NBTType.COMPOUND)));
        }

        public NBTType<?> type(String key) {
            return this.withTag(key, NBT::getType);
        }

        private void useTag(String key, Consumer<NBT> consumer) {
            NBT tag = this.compound.getTagOrNull(key);
            if (tag != null) {
                consumer.accept(tag);
            }
        }

        private <R> R withTag(String key, Function<NBT, R> function) {
            NBT tag = this.compound.getTagOrNull(key);
            return tag == null ? null : (R)function.apply(tag);
        }
    }

    static class NBTWriter {
        private final NBTCompound compound;

        public NBTWriter(NBTCompound compound) {
            this.compound = compound;
        }

        public void writeBoolean(String key, boolean value) {
            this.compound.setTag(key, new NBTByte(value ? (byte)1 : 0));
        }

        public void writeByte(String key, byte value) {
            this.compound.setTag(key, new NBTByte(value));
        }

        public void writeShort(String key, short value) {
            this.compound.setTag(key, new NBTShort(value));
        }

        public void writeInt(String key, int value) {
            this.compound.setTag(key, new NBTInt(value));
        }

        public void writeLong(String key, long value) {
            this.compound.setTag(key, new NBTLong(value));
        }

        public void writeFloat(String key, float value) {
            this.compound.setTag(key, new NBTFloat(value));
        }

        public void writeDouble(String key, double value) {
            this.compound.setTag(key, new NBTDouble(value));
        }

        public void writeUTF(String key, String value) {
            this.compound.setTag(key, new NBTString(value));
        }

        public void writeByteArray(String key, byte[] value) {
            this.compound.setTag(key, new NBTByteArray(value));
        }

        public void writeIntArray(String key, int[] value) {
            this.compound.setTag(key, new NBTIntArray(value));
        }

        public void writeLongArray(String key, long[] value) {
            this.compound.setTag(key, new NBTLongArray(value));
        }

        public <T extends NBT> void writeList(String key, NBTType<T> innerType, List<T> value) {
            this.compound.setTag(key, new NBTList<T>(innerType, value));
        }

        public void writeCompound(String key, NBTCompound value) {
            this.compound.setTag(key, value);
        }

        public void write(String key, NBT value) {
            this.compound.setTag(key, value);
        }

        public NBTWriter child(String key) {
            NBTCompound child = new NBTCompound();
            this.compound.setTag(key, child);
            return new NBTWriter(child);
        }
    }
}

