/*
 * Decompiled with CFR 0.152.
 */
package com.github.retrooper.packetevents.util;

import com.github.retrooper.packetevents.protocol.component.ComponentType;
import com.github.retrooper.packetevents.protocol.nbt.NBT;
import com.github.retrooper.packetevents.protocol.nbt.NBTCompound;
import com.github.retrooper.packetevents.protocol.nbt.NBTInt;
import com.github.retrooper.packetevents.protocol.nbt.NBTList;
import com.github.retrooper.packetevents.protocol.nbt.NBTType;
import com.github.retrooper.packetevents.protocol.player.ClientVersion;
import com.github.retrooper.packetevents.protocol.util.NbtCodec;
import com.github.retrooper.packetevents.protocol.util.NbtCodecException;
import com.github.retrooper.packetevents.protocol.util.NbtMapCodec;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class RandomWeightedList<T>
implements Iterable<Entry<T>> {
    private List<Entry<T>> entries;

    public RandomWeightedList() {
        this(new ArrayList<Entry<T>>());
    }

    public RandomWeightedList(List<Entry<T>> entries) {
        this.entries = entries;
    }

    public RandomWeightedList(T entry, int weight) {
        this(new Entry<T>(entry, weight));
    }

    public RandomWeightedList(Entry<T> entry) {
        this.entries = new ArrayList<Entry<T>>(1);
        this.entries.add(entry);
    }

    public static <T> NbtCodec<RandomWeightedList<T>> codec(NbtCodec<T> codec) {
        return Entry.codec(codec).applyList().apply(RandomWeightedList::new, RandomWeightedList::getEntries);
    }

    @Deprecated
    public static <T> RandomWeightedList<T> decode(NBT nbt, ClientVersion version, ComponentType.Decoder<T> decoder) {
        ArrayList<Entry<T>> entries;
        if (nbt instanceof NBTCompound) {
            entries = new ArrayList<Entry<T>>(1);
            entries.add(Entry.decode(nbt, version, decoder));
        } else if (nbt instanceof NBTList) {
            NBTList list = (NBTList)nbt;
            entries = new ArrayList(list.size());
            for (NBT tag : list.getTags()) {
                entries.add(Entry.decode(tag, version, decoder));
            }
        } else {
            throw new UnsupportedOperationException("Can't decode " + nbt + " as random weighted list");
        }
        return new RandomWeightedList<T>(entries);
    }

    @Deprecated
    public static <T> NBT encode(RandomWeightedList<T> list, ClientVersion version, ComponentType.Encoder<T> encoder) {
        NBTList<NBTCompound> nbt = new NBTList<NBTCompound>(NBTType.COMPOUND, list.entries.size());
        for (Entry<T> entry : list.entries) {
            nbt.addTag(Entry.encode(entry, version, encoder));
        }
        return nbt;
    }

    public List<Entry<T>> getEntries() {
        return this.entries;
    }

    public void setEntries(List<Entry<T>> entries) {
        this.entries = entries;
    }

    public int size() {
        return this.entries.size();
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    @Override
    public Iterator<Entry<T>> iterator() {
        return this.entries.iterator();
    }

    public static final class Entry<T> {
        private final T data;
        private final int weight;

        public Entry(T data, int weight) {
            this.data = data;
            this.weight = weight;
        }

        public static <T> NbtCodec<Entry<T>> codec(final NbtCodec<T> codec) {
            return new NbtMapCodec<Entry<T>>(){

                @Override
                public Entry<T> decode(NBTCompound compound, PacketWrapper<?> wrapper) throws NbtCodecException {
                    int weight = compound.getNumberTagOrThrow("weight").getAsInt();
                    Object data = compound.getOrThrow("data", codec, wrapper);
                    return new Entry(data, weight);
                }

                @Override
                public void encode(NBTCompound compound, PacketWrapper<?> wrapper, Entry<T> value) throws NbtCodecException {
                    compound.setTag("weight", new NBTInt(value.weight));
                    compound.set("data", value.data, codec, wrapper);
                }
            }.codec();
        }

        @Deprecated
        public static <T> Entry<T> decode(NBT nbt, ClientVersion version, ComponentType.Decoder<T> decoder) {
            NBTCompound compound = (NBTCompound)nbt;
            int weight = compound.getNumberTagOrThrow("weight").getAsInt();
            T data = decoder.decode(compound.getTagOrThrow("data"), version);
            return new Entry<T>(data, weight);
        }

        @Deprecated
        public static <T> NBTCompound encode(Entry<T> entry, ClientVersion version, ComponentType.Encoder<T> encoder) {
            NBTCompound compound = new NBTCompound();
            compound.setTag("weight", new NBTInt(entry.weight));
            compound.setTag("data", encoder.encode(entry.data, version));
            return compound;
        }

        public T getData() {
            return this.data;
        }

        public int getWeight() {
            return this.weight;
        }
    }
}

