/*
 * Decompiled with CFR 0.152.
 */
package com.github.retrooper.packetevents.util;

import com.github.retrooper.packetevents.protocol.mapper.DeepComparableEntity;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
@ApiStatus.Internal
public final class MapUtil {
    private MapUtil() {
    }

    public static boolean isDeepEqual(@Nullable Object o1, @Nullable Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        if (o1 instanceof DeepComparableEntity) {
            return ((DeepComparableEntity)o1).deepEquals(o2);
        }
        if (o2 instanceof DeepComparableEntity) {
            return ((DeepComparableEntity)o2).deepEquals(o2);
        }
        return Objects.equals(o1, o2);
    }

    public static <K> boolean isDeepEqual(Map<K, ?> map1, Map<K, ?> map2) {
        if (map1.isEmpty() && map2.isEmpty()) {
            return true;
        }
        if (map1.size() != map2.size()) {
            return false;
        }
        for (Map.Entry<K, ?> entry : map1.entrySet()) {
            Object val2 = map2.get(entry.getKey());
            if (MapUtil.isDeepEqual(entry.getValue(), val2)) continue;
            return false;
        }
        return true;
    }

    @SafeVarargs
    public static <K, V> Map<K, V> createMap(Map.Entry<? extends K, ? extends V> ... entries) {
        if (entries.length == 0) {
            return Collections.emptyMap();
        }
        HashMap<K, V> map = new HashMap<K, V>(entries.length);
        for (Map.Entry<K, V> entry : entries) {
            map.put(entry.getKey(), entry.getValue());
        }
        return Collections.unmodifiableMap(map);
    }
}

