/*
 * Decompiled with CFR 0.152.
 */
package com.github.retrooper.packetevents.resources;

import com.github.retrooper.packetevents.protocol.nbt.NBT;
import com.github.retrooper.packetevents.protocol.nbt.NBTString;
import com.github.retrooper.packetevents.protocol.util.NbtCodec;
import com.github.retrooper.packetevents.protocol.util.NbtCodecs;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.KeyPattern;
import net.kyori.adventure.key.Keyed;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class ResourceLocation
implements Keyed {
    public static final NbtCodec<ResourceLocation> CODEC = NbtCodecs.STRING.apply(ResourceLocation::new, ResourceLocation::toString);
    public static final String VANILLA_NAMESPACE = "minecraft";
    private final Key key;

    public ResourceLocation(Key key) {
        this.key = key;
    }

    public ResourceLocation(@KeyPattern.Namespace String namespace, @KeyPattern.Value String key) {
        this.key = Key.key(namespace, key);
    }

    public ResourceLocation(String location) {
        this.key = Key.key(location);
    }

    public static ResourceLocation read(PacketWrapper<?> wrapper) {
        return wrapper.readIdentifier();
    }

    public static void write(PacketWrapper<?> wrapper, ResourceLocation resourceLocation) {
        wrapper.writeIdentifier(resourceLocation);
    }

    public static ResourceLocation decode(NBT nbt, PacketWrapper<?> wrapper) {
        return new ResourceLocation(((NBTString)nbt).getValue());
    }

    public static NBT encode(PacketWrapper<?> wrapper, ResourceLocation resourceLocation) {
        return new NBTString(resourceLocation.toString());
    }

    public static String getNamespace(String location) {
        int namespaceIdx = location.indexOf(58);
        if (namespaceIdx > 0) {
            return location.substring(0, namespaceIdx);
        }
        return VANILLA_NAMESPACE;
    }

    public static String getPath(String location) {
        int namespaceIdx = location.indexOf(58);
        if (namespaceIdx != -1) {
            return location.substring(namespaceIdx + 1);
        }
        return location;
    }

    @Contract(value="null -> null; !null -> !null")
    @Nullable
    public static String normString(@Nullable String location) {
        if (location == null) {
            return null;
        }
        int index = location.indexOf(58);
        if (index > 0) {
            return location;
        }
        if (index == -1) {
            return "minecraft:" + location;
        }
        return VANILLA_NAMESPACE + location;
    }

    @Override
    public Key key() {
        return this.key;
    }

    public String getNamespace() {
        return this.key.namespace();
    }

    public String getKey() {
        return this.key.value();
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ResourceLocation) {
            ResourceLocation other = (ResourceLocation)obj;
            return other.key.equals(this.key);
        }
        return false;
    }

    public String toString() {
        return this.key.asString();
    }

    public static ResourceLocation minecraft(@KeyPattern.Value String key) {
        return new ResourceLocation(VANILLA_NAMESPACE, key);
    }
}

