/*
 * Decompiled with CFR 0.152.
 */
package com.github.retrooper.packetevents.protocol.world.painting;

import com.github.retrooper.packetevents.protocol.mapper.AbstractMappedEntity;
import com.github.retrooper.packetevents.protocol.world.painting.PaintingVariant;
import com.github.retrooper.packetevents.resources.ResourceLocation;
import com.github.retrooper.packetevents.util.mappings.TypesBuilderData;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class StaticPaintingVariant
extends AbstractMappedEntity
implements PaintingVariant {
    private final int width;
    private final int height;
    private final ResourceLocation assetId;

    public StaticPaintingVariant(int width, int height, ResourceLocation assetId) {
        this(null, width, height, assetId);
    }

    @ApiStatus.Internal
    public StaticPaintingVariant(@Nullable TypesBuilderData data, int width, int height, ResourceLocation assetId) {
        super(data);
        this.width = width;
        this.height = height;
        this.assetId = assetId;
    }

    @Override
    public PaintingVariant copy(@Nullable TypesBuilderData newData) {
        return new StaticPaintingVariant(newData, this.width, this.height, this.assetId);
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public ResourceLocation getAssetId() {
        return this.assetId;
    }

    @Override
    public boolean deepEquals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StaticPaintingVariant)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        StaticPaintingVariant that = (StaticPaintingVariant)obj;
        if (this.width != that.width) {
            return false;
        }
        if (this.height != that.height) {
            return false;
        }
        return this.assetId.equals(that.assetId);
    }

    @Override
    public int deepHashCode() {
        return Objects.hash(super.hashCode(), this.width, this.height, this.assetId);
    }

    @Override
    public String toString() {
        return "StaticPaintingVariant{width=" + this.width + ", height=" + this.height + ", assetId=" + this.assetId + '}';
    }
}

