/*
 * Decompiled with CFR 0.152.
 */
package com.github.retrooper.packetevents.protocol.world.chunk.palette;

import com.github.retrooper.packetevents.protocol.stream.NetStreamInput;
import com.github.retrooper.packetevents.protocol.world.chunk.palette.Palette;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import java.util.Arrays;

public class ListPalette
implements Palette {
    private final int bits;
    private final int[] data;
    private int nextId;

    public ListPalette(int bitsPerEntry) {
        this.bits = bitsPerEntry;
        this.data = new int[1 << bitsPerEntry];
        this.nextId = 0;
    }

    @Deprecated
    public ListPalette(int bitsPerEntry, NetStreamInput in) {
        this(bitsPerEntry);
        int paletteLength = in.readVarInt();
        for (int i = 0; i < paletteLength; ++i) {
            this.data[i] = in.readVarInt();
        }
        this.nextId = paletteLength;
    }

    public ListPalette(int bitsPerEntry, PacketWrapper<?> wrapper) {
        this(bitsPerEntry);
        int paletteLength = wrapper.readVarInt();
        for (int i = 0; i < paletteLength; ++i) {
            this.data[i] = wrapper.readVarInt();
        }
        this.nextId = paletteLength;
    }

    public ListPalette(int bitsPerEntry, int[] data) {
        this.bits = bitsPerEntry;
        int expectedSize = 1 << this.bits;
        if (data.length > expectedSize) {
            throw new IllegalArgumentException("Data length exceeds the max size the bits can hold");
        }
        this.data = Arrays.copyOf(data, expectedSize);
        this.nextId = data.length;
    }

    @Override
    public int size() {
        return this.nextId;
    }

    @Override
    public int stateToId(int state) {
        int id = -1;
        for (int i = 0; i < this.nextId; ++i) {
            if (this.data[i] != state) continue;
            id = i;
            break;
        }
        if (id == -1 && this.size() < this.data.length) {
            id = this.nextId++;
            this.data[id] = state;
        }
        return id;
    }

    @Override
    public int idToState(int id) {
        if (id >= 0 && id < this.size()) {
            return this.data[id];
        }
        return 0;
    }

    @Override
    public int getBits() {
        return this.bits;
    }
}

