/*
 * Decompiled with CFR 0.152.
 */
package com.github.retrooper.packetevents.protocol.world.biome;

import com.github.retrooper.packetevents.protocol.mapper.AbstractMappedEntity;
import com.github.retrooper.packetevents.protocol.world.attributes.EnvironmentAttributeMap;
import com.github.retrooper.packetevents.protocol.world.biome.Biome;
import com.github.retrooper.packetevents.protocol.world.biome.BiomeEffects;
import com.github.retrooper.packetevents.util.mappings.TypesBuilderData;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class StaticBiome
extends AbstractMappedEntity
implements Biome {
    private final boolean precipitation;
    private final float temperature;
    private final Biome.TemperatureModifier temperatureModifier;
    private final float downfall;
    @Nullable
    private final Biome.Category category;
    @Nullable
    private final Float depth;
    @Nullable
    private final Float scale;
    private final BiomeEffects effects;
    private final EnvironmentAttributeMap attributes;

    public StaticBiome(boolean precipitation, float temperature, Biome.TemperatureModifier temperatureModifier, float downfall, BiomeEffects effects, EnvironmentAttributeMap attributes) {
        this(null, precipitation, temperature, temperatureModifier, downfall, null, null, null, effects, attributes);
    }

    public StaticBiome(boolean precipitation, float temperature, Biome.TemperatureModifier temperatureModifier, float downfall, BiomeEffects effects) {
        this(precipitation, temperature, temperatureModifier, downfall, effects, EnvironmentAttributeMap.EMPTY);
    }

    public StaticBiome(boolean precipitation, float temperature, Biome.TemperatureModifier temperatureModifier, float downfall, @Nullable Biome.Category category, @Nullable Float depth, @Nullable Float scale, BiomeEffects effects) {
        this(null, precipitation, temperature, temperatureModifier, downfall, category, depth, scale, effects, EnvironmentAttributeMap.EMPTY);
    }

    @ApiStatus.Internal
    public StaticBiome(@Nullable TypesBuilderData data, boolean precipitation, float temperature, Biome.TemperatureModifier temperatureModifier, float downfall, @Nullable Biome.Category category, @Nullable Float depth, @Nullable Float scale, BiomeEffects effects, EnvironmentAttributeMap attributes) {
        super(data);
        this.precipitation = precipitation;
        this.temperature = temperature;
        this.temperatureModifier = temperatureModifier;
        this.downfall = downfall;
        this.category = category;
        this.depth = depth;
        this.scale = scale;
        this.effects = effects;
        this.attributes = attributes;
    }

    @Override
    public Biome copy(@Nullable TypesBuilderData newData) {
        return new StaticBiome(newData, this.precipitation, this.temperature, this.temperatureModifier, this.downfall, this.category, this.depth, this.scale, this.effects, this.attributes);
    }

    @Override
    public boolean hasPrecipitation() {
        return this.precipitation;
    }

    @Override
    public Biome.Precipitation getPrecipitation() {
        if (!this.hasPrecipitation()) {
            return Biome.Precipitation.NONE;
        }
        switch (this.getTemperatureModifier()) {
            case NONE: {
                return Biome.Precipitation.RAIN;
            }
            case FROZEN: {
                return Biome.Precipitation.SNOW;
            }
        }
        throw new AssertionError();
    }

    @Override
    public float getTemperature() {
        return this.temperature;
    }

    @Override
    public Biome.TemperatureModifier getTemperatureModifier() {
        return this.temperatureModifier;
    }

    @Override
    public float getDownfall() {
        return this.downfall;
    }

    @Override
    @Nullable
    public Biome.Category getCategory() {
        return this.category;
    }

    @Override
    @Nullable
    public Float getDepth() {
        return this.depth;
    }

    @Override
    @Nullable
    public Float getScale() {
        return this.scale;
    }

    @Override
    public BiomeEffects getEffects() {
        return this.effects;
    }

    @Override
    public EnvironmentAttributeMap getAttributes() {
        return this.attributes;
    }

    @Override
    public boolean deepEquals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StaticBiome)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        StaticBiome that = (StaticBiome)obj;
        if (this.precipitation != that.precipitation) {
            return false;
        }
        if (Float.compare(that.temperature, this.temperature) != 0) {
            return false;
        }
        if (Float.compare(that.downfall, this.downfall) != 0) {
            return false;
        }
        if (this.temperatureModifier != that.temperatureModifier) {
            return false;
        }
        if (this.category != that.category) {
            return false;
        }
        if (!Objects.equals(this.depth, that.depth)) {
            return false;
        }
        if (!Objects.equals(this.scale, that.scale)) {
            return false;
        }
        if (!this.effects.equals(that.effects)) {
            return false;
        }
        return this.attributes.equals(that.attributes);
    }

    @Override
    public int deepHashCode() {
        return Objects.hash(super.hashCode(), this.precipitation, Float.valueOf(this.temperature), this.temperatureModifier, Float.valueOf(this.downfall), this.category, this.depth, this.scale, this.effects, this.attributes);
    }

    @Override
    public String toString() {
        return "StaticBiome{precipitation=" + this.precipitation + ", temperature=" + this.temperature + ", temperatureModifier=" + this.temperatureModifier + ", downfall=" + this.downfall + ", category=" + this.category + ", depth=" + this.depth + ", scale=" + this.scale + ", effects=" + this.effects + ", attributes=" + this.attributes + '}';
    }
}

