/*
 * Decompiled with CFR 0.152.
 */
package com.github.retrooper.packetevents.protocol.world.attributes.timelines;

import com.github.retrooper.packetevents.protocol.mapper.CopyableEntity;
import com.github.retrooper.packetevents.protocol.mapper.DeepComparableEntity;
import com.github.retrooper.packetevents.protocol.mapper.MappedEntity;
import com.github.retrooper.packetevents.protocol.nbt.NBTCompound;
import com.github.retrooper.packetevents.protocol.nbt.NBTInt;
import com.github.retrooper.packetevents.protocol.util.NbtCodec;
import com.github.retrooper.packetevents.protocol.util.NbtCodecException;
import com.github.retrooper.packetevents.protocol.util.NbtCodecs;
import com.github.retrooper.packetevents.protocol.util.NbtMapCodec;
import com.github.retrooper.packetevents.protocol.world.attributes.EnvironmentAttribute;
import com.github.retrooper.packetevents.protocol.world.attributes.EnvironmentAttributes;
import com.github.retrooper.packetevents.protocol.world.attributes.timelines.StaticTimeline;
import com.github.retrooper.packetevents.protocol.world.attributes.timelines.TimelineTrack;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import java.util.Collections;
import java.util.Map;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public interface Timeline
extends MappedEntity,
CopyableEntity<Timeline>,
DeepComparableEntity {
    public static final NbtCodec<Map<EnvironmentAttribute<?>, TimelineTrack<?, ?>>> TRACK_CODEC = NbtMapCodec.codecOfMap(NbtCodecs.forRegistry(EnvironmentAttributes.getRegistry()), TimelineTrack::codec).codec();
    public static final NbtCodec<Timeline> CODEC = new NbtMapCodec<Timeline>(){

        @Override
        public Timeline decode(NBTCompound compound, PacketWrapper<?> wrapper) throws NbtCodecException {
            Integer periodTicks = compound.getOrNull("period_ticks", NbtCodecs.INT, wrapper);
            Map<EnvironmentAttribute<?>, TimelineTrack<?, ?>> tracks = compound.getOr("tracks", TRACK_CODEC, Collections.emptyMap(), wrapper);
            return new StaticTimeline(periodTicks, tracks);
        }

        @Override
        public void encode(NBTCompound compound, PacketWrapper<?> wrapper, Timeline value) throws NbtCodecException {
            Map<EnvironmentAttribute<?>, TimelineTrack<?, ?>> tracks;
            Integer periodTicks = value.getPeriodTicks();
            if (periodTicks != null) {
                compound.setTag("period_ticks", new NBTInt(periodTicks));
            }
            if (!(tracks = value.getTracks()).isEmpty()) {
                compound.set("tracks", tracks, TRACK_CODEC, wrapper);
            }
        }
    }.codec();

    public @Nullable Integer getPeriodTicks();

    public Map<EnvironmentAttribute<?>, TimelineTrack<?, ?>> getTracks();
}

