/*
 * Decompiled with CFR 0.152.
 */
package com.github.retrooper.packetevents.protocol.world.attributes.modifiers;

import com.github.retrooper.packetevents.protocol.util.NbtCodec;
import com.github.retrooper.packetevents.protocol.util.NbtCodecs;
import com.github.retrooper.packetevents.protocol.world.attributes.EnvironmentAttribute;
import com.github.retrooper.packetevents.protocol.world.attributes.modifiers.AttributeModifier;
import com.github.retrooper.packetevents.util.AlphaFloat;
import com.github.retrooper.packetevents.util.MathUtil;
import org.jspecify.annotations.NullMarked;

@NullMarked
public interface FloatModifier<A>
extends AttributeModifier<Float, A> {
    public static final FloatModifier<AlphaFloat> ALPHA_BLEND = new FloatModifier<AlphaFloat>(){

        @Override
        public Float apply(Float value, AlphaFloat arg) {
            return Float.valueOf(MathUtil.lerp(arg.getAlpha(), value.floatValue(), arg.getValue()));
        }

        @Override
        public NbtCodec<AlphaFloat> argumentCodec(EnvironmentAttribute<Float> attribute) {
            return AlphaFloat.CODEC;
        }
    };
    public static final FloatModifier<Float> ADD = Float::sum;
    public static final FloatModifier<Float> SUBTRACT = (a, b) -> Float.valueOf(a.floatValue() - b.floatValue());
    public static final FloatModifier<Float> MULTIPLY = (a, b) -> Float.valueOf(a.floatValue() * b.floatValue());
    public static final FloatModifier<Float> MINIMUM = Math::min;
    public static final FloatModifier<Float> MAXIMUM = Math::max;

    @FunctionalInterface
    public static interface Simple
    extends FloatModifier<Float> {
        @Override
        default public NbtCodec<Float> argumentCodec(EnvironmentAttribute<Float> attribute) {
            return NbtCodecs.FLOAT;
        }
    }
}

