/*
 * Decompiled with CFR 0.152.
 */
package com.github.retrooper.packetevents.protocol.world.attributes;

import com.github.retrooper.packetevents.protocol.nbt.NBTCompound;
import com.github.retrooper.packetevents.protocol.util.NbtCodec;
import com.github.retrooper.packetevents.protocol.util.NbtCodecException;
import com.github.retrooper.packetevents.protocol.util.NbtMapCodec;
import com.github.retrooper.packetevents.protocol.world.biome.BiomeEffects;
import com.github.retrooper.packetevents.util.RandomWeightedList;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import java.util.ArrayList;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class BackgroundMusic {
    public static final NbtCodec<BackgroundMusic> CODEC = new NbtMapCodec<BackgroundMusic>(){

        @Override
        public BackgroundMusic decode(NBTCompound compound, PacketWrapper<?> wrapper) throws NbtCodecException {
            BiomeEffects.MusicSettings defaultt = compound.getOrNull("default", BiomeEffects.MusicSettings.CODEC, wrapper);
            BiomeEffects.MusicSettings creative = compound.getOrNull("creative", BiomeEffects.MusicSettings.CODEC, wrapper);
            BiomeEffects.MusicSettings underwater = compound.getOrNull("underwater", BiomeEffects.MusicSettings.CODEC, wrapper);
            return new BackgroundMusic(defaultt, creative, underwater);
        }

        @Override
        public void encode(NBTCompound compound, PacketWrapper<?> wrapper, BackgroundMusic value) throws NbtCodecException {
            if (value.defaultMusic != null) {
                compound.set("default", value.defaultMusic, BiomeEffects.MusicSettings.CODEC, wrapper);
            }
            if (value.creativeMusic != null) {
                compound.set("creative", value.creativeMusic, BiomeEffects.MusicSettings.CODEC, wrapper);
            }
            if (value.underwaterMusic != null) {
                compound.set("underwater", value.underwaterMusic, BiomeEffects.MusicSettings.CODEC, wrapper);
            }
        }
    }.codec();
    public static final BackgroundMusic EMPTY = new BackgroundMusic(null, null, null);
    private final  @Nullable BiomeEffects.MusicSettings defaultMusic;
    private final  @Nullable BiomeEffects.MusicSettings creativeMusic;
    private final  @Nullable BiomeEffects.MusicSettings underwaterMusic;

    public BackgroundMusic( @Nullable BiomeEffects.MusicSettings defaultMusic,  @Nullable BiomeEffects.MusicSettings creativeMusic,  @Nullable BiomeEffects.MusicSettings underwaterMusic) {
        this.defaultMusic = defaultMusic;
        this.creativeMusic = creativeMusic;
        this.underwaterMusic = underwaterMusic;
    }

    @ApiStatus.Internal
    public RandomWeightedList<BiomeEffects.MusicSettings> asList() {
        ArrayList list = new ArrayList(3);
        if (this.defaultMusic != null) {
            list.add(new RandomWeightedList.Entry<BiomeEffects.MusicSettings>(this.defaultMusic, 0));
        }
        if (this.creativeMusic != null) {
            list.add(new RandomWeightedList.Entry<BiomeEffects.MusicSettings>(this.creativeMusic, 0));
        }
        if (this.underwaterMusic != null) {
            list.add(new RandomWeightedList.Entry<BiomeEffects.MusicSettings>(this.underwaterMusic, 0));
        }
        return new RandomWeightedList<BiomeEffects.MusicSettings>(list);
    }

    public  @Nullable BiomeEffects.MusicSettings getDefaultMusic() {
        return this.defaultMusic;
    }

    public  @Nullable BiomeEffects.MusicSettings getCreativeMusic() {
        return this.creativeMusic;
    }

    public  @Nullable BiomeEffects.MusicSettings getUnderwaterMusic() {
        return this.underwaterMusic;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BackgroundMusic)) {
            return false;
        }
        BackgroundMusic that = (BackgroundMusic)obj;
        if (!Objects.equals(this.defaultMusic, that.defaultMusic)) {
            return false;
        }
        if (!Objects.equals(this.creativeMusic, that.creativeMusic)) {
            return false;
        }
        return Objects.equals(this.underwaterMusic, that.underwaterMusic);
    }

    public int hashCode() {
        return Objects.hash(this.defaultMusic, this.creativeMusic, this.underwaterMusic);
    }
}

