/*
 * Decompiled with CFR 0.152.
 */
package com.github.retrooper.packetevents.protocol.util;

import com.github.retrooper.packetevents.protocol.nbt.NBT;
import com.github.retrooper.packetevents.protocol.nbt.NBTCompound;
import com.github.retrooper.packetevents.protocol.nbt.NBTString;
import com.github.retrooper.packetevents.protocol.util.NbtCodec;
import com.github.retrooper.packetevents.protocol.util.NbtCodecException;
import com.github.retrooper.packetevents.protocol.util.NbtMapDecoder;
import com.github.retrooper.packetevents.protocol.util.NbtMapEncoder;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.jspecify.annotations.NullMarked;

@NullMarked
public interface NbtMapCodec<T>
extends NbtMapEncoder<T>,
NbtMapDecoder<T> {
    public static <K, V> NbtMapCodec<Map<K, V>> codecOfMap(final NbtCodec<K> keyCodec, final Function<K, NbtCodec<? extends V>> valueCodec) {
        return new NbtMapCodec<Map<K, V>>(){

            @Override
            public Map<K, V> decode(NBTCompound compound, PacketWrapper<?> wrapper) throws NbtCodecException {
                HashMap map = new HashMap(compound.size());
                for (Map.Entry<String, NBT> entry : compound.getTags().entrySet()) {
                    Object key = keyCodec.decode(new NBTString(entry.getKey()), wrapper);
                    Object value = ((NbtCodec)valueCodec.apply(key)).decode(entry.getValue(), wrapper);
                    map.put(key, value);
                }
                return Collections.unmodifiableMap(map);
            }

            @Override
            public void encode(NBTCompound compound, PacketWrapper<?> wrapper, Map<K, V> value) throws NbtCodecException {
                for (Map.Entry entry : value.entrySet()) {
                    String name = keyCodec.encode(wrapper, entry.getKey()).castOrThrow(NBTString.class).getValue();
                    NbtCodec codec = (NbtCodec)valueCodec.apply(entry.getKey());
                    NBT tag = codec.encode(wrapper, entry.getValue());
                    compound.setTag(name, tag);
                }
            }
        };
    }

    default public NbtCodec<T> codec() {
        return new NbtCodec<T>(){

            @Override
            public T decode(NBT nbt, PacketWrapper<?> wrapper) throws NbtCodecException {
                NBTCompound compound = nbt.castOrThrow(NBTCompound.class);
                return NbtMapCodec.this.decode(compound, wrapper);
            }

            @Override
            public NBT encode(PacketWrapper<?> wrapper, T value) throws NbtCodecException {
                NBTCompound compound = new NBTCompound();
                NbtMapCodec.this.encode(compound, wrapper, value);
                return compound;
            }
        };
    }

    default public <Z> NbtMapCodec<Z> apply(final Function<T, Z> forward, final Function<Z, T> back) {
        return new NbtMapCodec<Z>(){

            @Override
            public Z decode(NBTCompound compound, PacketWrapper<?> wrapper) throws NbtCodecException {
                return forward.apply(NbtMapCodec.this.decode(compound, wrapper));
            }

            @Override
            public void encode(NBTCompound compound, PacketWrapper<?> wrapper, Z value) throws NbtCodecException {
                NbtMapCodec.this.encode(compound, wrapper, back.apply(value));
            }
        };
    }
}

