/*
 * Decompiled with CFR 0.152.
 */
package com.github.retrooper.packetevents.protocol.util;

import com.github.retrooper.packetevents.protocol.nbt.NBT;
import com.github.retrooper.packetevents.protocol.util.NbtCodecException;
import com.github.retrooper.packetevents.protocol.util.NbtCodecs;
import com.github.retrooper.packetevents.protocol.util.NbtDecoder;
import com.github.retrooper.packetevents.protocol.util.NbtEncoder;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jspecify.annotations.NullMarked;

@NullMarked
public interface NbtCodec<T>
extends NbtEncoder<T>,
NbtDecoder<T> {
    public static <T> NbtCodec<T> codec(final NbtEncoder<T> encoder, final NbtDecoder<T> decoder) {
        return new NbtCodec<T>(){

            @Override
            public T decode(NBT nbt, PacketWrapper<?> wrapper) {
                return decoder.decode(nbt, wrapper);
            }

            @Override
            public NBT encode(PacketWrapper<?> wrapper, T value) {
                return encoder.encode(wrapper, value);
            }
        };
    }

    default public NbtCodec<T> validate(final Predicate<T> predicate) {
        return new NbtCodec<T>(){

            @Override
            public T decode(NBT nbt, PacketWrapper<?> wrapper) throws NbtCodecException {
                Object val = NbtCodec.this.decode(nbt, wrapper);
                if (!predicate.test(val)) {
                    throw new NbtCodecException("Decode predicate failed " + predicate);
                }
                return val;
            }

            @Override
            public NBT encode(PacketWrapper<?> wrapper, T value) throws NbtCodecException {
                if (!predicate.test(value)) {
                    throw new NbtCodecException("Encode predicate failed " + predicate);
                }
                return NbtCodec.this.encode(wrapper, value);
            }
        };
    }

    default public <Z> NbtCodec<Z> apply(final Function<T, Z> forward, final Function<Z, T> back) {
        return new NbtCodec<Z>(){

            @Override
            public Z decode(NBT nbt, PacketWrapper<?> wrapper) {
                return forward.apply(NbtCodec.this.decode(nbt, wrapper));
            }

            @Override
            public NBT encode(PacketWrapper<?> wrapper, Z value) {
                return NbtCodec.this.encode(wrapper, back.apply(value));
            }
        };
    }

    default public NbtCodec<List<T>> applyList() {
        return new NbtCodec<List<T>>(){

            @Override
            public List<T> decode(NBT nbt, PacketWrapper<?> wrapper) throws NbtCodecException {
                try {
                    List list = (List)NbtCodecs.GENERIC_LIST.decode(nbt, wrapper);
                    ArrayList ret = new ArrayList(list.size());
                    for (NBT tag : list) {
                        ret.add(NbtCodec.this.decode(tag, wrapper));
                    }
                    return ret;
                }
                catch (NbtCodecException leftException) {
                    try {
                        Object element = NbtCodec.this.decode(nbt, wrapper);
                        return Collections.singletonList(element);
                    }
                    catch (NbtCodecException rightException) {
                        leftException.addSuppressed(rightException);
                        throw leftException;
                    }
                }
            }

            @Override
            public NBT encode(PacketWrapper<?> wrapper, List<T> value) {
                ArrayList<NBT> list = new ArrayList<NBT>(value.size());
                for (Object ele : value) {
                    list.add(NbtCodec.this.encode(wrapper, ele));
                }
                return NbtCodecs.GENERIC_LIST.encode(wrapper, list);
            }
        };
    }
}

