/*
 * Decompiled with CFR 0.152.
 */
package com.github.retrooper.packetevents.protocol.sound;

import com.github.retrooper.packetevents.protocol.mapper.MappedEntity;
import com.github.retrooper.packetevents.protocol.nbt.NBT;
import com.github.retrooper.packetevents.protocol.nbt.NBTCompound;
import com.github.retrooper.packetevents.protocol.nbt.NBTString;
import com.github.retrooper.packetevents.protocol.player.ClientVersion;
import com.github.retrooper.packetevents.protocol.sound.Sounds;
import com.github.retrooper.packetevents.protocol.sound.StaticSound;
import com.github.retrooper.packetevents.protocol.util.NbtCodec;
import com.github.retrooper.packetevents.protocol.util.NbtCodecs;
import com.github.retrooper.packetevents.resources.ResourceLocation;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import org.jetbrains.annotations.Nullable;
import org.jspecify.annotations.NullMarked;

@NullMarked
public interface Sound
extends MappedEntity {
    public static final NbtCodec<Sound> CODEC = new NbtCodec<Sound>(){

        @Override
        public Sound decode(NBT nbt, PacketWrapper<?> wrapper) {
            if (nbt instanceof NBTString) {
                return Sounds.getByNameOrCreate(((NBTString)nbt).getValue());
            }
            NBTCompound compound = nbt.castOrThrow(NBTCompound.class);
            ResourceLocation soundId = compound.getOrThrow("sound_id", ResourceLocation.CODEC, wrapper);
            Float range = compound.getOrNull("range", NbtCodecs.FLOAT, wrapper);
            return new StaticSound(soundId, range);
        }

        @Override
        public NBT encode(PacketWrapper<?> wrapper, Sound value) {
            if (value.isRegistered()) {
                return new NBTString(value.getName().toString());
            }
            NBTCompound compound = new NBTCompound();
            compound.set("sound_id", value.getSoundId(), ResourceLocation.CODEC, wrapper);
            if (value.getRange() != null) {
                compound.set("range", value.getRange(), NbtCodecs.FLOAT, wrapper);
            }
            return compound;
        }
    };

    public ResourceLocation getSoundId();

    @Nullable
    public Float getRange();

    public static Sound read(PacketWrapper<?> wrapper) {
        return wrapper.readMappedEntityOrDirect(Sounds::getById, Sound::readDirect);
    }

    public static Sound readDirect(PacketWrapper<?> wrapper) {
        ResourceLocation soundId = wrapper.readIdentifier();
        Float range = (Float)wrapper.readOptional(PacketWrapper::readFloat);
        return new StaticSound(soundId, range);
    }

    public static void write(PacketWrapper<?> wrapper, Sound sound) {
        wrapper.writeMappedEntityOrDirect(sound, Sound::writeDirect);
    }

    public static void writeDirect(PacketWrapper<?> wrapper, Sound sound) {
        wrapper.writeIdentifier(sound.getSoundId());
        wrapper.writeOptional(sound.getRange(), PacketWrapper::writeFloat);
    }

    @Deprecated
    public static Sound decode(NBT nbt, ClientVersion version) {
        return Sound.decode(nbt, PacketWrapper.createDummyWrapper(version));
    }

    @Deprecated
    public static Sound decode(NBT nbt, PacketWrapper<?> wrapper) {
        return (Sound)CODEC.decode(nbt, wrapper);
    }

    @Deprecated
    public static NBT encode(Sound sound, ClientVersion version) {
        return Sound.encode(PacketWrapper.createDummyWrapper(version), sound);
    }

    @Deprecated
    public static NBT encode(PacketWrapper<?> wrapper, Sound sound) {
        return CODEC.encode(wrapper, sound);
    }
}

