/*
 * Decompiled with CFR 0.152.
 */
package me.chancesd.pvpmanager.sdutils.display;

import com.google.common.base.Strings;
import me.chancesd.pvpmanager.sdutils.utils.Utils;

public class ProgressBar {
    private final int totalBars;
    private final String symbol;
    private final String originalMessage;
    private String message;
    private long goal;
    private long progress;
    private boolean dirty = true;

    public ProgressBar(String message, int totalBars, long goal, String symbol) {
        this.originalMessage = message;
        this.totalBars = totalBars;
        this.goal = goal;
        this.symbol = symbol;
    }

    public ProgressBar(String message, int totalBars, long goal, String symbol, long millisecondsPassed) {
        this(message, totalBars, goal, symbol);
        this.setProgress(millisecondsPassed);
        this.calculate();
    }

    public ProgressBar setProgress(long progress) {
        if (this.progress == progress) {
            return this;
        }
        this.progress = progress;
        this.dirty = true;
        return this;
    }

    public ProgressBar setGoal(long goal) {
        if (this.goal == goal) {
            return this;
        }
        this.goal = goal;
        this.dirty = true;
        return this;
    }

    public ProgressBar calculate() {
        if (!this.dirty) {
            return this;
        }
        double percent = (double)this.progress / (double)this.goal;
        int progressBars = (int)((double)this.totalBars * percent);
        this.message = this.originalMessage.replace("<barsLeft>", Strings.repeat((String)this.symbol, (int)(this.totalBars - progressBars))).replace("<barsPassed>", Strings.repeat((String)this.symbol, (int)progressBars)).replace("<time>", Double.toString(Utils.roundTo1Decimal((double)(this.goal - this.progress) / 1000.0)));
        this.dirty = false;
        return this;
    }

    public long getProgress() {
        return this.progress;
    }

    public String getMessage() {
        return this.message;
    }

    public int getTotalBars() {
        return this.totalBars;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public long getGoal() {
        return this.goal;
    }

    public String toString() {
        return this.message;
    }
}

