/*
 * Decompiled with CFR 0.152.
 */
package me.chancesd.pvpmanager.sdutils.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.UnaryOperator;
import me.chancesd.pvpmanager.sdutils.command.ArgumentLoader;
import me.chancesd.pvpmanager.sdutils.command.ArgumentType;
import me.chancesd.pvpmanager.sdutils.command.BaseCommand;
import me.chancesd.pvpmanager.sdutils.command.CommandArgument;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.generator.WorldInfo;

public class ArgumentInfo {
    private static UnaryOperator<String> playerNotFoundMessageProvider = playerName -> "\u00a7cPlayer not found: \u00a7e" + playerName;
    private final String name;
    private final ArgumentType type;
    private final ArgumentLoader<?> loader;
    private boolean required = false;
    private String defValue = null;
    private String perm = null;
    private List<String> customTabCompletions = null;
    private String dependsOn = null;
    private final BaseCommand parent;

    public ArgumentInfo(String name, ArgumentType type, BaseCommand parent) {
        this.name = name;
        this.type = type;
        this.loader = BaseCommand.getDefaultLoader(type);
        this.parent = parent;
    }

    public ArgumentInfo(String name, ArgumentType type, ArgumentLoader<?> loader, BaseCommand parent) {
        this.name = name;
        this.type = type;
        this.loader = loader;
        this.parent = parent;
    }

    public ArgumentInfo required() {
        this.required = true;
        return this;
    }

    public ArgumentInfo defaultValue(String defaultValue) {
        this.defValue = defaultValue;
        return this;
    }

    public ArgumentInfo requirePermission(String permission) {
        this.perm = permission;
        return this;
    }

    public ArgumentInfo tabComplete(String ... completions) {
        this.customTabCompletions = Arrays.asList(completions);
        return this;
    }

    public ArgumentInfo tabComplete(List<String> completions) {
        this.customTabCompletions = new ArrayList<String>(completions);
        return this;
    }

    public ArgumentInfo dependsOn(String argumentName) {
        this.dependsOn = argumentName;
        return this;
    }

    public BaseCommand endArgument() {
        if (this.parent != null) {
            this.parent.addArgumentInfo(this);
        }
        return this.parent;
    }

    public static void setPlayerNotFoundMessageProvider(UnaryOperator<String> provider) {
        playerNotFoundMessageProvider = provider;
    }

    public String getName() {
        return this.name;
    }

    public ArgumentType getType() {
        return this.type;
    }

    public boolean isRequired() {
        return this.required;
    }

    public String getDefaultValue() {
        return this.defValue;
    }

    public boolean hasPermission() {
        return this.perm != null && !this.perm.isEmpty();
    }

    public String getPermission() {
        return this.perm;
    }

    public String getDependsOn() {
        return this.dependsOn;
    }

    public boolean hasDependency() {
        return this.dependsOn != null && !this.dependsOn.isEmpty();
    }

    public boolean hasLoader() {
        return this.loader != null;
    }

    public ArgumentLoader<?> getLoader() {
        return this.loader;
    }

    public boolean isValid(CommandArgument argument) {
        try {
            if (this.type == ArgumentType.PLAYER) {
                return argument.getAsPlayer() != null;
            }
            if (this.type == ArgumentType.PLAYER_OR_ALL) {
                return argument.isWildcard() || argument.getAsPlayerOrWildcard() != null;
            }
            if (this.type == ArgumentType.INTEGER) {
                argument.getAsInt();
                return true;
            }
            if (this.type == ArgumentType.DOUBLE) {
                argument.getAsDouble();
                return true;
            }
            if (this.type == ArgumentType.BOOLEAN) {
                argument.getAsBoolean();
                return true;
            }
            if (this.type == ArgumentType.WORLD) {
                argument.getAsWorld();
                return true;
            }
            if (this.type == ArgumentType.MATERIAL) {
                argument.getAsMaterial();
                return true;
            }
            if (this.type == ArgumentType.DURATION) {
                argument.getAsDuration();
                return true;
            }
            if (this.type == ArgumentType.STRING || this.type == ArgumentType.STRING_ARRAY) {
                return true;
            }
            if (this.type.isEnumType()) {
                String value = argument.getValue().toUpperCase();
                Class<Enum<?>> enumClass = this.type.getEnumClass();
                for (Enum<?> constant : enumClass.getEnumConstants()) {
                    if (!constant.name().equalsIgnoreCase(value)) continue;
                    return true;
                }
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getValidationErrorMessage(CommandArgument argument) {
        if (this.type == ArgumentType.PLAYER) {
            return (String)playerNotFoundMessageProvider.apply(argument.getValue());
        }
        if (this.type == ArgumentType.PLAYER_OR_ALL) {
            return (String)playerNotFoundMessageProvider.apply(argument.getValue());
        }
        if (this.type == ArgumentType.INTEGER || this.type == ArgumentType.DOUBLE) {
            return "\u00a7c'\u00a77" + argument.getValue() + "\u00a7c' is not a valid number.";
        }
        if (this.type == ArgumentType.BOOLEAN) {
            return "\u00a7c'" + argument.getValue() + "' is not a valid boolean (true/false).";
        }
        if (this.type == ArgumentType.WORLD) {
            return "\u00a7c'" + argument.getValue() + "' is not a valid world name.";
        }
        if (this.type == ArgumentType.MATERIAL) {
            return "\u00a7c'" + argument.getValue() + "' is not a valid material name.";
        }
        if (this.type == ArgumentType.DURATION) {
            return "\u00a7c'" + argument.getValue() + "' is not a valid duration. Use formats like '30s', '5m', '2h', '1d'.";
        }
        if (this.type == ArgumentType.STRING || this.type == ArgumentType.STRING_ARRAY) {
            return "\u00a7c'" + argument.getValue() + "' is not valid for " + this.name + ".";
        }
        if (this.type.isEnumType()) {
            StringBuilder options = new StringBuilder();
            Enum<?>[] constants = this.type.getEnumClass().getEnumConstants();
            for (int i = 0; i < constants.length; ++i) {
                if (i > 0) {
                    options.append("&8, ");
                }
                options.append("&e").append(constants[i].name());
            }
            return "#FF5555Invalid " + this.type.getEnumClass().getSimpleName() + ". &7Available options are: &e" + String.valueOf(options);
        }
        return "\u00a7c'" + argument.getValue() + "' is not valid for " + this.name + ".";
    }

    public List<String> getTabCompletions(String partial) {
        if (this.customTabCompletions != null && !this.customTabCompletions.isEmpty()) {
            return ArgumentInfo.getMatchingEntries(partial, this.customTabCompletions);
        }
        if (this.type.hasTabCompletions()) {
            return ArgumentInfo.getMatchingEntries(partial, this.type.getTabCompletions().get());
        }
        if (this.type == ArgumentType.PLAYER || this.type == ArgumentType.OFFLINE_PLAYER) {
            List<String> playerNames = Bukkit.getOnlinePlayers().stream().map(Player::getName).toList();
            return ArgumentInfo.getMatchingEntries(partial, playerNames);
        }
        if (this.type == ArgumentType.PLAYER_OR_ALL) {
            ArrayList<String> completions = new ArrayList<String>();
            completions.add("*");
            completions.addAll(Bukkit.getOnlinePlayers().stream().map(Player::getName).toList());
            return ArgumentInfo.getMatchingEntries(partial, completions);
        }
        if (this.type == ArgumentType.WORLD) {
            List<String> worldNames = Bukkit.getWorlds().stream().map(WorldInfo::getName).toList();
            return ArgumentInfo.getMatchingEntries(partial, worldNames);
        }
        if (this.type == ArgumentType.MATERIAL) {
            List<String> materialNames = Arrays.stream(Material.values()).map(Enum::name).map(String::toLowerCase).toList();
            return ArgumentInfo.getMatchingEntries(partial, materialNames);
        }
        if (this.type == ArgumentType.DURATION) {
            return ArgumentInfo.getMatchingEntries(partial, Arrays.asList("30s", "5m", "1h", "1d", "1h30m"));
        }
        if (this.type == ArgumentType.BOOLEAN) {
            return ArgumentInfo.getMatchingEntries(partial, Arrays.asList("true", "false"));
        }
        if (this.type == ArgumentType.STRING || this.type == ArgumentType.STRING_ARRAY) {
            return ArgumentInfo.getMatchingEntries(partial, Arrays.asList(this.name));
        }
        return new ArrayList<String>();
    }

    private static List<String> getMatchingEntries(String token, List<String> toFilter) {
        return toFilter.stream().filter(s -> s.toLowerCase().contains(token.toLowerCase())).toList();
    }
}

