/*
 * Decompiled with CFR 0.152.
 */
package me.chancesd.pvpmanager.manager;

import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import me.chancesd.pvpmanager.PvPManager;
import me.chancesd.pvpmanager.event.PlayerCombatLogEvent;
import me.chancesd.pvpmanager.manager.ConfigManager;
import me.chancesd.pvpmanager.manager.DependencyManager;
import me.chancesd.pvpmanager.player.CombatPlayer;
import me.chancesd.pvpmanager.player.PlayerData;
import me.chancesd.pvpmanager.player.ProtectionResult;
import me.chancesd.pvpmanager.player.ProtectionType;
import me.chancesd.pvpmanager.player.UntagReason;
import me.chancesd.pvpmanager.sdutils.scheduler.ScheduleUtils;
import me.chancesd.pvpmanager.sdutils.utils.Log;
import me.chancesd.pvpmanager.sdutils.utils.MCVersion;
import me.chancesd.pvpmanager.setting.Conf;
import me.chancesd.pvpmanager.tasks.CleanKillersTask;
import me.chancesd.pvpmanager.tasks.PvPToggleFeeTask;
import me.chancesd.pvpmanager.tasks.TagTask;
import me.chancesd.pvpmanager.utils.CombatUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.damage.DamageSource;
import org.bukkit.damage.DamageType;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.ScoreboardManager;
import org.bukkit.scoreboard.Team;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerManager {
    private final Map<UUID, CombatPlayer> players = new ConcurrentHashMap<UUID, CombatPlayer>();
    private final ConfigManager configManager;
    private final DependencyManager dependencyManager;
    private final PvPManager plugin;
    private final TagTask tagTask;
    private boolean globalStatus = true;

    public PlayerManager(@NotNull PvPManager plugin) {
        this.plugin = plugin;
        this.configManager = plugin.getConfigM();
        this.dependencyManager = plugin.getDependencyManager();
        this.tagTask = new TagTask(plugin.getDisplayManager());
        Bukkit.getPluginManager().registerEvents((Listener)this.tagTask, (Plugin)plugin);
        if (Conf.KILL_ABUSE_ENABLED.asBool()) {
            ScheduleUtils.runAsyncTimer(new CleanKillersTask(this), Conf.KILL_ABUSE_TIME.asInt(), Conf.KILL_ABUSE_TIME.asInt(), TimeUnit.SECONDS);
        }
        if (Conf.PVP_DISABLED_FEE.asInt() != 0) {
            ScheduleUtils.runAsyncTimer(new PvPToggleFeeTask(this), 0L, 1L, TimeUnit.HOURS);
        }
        this.removeTeams();
        Bukkit.getOnlinePlayers().forEach(player -> this.createPlayer((Player)player, true));
    }

    public final ProtectionResult checkProtection(@NotNull Player damager, @NotNull Player defender) {
        CombatPlayer attacker = this.get(damager);
        CombatPlayer attacked = this.get(defender);
        if (attacker.hasOverride() || Conf.VULNERABLE_ENABLED.asBool() && this.canAttackVulnerable(attacker, attacked)) {
            return new ProtectionResult(ProtectionType.FAIL_OVERRIDE);
        }
        if (!this.globalStatus) {
            return new ProtectionResult(ProtectionType.GLOBAL_PROTECTION);
        }
        if (!attacked.getCombatWorld().isCombatAllowed()) {
            return new ProtectionResult(ProtectionType.WORLD_PROTECTION);
        }
        if (attacked.hasRespawnProtection() || attacker.hasRespawnProtection()) {
            return new ProtectionResult(ProtectionType.RESPAWN_PROTECTION, attacker.hasRespawnProtection());
        }
        if (attacked.isNewbie() || attacker.isNewbie()) {
            if (this.dependencyManager.shouldDisableProtection(damager, defender, ProtectionType.NEWBIE)) {
                return new ProtectionResult(ProtectionType.FAIL_PLUGIN_HOOK);
            }
            return new ProtectionResult(ProtectionType.NEWBIE, attacker.isNewbie());
        }
        if (!attacker.hasPvPEnabled() || !attacked.hasPvPEnabled()) {
            if (this.dependencyManager.shouldDisableProtection(damager, defender, ProtectionType.PVPDISABLED)) {
                return new ProtectionResult(ProtectionType.FAIL_PLUGIN_HOOK);
            }
            return new ProtectionResult(ProtectionType.PVPDISABLED, !attacker.hasPvPEnabled());
        }
        if (this.dependencyManager.shouldProtectAFK(defender)) {
            return new ProtectionResult(ProtectionType.AFK_PROTECTION);
        }
        return new ProtectionResult(ProtectionType.FAIL);
    }

    public final boolean canAttack(@NotNull Player attacker, @NotNull Player defender) {
        return this.checkProtection(attacker, defender).isVulnerable();
    }

    private final boolean canAttackVulnerable(CombatPlayer attacker, CombatPlayer defender) {
        return attacker.isInCombat() && defender.isInCombat() && attacker.isEnemyOf(defender) && defender.isEnemyOf(attacker);
    }

    public final CombatPlayer get(Player player) {
        boolean save;
        CombatPlayer combatPlayer = this.players.get(player.getUniqueId());
        if (combatPlayer != null) {
            return combatPlayer;
        }
        boolean bl = save = CombatUtils.isReal(player.getUniqueId()) && !CombatUtils.isNPC((Entity)player);
        if (!save) {
            return this.createPlayer(player, save);
        }
        return null;
    }

    @Nullable
    public final CombatPlayer getUnchecked(Player player) {
        return this.players.get(player.getUniqueId());
    }

    @NotNull
    public final CombatPlayer createPlayer(Player player, boolean save) {
        Objects.requireNonNull(player, "Player cannot be null");
        CombatPlayer combatPlayer = new CombatPlayer(player, this.plugin);
        Log.debug("Created " + String.valueOf(combatPlayer) + " Saved: " + save);
        if (save) {
            this.players.put(combatPlayer.getUUID(), combatPlayer);
            this.loadPlayerDataAsync(combatPlayer);
        }
        return combatPlayer;
    }

    private void loadPlayerDataAsync(CombatPlayer combatPlayer) {
        ScheduleUtils.runAsync(() -> {
            try {
                Map<String, Object> userData = this.plugin.getStorageManager().getStorage().getUserData(combatPlayer);
                PlayerData data = PlayerData.fromMap(userData);
                if (combatPlayer.getPlayer().isOnline()) {
                    combatPlayer.applyPlayerData(data);
                    if (userData.isEmpty()) {
                        this.savePlayer(combatPlayer);
                    }
                }
            }
            catch (Exception e) {
                Log.severe("Failed to load player data for " + combatPlayer.getName(), e);
            }
        });
    }

    public void savePlayer(CombatPlayer player) {
        try {
            this.plugin.getStorageManager().getStorage().saveUserData(player);
        }
        catch (Exception e) {
            Log.severe("Failed to save player data for " + player.getName(), e);
        }
    }

    public final void removePlayer(CombatPlayer player) {
        this.removePlayer(player, true);
    }

    private void removePlayer(CombatPlayer player, boolean asyncSave) {
        if (player.isInCombat()) {
            player.untag(UntagReason.LOGOUT);
        }
        if (player.isLoaded()) {
            if (asyncSave) {
                ScheduleUtils.runAsync(() -> this.savePlayer(player));
            } else {
                this.savePlayer(player);
            }
        }
        player.cleanForRemoval();
        this.players.remove(player.getUUID());
    }

    public final void applyPunishments(CombatPlayer player) {
        Player p = player.getPlayer();
        PlayerCombatLogEvent event = new PlayerCombatLogEvent(p, player);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (Conf.KILL_ON_LOGOUT.asBool()) {
            player.setPvpLogged(true);
            if (MCVersion.isAtLeast(MCVersion.V1_20_5)) {
                p.damage(3.4028234663852886E38, DamageSource.builder((DamageType)DamageType.GENERIC_KILL).build());
            } else {
                p.setHealth(0.0);
            }
            if (p.getHealth() > 0.0) {
                Log.warning("Failed to kill player on logout. It's possible the damage to the player was blocked by another plugin.");
                p.setHealth(0.0);
            }
            player.setPvpLogged(false);
        }
        if (Conf.FINE_AMOUNT.asDouble() != 0.0) {
            player.applyFine();
        }
    }

    public void handlePluginDisable() {
        this.tagTask.cancel();
        for (CombatPlayer p : new HashSet<CombatPlayer>(this.players.values())) {
            this.removePlayer(p, false);
        }
        this.removeTeams();
        Log.infoColor(String.valueOf(ChatColor.RED) + "Saving player data to storage...");
    }

    private void removeTeams() {
        Objective health;
        Team pvpoff;
        ScoreboardManager scoreboardManager = Bukkit.getScoreboardManager();
        if (scoreboardManager == null) {
            return;
        }
        scoreboardManager.getMainScoreboard().getTeams().forEach(team -> {
            if (team.getName().startsWith("PVP-") && team.getName().length() == 16) {
                Log.debug("Unregistered leftover team: " + team.getName() + " Entries: " + String.valueOf(team.getEntries()));
                team.unregister();
            }
        });
        Scoreboard scoreboard = scoreboardManager.getMainScoreboard();
        Team pvpon = scoreboard.getTeam("PvPOn");
        if (pvpon != null) {
            pvpon.unregister();
        }
        if ((pvpoff = scoreboard.getTeam("PvPOff")) != null) {
            pvpoff.unregister();
        }
        if ((health = scoreboard.getObjective("PvP_Health")) != null) {
            health.unregister();
        }
    }

    public boolean getGlobalStatus() {
        return this.globalStatus;
    }

    public void setGlobalStatus(boolean globalStatus) {
        this.globalStatus = globalStatus;
    }

    public final Map<UUID, CombatPlayer> getPlayers() {
        return this.players;
    }

    public final Set<CombatPlayer> getPlayersInCombat() {
        return this.tagTask.getTaggedPlayers();
    }

    @NotNull
    public final PvPManager getPlugin() {
        return this.plugin;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }
}

