/*
 * Decompiled with CFR 0.152.
 */
package me.chancesd.pvpmanager.manager;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import me.chancesd.pvpmanager.PvPManager;
import me.chancesd.pvpmanager.integration.BaseDependency;
import me.chancesd.pvpmanager.integration.DependencyException;
import me.chancesd.pvpmanager.integration.Hook;
import me.chancesd.pvpmanager.integration.hook.EssentialsHook;
import me.chancesd.pvpmanager.integration.hook.GriefPreventionHook;
import me.chancesd.pvpmanager.integration.hook.HuskClaimsHook;
import me.chancesd.pvpmanager.integration.hook.HuskTownsHook;
import me.chancesd.pvpmanager.integration.hook.LibsDisguisesHook;
import me.chancesd.pvpmanager.integration.hook.SimpleClansHook;
import me.chancesd.pvpmanager.integration.hook.TABHook;
import me.chancesd.pvpmanager.integration.hook.TownyHook;
import me.chancesd.pvpmanager.integration.hook.VaultHook;
import me.chancesd.pvpmanager.integration.hook.placeholderapi.PlaceHolderAPIHook;
import me.chancesd.pvpmanager.integration.hook.worldguard.WorldGuardFlagHandler;
import me.chancesd.pvpmanager.integration.hook.worldguard.WorldGuardModernHook;
import me.chancesd.pvpmanager.integration.type.AFKDependency;
import me.chancesd.pvpmanager.integration.type.Dependency;
import me.chancesd.pvpmanager.integration.type.DisguiseDependency;
import me.chancesd.pvpmanager.integration.type.ForceToggleDependency;
import me.chancesd.pvpmanager.integration.type.GodDependency;
import me.chancesd.pvpmanager.integration.type.GroupDependency;
import me.chancesd.pvpmanager.integration.type.RegionDependency;
import me.chancesd.pvpmanager.integration.type.WorldGuardDependency;
import me.chancesd.pvpmanager.listener.MoveListener;
import me.chancesd.pvpmanager.listener.MoveListener1_9;
import me.chancesd.pvpmanager.player.ProtectionType;
import me.chancesd.pvpmanager.sdutils.scheduler.ScheduleUtils;
import me.chancesd.pvpmanager.sdutils.utils.Log;
import me.chancesd.pvpmanager.sdutils.utils.MCVersion;
import me.chancesd.pvpmanager.sdutils.utils.Utils;
import me.chancesd.pvpmanager.setting.Conf;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class DependencyManager {
    private final Map<Hook, Dependency> dependencies = new EnumMap<Hook, Dependency>(Hook.class);
    private final ArrayList<GroupDependency> attackChecks = new ArrayList();
    private final ArrayList<RegionDependency> regionChecks = new ArrayList();
    private final ArrayList<GodDependency> godChecks = new ArrayList();
    private final ArrayList<DisguiseDependency> disguiseChecks = new ArrayList();
    private final ArrayList<ForceToggleDependency> togglePvPChecks = new ArrayList();
    private final ArrayList<AFKDependency> afkChecks = new ArrayList();

    public void onLoadSetup() {
        if (Hook.WORLDGUARD.getPlugin() != null && Utils.isVersionAtLeast(Utils.stripTags(Hook.WORLDGUARD.getVersion()), "7.0") && !PvPManager.getInstance().isReloading()) {
            WorldGuardFlagHandler.initializeFlags();
        }
    }

    public void onEnableSetup() {
        if (Bukkit.getPluginManager().getPlugin("TAB-Bridge") != null && (Conf.NAMETAG_COMBAT_ENABLED.asBool() || Conf.TOGGLE_NAMETAG_ENABLED.asBool())) {
            Log.info("TAB-Bridge detected. Nametags in combat disabled due to incompatibility. Use the prefix/suffix placeholders instead");
            Conf.NAMETAG_COMBAT_ENABLED.disable();
            Conf.TOGGLE_NAMETAG_ENABLED.disable();
        }
        List<Hook> failedHooks = this.setupHooks(Hook.values());
        ScheduleUtils.runPlatformTask(() -> {
            Hook[] hooks = (Hook[])Arrays.stream(Hook.values()).filter(hook -> hook.isEnabled() && !this.isDependencyEnabled((Hook)((Object)((Object)hook))) && !failedHooks.contains(hook)).toArray(Hook[]::new);
            if (hooks.length == 0) {
                return;
            }
            List softDepend = PvPManager.getInstance().getDescription().getSoftDepend();
            if (Arrays.stream(hooks).anyMatch(h -> softDepend.contains(h.toString()))) {
                Log.severe("Found plugins that PvPManager declared as soft dependencies but were still loaded out of order.");
                Log.severe("If you're not using any server flags that cause this, please report it to your server software developers.");
            }
            Log.infoColor(String.valueOf(ChatColor.LIGHT_PURPLE) + "Delayed checking for any missing hooks...");
            this.setupHooks(hooks);
        });
    }

    public void onDisableCleanup() {
        if (Hook.WORLDGUARD.isEnabled() && Utils.isVersionAtLeast(Utils.stripTags(Hook.WORLDGUARD.getVersion()), "7.0")) {
            WorldGuardFlagHandler.shutdown();
        }
    }

    private List<Hook> setupHooks(Hook ... hooks) {
        ArrayList<Hook> failedHooks = new ArrayList<Hook>();
        for (Hook hook : hooks) {
            try {
                if (!hook.isEnabled()) {
                    if (hook.getDisabledWarning() != null) {
                        Log.warning(hook.getDisabledWarning());
                    }
                    hook.getDisabledAction().run();
                    continue;
                }
                this.attemptHookingInto(hook);
            }
            catch (ClassCastException | NoClassDefFoundError | NoSuchFieldError | NoSuchMethodError e) {
                Log.warning("Your " + String.valueOf((Object)hook) + " version is currently unsupported: " + hook.getDescription().getFullName());
                Log.warning(String.valueOf((Object)hook) + " support disabled");
                failedHooks.add(hook);
            }
            catch (DependencyException e) {
                Log.warning(e.getMessage());
                hook.getDisabledAction().run();
                failedHooks.add(hook);
            }
            catch (ExceptionInInitializerError e) {
                Log.warning("Exception initializing " + String.valueOf((Object)hook));
            }
            catch (Exception | LinkageError e) {
                Log.warning("Failed to enable support for " + hook.getDescription().getFullName() + ". Is " + String.valueOf((Object)hook) + " up to date?", e);
                failedHooks.add(hook);
            }
        }
        return failedHooks;
    }

    private boolean attemptHookingInto(Hook hook) {
        BaseDependency baseDependency;
        switch (hook) {
            case SIMPLECLANS: {
                Dependency dependency;
                baseDependency = dependency = new SimpleClansHook(hook);
                break;
            }
            case VAULT: {
                Dependency dependency;
                baseDependency = dependency = new VaultHook(hook);
                break;
            }
            case WORLDGUARD: {
                Dependency dependency;
                if (Utils.isVersionAtLeast(Utils.stripTags(hook.getVersion()), "7.0")) {
                    baseDependency = dependency = new WorldGuardModernHook(hook);
                    break;
                }
                try {
                    Class<?> clazz = Class.forName("me.chancesd.pvpmanager.integration.hook.worldguard.WorldGuardLegacyHook");
                    Constructor<?> constructor = clazz.getConstructor(Hook.class);
                    WorldGuardDependency legacyHook = (WorldGuardDependency)constructor.newInstance(new Object[]{hook});
                    baseDependency = dependency = legacyHook;
                    break;
                }
                catch (Exception e) {
                    throw new DependencyException("Failed to load WorldGuardLegacyHook", e, hook);
                }
            }
            case ESSENTIALS: {
                Dependency dependency;
                baseDependency = dependency = new EssentialsHook(hook);
                break;
            }
            case PLACEHOLDERAPI: {
                Dependency dependency;
                baseDependency = dependency = new PlaceHolderAPIHook(hook);
                break;
            }
            case LIBSDISGUISES: {
                Dependency dependency;
                baseDependency = dependency = new LibsDisguisesHook(hook);
                break;
            }
            case TOWNY: {
                Dependency dependency;
                baseDependency = dependency = new TownyHook(hook);
                break;
            }
            case HUSKTOWNS: {
                Dependency dependency;
                baseDependency = dependency = new HuskTownsHook(hook);
                break;
            }
            case HUSKCLAIMS: {
                Dependency dependency;
                baseDependency = dependency = new HuskClaimsHook(hook);
                break;
            }
            case GRIEFPREVENTION: {
                Dependency dependency;
                baseDependency = dependency = new GriefPreventionHook(hook);
                break;
            }
            case TAB: {
                Dependency dependency;
                baseDependency = dependency = new TABHook(hook);
                break;
            }
            default: {
                Dependency dependency;
                baseDependency = dependency = new BaseDependency(hook);
            }
        }
        BaseDependency dependency = baseDependency;
        return this.registerDependency(dependency);
    }

    public final boolean canAttack(Player attacker, Player defender) {
        for (GroupDependency pvPlugin : this.attackChecks) {
            if (pvPlugin.canAttack(attacker, defender)) continue;
            return false;
        }
        return true;
    }

    public final boolean canAttackAt(Player p, Location l) {
        for (RegionDependency regionPlugin : this.regionChecks) {
            if (regionPlugin.canAttackAt(p, l)) continue;
            return false;
        }
        return true;
    }

    public final void disableGodMode(Player p) {
        for (GodDependency godPlugin : this.godChecks) {
            if (!godPlugin.hasGodMode(p)) continue;
            godPlugin.disableGodMode(p);
        }
    }

    public final void disableDisguise(Player p) {
        for (DisguiseDependency disguisePlugin : this.disguiseChecks) {
            if (!disguisePlugin.isDisguised(p)) continue;
            disguisePlugin.unDisguise(p);
        }
    }

    public final boolean shouldDisableProtection(@NotNull Player attacker, @NotNull Player defender, ProtectionType reason) {
        for (ForceToggleDependency togglePvPPlugin : this.togglePvPChecks) {
            if (!togglePvPPlugin.shouldDisable(attacker, defender, reason)) continue;
            return true;
        }
        return false;
    }

    public final boolean shouldDisableProtection(Player defender) {
        for (ForceToggleDependency togglePvPPlugin : this.togglePvPChecks) {
            if (!togglePvPPlugin.shouldDisable(defender)) continue;
            return true;
        }
        return false;
    }

    public final boolean shouldProtectAFK(Player player) {
        for (AFKDependency afkPlugin : this.afkChecks) {
            if (!afkPlugin.isAFK(player)) continue;
            return true;
        }
        return false;
    }

    public void startListeners(PvPManager plugin) {
        if (Conf.PUSHBACK_ENABLED.asBool() && !this.regionChecks.isEmpty()) {
            if (MCVersion.isAtLeast(MCVersion.V1_9)) {
                Bukkit.getPluginManager().registerEvents((Listener)new MoveListener1_9(plugin.getPlayerManager(), this), (Plugin)plugin);
            } else if (MCVersion.isAtLeast(MCVersion.V1_8)) {
                Bukkit.getPluginManager().registerEvents((Listener)new MoveListener(plugin.getPlayerManager()), (Plugin)plugin);
            } else {
                Log.warning("Pushback on border hopping not available for 1.7.10 or below! Feature disabled!");
                Conf.PUSHBACK_ENABLED.disable();
            }
        }
        if (this.isDependencyEnabled(Hook.WORLDGUARD)) {
            ((WorldGuardDependency)this.getDependency(Hook.WORLDGUARD)).startListener(plugin.getPlayerManager());
        }
    }

    public boolean isDependencyEnabled(Hook d) {
        return this.dependencies.containsKey((Object)d);
    }

    public Dependency getDependency(Hook h) {
        return this.dependencies.get((Object)h);
    }

    public boolean registerDependency(Dependency dep) {
        AFKDependency afkHook;
        ForceToggleDependency togglePvPHook;
        this.dependencies.put(dep.getHook(), dep);
        if (dep instanceof GroupDependency) {
            GroupDependency pvpHook = (GroupDependency)dep;
            this.attackChecks.add(pvpHook);
        }
        if (dep instanceof RegionDependency) {
            RegionDependency regionHook = (RegionDependency)dep;
            this.regionChecks.add(regionHook);
        }
        if (dep instanceof GodDependency) {
            GodDependency godHook = (GodDependency)dep;
            this.godChecks.add(godHook);
        }
        if (dep instanceof DisguiseDependency) {
            DisguiseDependency disguiseHook = (DisguiseDependency)dep;
            this.disguiseChecks.add(disguiseHook);
        }
        if (dep instanceof ForceToggleDependency && (togglePvPHook = (ForceToggleDependency)dep).shouldDisableProtection()) {
            this.togglePvPChecks.add(togglePvPHook);
        }
        if (dep instanceof AFKDependency && (afkHook = (AFKDependency)dep).shouldProtectAFK()) {
            this.afkChecks.add(afkHook);
        }
        return true;
    }

    public void unregisterDependency(Dependency dep) {
        this.dependencies.remove((Object)dep.getHook());
        this.attackChecks.remove(dep);
        this.regionChecks.remove(dep);
        this.godChecks.remove(dep);
        this.disguiseChecks.remove(dep);
        this.togglePvPChecks.remove(dep);
    }

    public JavaPlugin getDependencyMainClass(Hook h) {
        if (this.isDependencyEnabled(h)) {
            return this.dependencies.get((Object)h).getPlugin();
        }
        return null;
    }

    public final Economy getEconomy() {
        if (this.isDependencyEnabled(Hook.VAULT)) {
            return ((VaultHook)this.dependencies.get((Object)Hook.VAULT)).getEconomy();
        }
        return null;
    }

    public Collection<Dependency> getDependencies() {
        return this.dependencies.values();
    }
}

